/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.TileScheduler;

public class TilesByteGetter {
    byte[] bb;
    RenderedImage ri;
    int tileWidth;
    int tileHeight;
    int width;
    int height;
    static final boolean usePrefetching;
    static int multithreadingLevel;

    public TilesByteGetter(RenderedImage ri) {
        this.ri = ri;
        this.tileWidth = ri.getTileWidth();
        this.tileHeight = ri.getTileHeight();
        this.width = ri.getWidth();
        this.height = ri.getHeight();
    }

    public byte[] getBytes() throws InterruptedException {
        if (this.ri instanceof BufferedImage) {
            Raster wr = this.ri.getTile(0, 0);
            return ((DataBufferByte)wr.getDataBuffer()).getData();
        }
        int nX = this.ri.getNumXTiles();
        int nY = this.ri.getNumYTiles();
        if (nX == 1 && nY == 1) {
            Raster wr = this.ri.getTile(0, 0);
            return ((DataBufferByte)wr.getDataBuffer()).getData();
        }
        int size = this.ri.getHeight() * this.ri.getWidth() * this.ri.getSampleModel().getNumBands();
        this.bb = new byte[size];
        if (multithreadingLevel != 1) {
            int minTx = this.ri.getMinTileX();
            int minTy = this.ri.getMinTileY();
            int TH = multithreadingLevel;
            TileScheduler ts = JAI.getDefaultInstance().getTileScheduler();
            ArrayList<Point> tiles = new ArrayList<Point>();
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
            ArrayList<ByteGetter> queueX = new ArrayList<ByteGetter>();
            ThreadPoolExecutor ex = new ThreadPoolExecutor(TH, TH, 10000L, TimeUnit.SECONDS, queue);
            ex.prestartAllCoreThreads();
            int tx = 0;
            int ty = 0;
            for (int j = 0; j < nY; ++j) {
                for (int i = 0; i < nX; ++i) {
                    tx = minTx + i;
                    ty = minTy + j;
                    tiles.add(new Point(tx, ty));
                    queueX.add(new ByteGetter(this.ri, tx, ty));
                }
            }
            Point[] tilesArray = tiles.toArray(new Point[tiles.size()]);
            ts.prefetchTiles(PlanarImage.wrapRenderedImage((RenderedImage)this.ri), tilesArray);
            ex.invokeAll(queueX);
            ex.shutdown();
        } else {
            if (usePrefetching) {
                int minTx = this.ri.getMinTileX();
                int minTy = this.ri.getMinTileY();
                TileScheduler ts = JAI.getDefaultInstance().getTileScheduler();
                ArrayList<Point> tiles = new ArrayList<Point>();
                int tx = 0;
                int ty = 0;
                for (int j = 0; j < nY; ++j) {
                    for (int i = 0; i < nX; ++i) {
                        tx = minTx + i;
                        ty = minTy + j;
                        tiles.add(new Point(tx, ty));
                    }
                }
                Point[] tilesArray = tiles.toArray(new Point[tiles.size()]);
                ts.prefetchTiles(PlanarImage.wrapRenderedImage((RenderedImage)this.ri), tilesArray);
            }
            this.bb = ((DataBufferByte)this.ri.getData().getDataBuffer()).getData();
        }
        return this.bb;
    }

    static {
        String mt = System.getProperty("it.geosolutions.tilesgetter.multithreading");
        if (mt != null) {
            try {
                multithreadingLevel = Integer.parseInt(mt);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Error parsing " + mt + " as integer; using default 1");
                multithreadingLevel = 1;
            }
        } else {
            multithreadingLevel = 1;
        }
        usePrefetching = Boolean.getBoolean("it.geosolutions.tilesgetter.usePrefetching");
        System.out.println("Multithreading level: " + multithreadingLevel + " prefetching: " + usePrefetching);
    }

    private class ByteGetter
    implements Callable<Integer> {
        RenderedImage ri;
        int tileX;
        int tileY;

        public ByteGetter(RenderedImage ri, int tileX, int tileY) {
            this.ri = ri;
            this.tileX = tileX;
            this.tileY = tileY;
        }

        @Override
        public Integer call() {
            try {
                Raster tile = this.ri.getTile(this.tileX, this.tileY);
                int nBands = this.ri.getSampleModel().getNumBands();
                DataBufferByte dbb = (DataBufferByte)tile.getDataBuffer();
                byte[] bytes = dbb.getData();
                int w = TilesByteGetter.this.tileWidth * (this.tileX + 1) > TilesByteGetter.this.width ? TilesByteGetter.this.width - this.tileX * TilesByteGetter.this.tileWidth : TilesByteGetter.this.tileWidth;
                int h = TilesByteGetter.this.tileHeight * (this.tileY + 1) > TilesByteGetter.this.height ? TilesByteGetter.this.height - this.tileY * TilesByteGetter.this.tileHeight : TilesByteGetter.this.tileHeight;
                int localStripeLength = w * nBands;
                int stripeLength = TilesByteGetter.this.tileWidth * nBands;
                int tileSkipX = stripeLength * this.tileX;
                for (int j = 0; j < h; ++j) {
                    int offset = (j + TilesByteGetter.this.tileHeight * this.tileY) * TilesByteGetter.this.width * nBands + tileSkipX;
                    System.arraycopy(bytes, stripeLength * j, TilesByteGetter.this.bb, offset, localStripeLength);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        }
    }
}

