/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.exif.EXIFMetadata;
import it.geosolutions.imageio.plugins.exif.EXIFUtilities;
import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriteParam;
import it.geosolutions.imageio.utilities.ImageOutputStreamAdapter2;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.opimage.CopyOpImage;
import org.libjpegturbo.turbojpeg.TJCompressor;

public class TurboJpegImageWriter
extends ImageWriter {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.turbojpeg");
    private ImageOutputStream outputStream = null;

    public TurboJpegImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        TurboJpegImageWriteParam wparam = new TurboJpegImageWriteParam();
        wparam.setCompressionMode(2);
        wparam.setCompressionType("JPEG");
        wparam.setCompressionQuality(0.75f);
        return wparam;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public void setOutput(Object output) {
        if (output instanceof OutputStream) {
            this.outputStream = new ImageOutputStreamAdapter2((OutputStream)output);
        } else if (output instanceof ImageOutputStreamAdapter2) {
            this.outputStream = (ImageOutputStreamAdapter2)output;
        } else if (output instanceof File) {
            try {
                this.outputStream = new ImageOutputStreamAdapter2(new FileOutputStream((File)output));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        super.setOutput(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata metadata, IIOImage image, ImageWriteParam writeParam) throws IOException {
        RenderedImage srcImage = image.getRenderedImage();
        srcImage = this.refineImage(srcImage);
        ComponentSampleModel sm = (ComponentSampleModel)srcImage.getSampleModel();
        int[] bandOffsets = sm.getBandOffsets();
        TurboJpegImageWriteParam param = (TurboJpegImageWriteParam)writeParam;
        if (param == null) {
            param = (TurboJpegImageWriteParam)this.getDefaultWriteParam();
        }
        EXIFMetadata exif = param.getExif();
        int componentSampling = param.getComponentSubsampling();
        int quality = (int)(param.getCompressionQuality() * 100.0f);
        int pf = 0;
        if (bandOffsets.length == 3) {
            if (componentSampling == -1) {
                componentSampling = 2;
            }
            if (bandOffsets[0] == 2 && bandOffsets[2] == 0) {
                pf = 1;
            }
        } else if (bandOffsets.length == 1 && componentSampling == -1) {
            pf = 6;
            componentSampling = 3;
        } else {
            throw new IllegalArgumentException("TurboJPEG won't work with this type of sampleModel");
        }
        if (componentSampling < 0) {
            throw new IOException("Subsampling level not set");
        }
        int pixelsize = sm.getPixelStride();
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int pitch = pixelsize * width;
        TJCompressor compressor = null;
        try {
            byte[] outputImageData;
            Rectangle rect = new Rectangle(srcImage.getMinX(), srcImage.getMinY(), srcImage.getWidth(), srcImage.getHeight());
            Raster data = srcImage.getData(rect);
            byte[] inputImageData = ((DataBufferByte)data.getDataBuffer()).getData();
            try {
                compressor = new TJCompressor();
                compressor.setSourceImage(inputImageData, width, pitch, height, pf);
                compressor.setJPEGQuality(quality);
                compressor.setSubsamp(componentSampling);
                outputImageData = compressor.compress(2048);
            }
            catch (Exception ex) {
                throw new IOException("Error in turbojpeg comressor: " + ex.getMessage(), ex);
            }
            int imageDataSize = compressor.getCompressedSize();
            if (exif != null) {
                EXIFUtilities.insertEXIFintoStream(((ImageOutputStreamAdapter2)this.outputStream).getOs(), outputImageData, imageDataSize, exif);
            } else {
                this.outputStream.write(outputImageData, 0, imageDataSize);
            }
        }
        finally {
            if (compressor != null) {
                try {
                    compressor.close();
                }
                catch (Exception t) {
                    LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                }
            }
        }
    }

    private RenderedImage refineImage(RenderedImage srcImage) {
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        int minX = srcImage.getMinX();
        int minY = srcImage.getMinY();
        int tw = srcImage.getTileWidth();
        int th = srcImage.getTileHeight();
        if (tw > w || th > h) {
            RenderingHints hints = null;
            ImageLayout layout = null;
            if (srcImage instanceof RenderedOp) {
                hints = ((RenderedOp)srcImage).getRenderingHints();
                layout = hints != null && hints.containsKey(JAI.KEY_IMAGE_LAYOUT) ? (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT) : new ImageLayout(srcImage);
            } else {
                layout = new ImageLayout(srcImage);
                hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            }
            layout.setTileHeight(h);
            layout.setTileWidth(w);
            layout.setTileGridXOffset(minX);
            layout.setTileGridYOffset(minY);
            layout.setMinX(minX);
            layout.setMinY(minY);
            layout.setWidth(w);
            layout.setHeight(h);
            srcImage = new CopyOpImage(srcImage, (Map)hints, layout);
        }
        return srcImage;
    }
}

