/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileImageOutputStreamExtImpl
extends ImageOutputStreamImpl
implements ImageOutputStream,
AccessibleStream<File> {
    private EnhancedRandomAccessFile eraf;
    private File file;
    private boolean isClosed;

    public FileImageOutputStreamExtImpl(File file) throws FileNotFoundException, IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw");
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public FileImageOutputStreamExtImpl(File file, int bufSize) throws FileNotFoundException, IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw", bufSize);
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.eraf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int nbytes = this.eraf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.eraf.write(b);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.eraf.write(b, off, len);
        this.streamPos += (long)len;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.eraf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.eraf.seek(pos);
        this.streamPos = this.eraf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isClosed) {
                super.close();
                this.eraf.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "FileImageOutputStreamExtImpl which points to " + this.file.toString();
    }

    @Override
    public File getTarget() {
        return this.file;
    }

    @Override
    public Class<File> getBinding() {
        return File.class;
    }
}

