/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.plugins.nitronitf.NITFReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NITFReaderSpi
extends ImageReaderSpi {
    private static final Log log = LogFactory.getLog(NITFReaderSpi.class);

    public NITFReaderSpi() {
        super("NITRO", "1.0", new String[]{"NITF", "nitf", "NSIF"}, new String[]{"ntf", "nitf", "nsf"}, new String[]{"image/x-ntf", "image/x-nitf"}, NITFReader.class.getName(), new Class[]{File.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        boolean result = source instanceof File;
        if (result) {
            result = NITFReaderSpi.isNITF((File)source);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNITF(File file) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] firstFour = new byte[4];
            fin.read(firstFour);
            boolean bl = new String(firstFour).equals("NITF");
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new NITFReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "NITF 2.0/2.1 Reader";
    }
}

