/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriteParam;
import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriter;
import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriterSpi;
import it.geosolutions.imageio.plugins.nitronitf.IOFileInputStream;
import it.geosolutions.imageio.plugins.nitronitf.NITFImageWriteParam;
import it.geosolutions.imageio.plugins.nitronitf.NITFUtilities;
import it.geosolutions.imageio.plugins.nitronitf.wrapper.HeaderWrapper;
import it.geosolutions.imageio.plugins.nitronitf.wrapper.ImageWrapper;
import it.geosolutions.imageio.plugins.nitronitf.wrapper.NITFProperties;
import it.geosolutions.imageio.plugins.nitronitf.wrapper.ShapeFileWrapper;
import it.geosolutions.imageio.plugins.nitronitf.wrapper.TextWrapper;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.output.FileImageOutputStreamExt;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import nitf.BandInfo;
import nitf.BandSource;
import nitf.DESegment;
import nitf.Extensions;
import nitf.FileHeader;
import nitf.IOHandle;
import nitf.IOInterface;
import nitf.ImageSegment;
import nitf.ImageSource;
import nitf.ImageSubheader;
import nitf.ImageWriter;
import nitf.MemorySource;
import nitf.NITFException;
import nitf.Record;
import nitf.SegmentSource;
import nitf.SegmentWriter;
import nitf.StreamIOWriteHandler;
import nitf.TRE;
import nitf.TextSegment;
import nitf.TextSubheader;
import nitf.Version;
import nitf.WriteHandler;
import nitf.Writer;
import org.apache.commons.io.FilenameUtils;

public class NITFImageWriter
extends javax.imageio.ImageWriter {
    private File outputFile;
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.nitronitf.NITFImageWriter");
    private static final JP2KKakaduImageWriterSpi KAKADU_SPI = new JP2KKakaduImageWriterSpi();
    private static final String JP2_TEMP_FOLDER;
    public static final String JP2_TEMP_FOLDER_PROPERTY = "nitf.imageio.jp2folder";
    private static final boolean DO_VALIDATION = true;

    public NITFImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setOutput(Object output) {
        if (output instanceof FileImageOutputStreamExt) {
            this.outputFile = ((FileImageOutputStreamExt)output).getFile();
        } else if (output instanceof File) {
            this.outputFile = (File)output;
        } else {
            throw new IllegalArgumentException("unsupported output type");
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        throw new UnsupportedOperationException("getDefaultStreamMetadata not implemented yet");
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException("getDefaultImageMetadata not implemented yet");
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    private static void initFileHeader(Record record, HeaderWrapper headerWrapper) throws NITFException {
        Map<String, Map<String, String>> tresMap;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Populating file header");
        }
        FileHeader header = record.getHeader();
        NITFUtilities.setField("FHDR", header.getFileHeader(), "NITF");
        NITFUtilities.setField("FVER", header.getFileVersion(), "02.10");
        NITFUtilities.setField("STYPE", header.getSystemType(), "BF01");
        if (headerWrapper != null) {
            NITFUtilities.setField("OSTAID", header.getOriginStationID(), headerWrapper.getOriginStationId());
            NITFUtilities.setField("FDT", header.getFileDateTime(), headerWrapper.getDateTime());
            NITFUtilities.setField("FTITLE", header.getFileTitle(), headerWrapper.getTitle());
            NITFUtilities.setField("FSCLAS", header.getClassification(), headerWrapper.getSecurityClassification());
            NITFUtilities.setField("FSCLSY", header.getSecurityGroup().getClassificationSystem(), headerWrapper.getSecurityClassificationSystem());
            NITFUtilities.setField("ENCRYP", header.getEncrypted(), Integer.toString(headerWrapper.getEncrypted()));
            NITFUtilities.setField("FBKGC", header.getBackgroundColor(), headerWrapper.getBackgroundColor());
            NITFUtilities.setField("ONAME", header.getOriginatorName(), headerWrapper.getOriginatorName());
            NITFUtilities.setField("OPHONE", header.getOriginatorPhone(), headerWrapper.getOriginatorPhone());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "file header has been setup");
        }
        if ((tresMap = headerWrapper.getTres()) != null && !tresMap.isEmpty()) {
            Extensions extendedSection = header.getExtendedSection();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Populating Main Header TREs");
            }
            Set<String> keys = tresMap.keySet();
            for (String treName : keys) {
                Map<String, String> fieldsMapping = tresMap.get(treName);
                TRE tre = NITFImageWriter.setTRE(treName, fieldsMapping);
                extendedSection.appendTRE(tre);
            }
        }
    }

    private static void addImageSegment(Record record, List<ImageWrapper> images, FileImageInputStreamExt fis, NITFUtilities.WriteCompression compression) throws NITFException, IOException {
        ImageSegment segment = null;
        ImageSubheader subheader = null;
        int img = 0;
        for (ImageWrapper image : images) {
            NITFUtilities.WriteCompression writeCompression = img == 0 ? compression : NITFUtilities.WriteCompression.UNCOMPRESSED;
            segment = record.newImageSegment();
            subheader = segment.getSubheader();
            double bpppb = NITFImageWriter.initImageSubHeader(image, subheader, writeCompression, fis);
            if (img == 0) {
                NITFImageWriter.initTREs(subheader, image, writeCompression, bpppb);
            }
            ++img;
        }
    }

    private static void initTREs(ImageSubheader subheader, ImageWrapper wrapper, NITFUtilities.WriteCompression compression, double bpppb) throws NITFException {
        Extensions extendedSection = subheader.getExtendedSection();
        boolean isSingleBand = wrapper.getImage().getSampleModel().getNumBands() == 1;
        Map<String, Map<String, String>> tresMap = wrapper.getTres();
        if (tresMap != null && !tresMap.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Populating TRE");
            }
            Set<String> keys = tresMap.keySet();
            for (String treName : keys) {
                Map<String, String> fieldsMapping = tresMap.get(treName);
                TRE tre = NITFImageWriter.setTRE(treName, fieldsMapping);
                extendedSection.appendTRE(tre);
            }
        }
        if (compression != NITFUtilities.WriteCompression.UNCOMPRESSED) {
            NITFImageWriter.setJ2KLRA(extendedSection, compression, isSingleBand, bpppb);
        }
    }

    private static void setJ2KLRA(Extensions extendedSection, NITFUtilities.WriteCompression compression, boolean isSingleBand, double lastRate) throws NITFException {
        String compressionString;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Populating J2KLRA TRE");
        }
        String origData = (compressionString = compression.toString()).startsWith("NPJE") ? "0" : (compressionString.startsWith("EPJE") ? "2" : "8");
        boolean isVL = compression.getCompression() == JP2KKakaduImageWriteParam.Compression.LOSSY;
        int nLayers = compression.getQualityLayers();
        double[] bitRates = compression.getBitRates();
        LinkedHashMap<String, String> j2klraMapping = new LinkedHashMap<String, String>();
        j2klraMapping.put("ORIG", origData);
        j2klraMapping.put("NLEVELS_O", "5");
        j2klraMapping.put("NBANDS_O", isSingleBand ? "1" : "3");
        j2klraMapping.put("NLAYERS_O", String.valueOf(nLayers));
        for (int i = 0; i < nLayers; ++i) {
            double rate = i != nLayers - 1 ? bitRates[i] : (isVL ? bitRates[i] : (!Double.isNaN(lastRate) ? lastRate : NITFUtilities.BPPPB[i - 1]));
            String bitrate = NITFImageWriter.customFormat(rate);
            j2klraMapping.put("LAYER_ID[" + i + "]", String.valueOf(i));
            j2klraMapping.put("BITRATE[" + i + "]", bitrate);
        }
        extendedSection.appendTRE(NITFImageWriter.setTRE("J2KLRA", j2klraMapping));
    }

    private static double initImageSubHeader(ImageWrapper imageWrapper, ImageSubheader subheader, NITFUtilities.WriteCompression compression, FileImageInputStreamExt fis) throws IOException, NITFException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Populating ImageSubHeader");
        }
        RenderedImage ri = imageWrapper.getImage();
        List<String> comments = imageWrapper.getComments();
        boolean isJP2 = compression != null && compression != NITFUtilities.WriteCompression.UNCOMPRESSED;
        int nCols = ri.getWidth();
        int nRows = ri.getHeight();
        int nBits = ri.getSampleModel().getSampleSize(0);
        String numBlocksPerRow = isJP2 ? String.valueOf((int)Math.ceil((double)nCols / 1024.0)) : String.valueOf(1);
        String numBlocksPerCol = isJP2 ? String.valueOf((int)Math.ceil((double)nRows / 1024.0)) : String.valueOf(1);
        String numPixelsPerVertBlock = isJP2 ? String.valueOf(1024) : "0000";
        String numPixelsPerHorizBlock = isJP2 ? String.valueOf(1024) : "0000";
        double ratio = Double.NaN;
        NITFUtilities.setField("IM", subheader.getFilePartType(), "IM");
        NITFUtilities.setField("IID1", subheader.getImageId(), imageWrapper.getId());
        NITFUtilities.setField("IDATIM", subheader.getImageDateAndTime(), imageWrapper.getDateTime());
        NITFUtilities.setField("IID2", subheader.getImageTitle(), imageWrapper.getTitle());
        NITFUtilities.setField("ISCLAS", subheader.getImageSecurityClass(), imageWrapper.getSecurityClassification());
        NITFUtilities.setField("ISCLSY", subheader.getSecurityGroup().getClassificationSystem(), imageWrapper.getSecurityClassificationSystem());
        NITFUtilities.setField("ENCRYP", subheader.getEncrypted(), Integer.toString(imageWrapper.getEncrypted()));
        NITFUtilities.setField("ISORCE", subheader.getImageSource(), imageWrapper.getSource());
        NITFUtilities.setField("NROWS", subheader.getNumRows(), String.valueOf(nRows));
        NITFUtilities.setField("NCOLS", subheader.getNumCols(), String.valueOf(nCols));
        NITFUtilities.setField("PVTYPE", subheader.getPixelValueType(), "INT");
        NITFUtilities.setField("IREP", subheader.getImageRepresentation(), imageWrapper.getRepresentation().toString());
        NITFUtilities.setField("ICAT", subheader.getImageCategory(), imageWrapper.getImageCategory().toString());
        NITFUtilities.setField("ABPP", subheader.getActualBitsPerPixel(), Integer.toString(nBits));
        NITFUtilities.setField("PJUST", subheader.getPixelJustification(), imageWrapper.getPixelJustification());
        NITFUtilities.setField("ICORDS", subheader.getImageCoordinateSystem(), imageWrapper.getImageCoordinateSystem());
        NITFUtilities.setField("IGEOLO", subheader.getCornerCoordinates(), imageWrapper.getIgeolo());
        if (comments != null && !comments.isEmpty()) {
            int i = 0;
            for (String comment : comments) {
                subheader.insertImageComment(comment, i++);
            }
        }
        ratio = NITFImageWriter.setImageCompression(subheader, compression, ri, fis);
        NITFImageWriter.setImageBands(subheader, imageWrapper);
        NITFUtilities.setField("ISYNC", subheader.getImageSyncCode(), "0");
        NITFUtilities.setField("IMODE", subheader.getImageMode(), "B");
        NITFUtilities.setField("NBPR", subheader.getNumBlocksPerRow(), numBlocksPerRow);
        NITFUtilities.setField("NBPC", subheader.getNumBlocksPerCol(), numBlocksPerCol);
        NITFUtilities.setField("NPPBH", subheader.getNumPixelsPerHorizBlock(), numPixelsPerHorizBlock);
        NITFUtilities.setField("NPPBV", subheader.getNumPixelsPerVertBlock(), numPixelsPerVertBlock);
        NITFUtilities.setField("NBPP", subheader.getNumBitsPerPixel(), Integer.toString(nBits));
        NITFUtilities.setField("IDLVL", subheader.getImageDisplayLevel(), "1");
        NITFUtilities.setField("IALVL", subheader.getImageAttachmentLevel(), "0");
        NITFUtilities.setField("ILOC", subheader.getImageLocation(), "0");
        NITFUtilities.setField("IMAG", subheader.getImageMagnification(), imageWrapper.getImageMagnification());
        return ratio;
    }

    private static void setImageBands(ImageSubheader subheader, ImageWrapper imageWrapper) throws NITFException {
        BandInfo[] bandInfos = null;
        ImageWrapper.ImageBand[] bands = imageWrapper.getBands();
        if (bands == null || bands.length == 0) {
            throw new IllegalArgumentException("ImageBands must be specified");
        }
        subheader.createBands(bands.length);
        bandInfos = subheader.getBandInfo();
        for (int i = 0; i < bandInfos.length; ++i) {
            BandInfo bandInfo = bandInfos[i];
            NITFUtilities.setField("IREPBAND" + i, bandInfo.getRepresentation(), bands[i].getRepresentation());
            NITFUtilities.setField("ISUBCAT" + i, bandInfo.getSubcategory(), bands[i].getSubCategory(), imageWrapper.getImageCategory() == ImageWrapper.Category.MS);
            NITFUtilities.setField("IFC" + i, bandInfo.getImageFilterCondition(), "N");
            NITFUtilities.setField("NLUTS" + i, bandInfo.getNumLUTs(), "0");
        }
    }

    private static double setImageCompression(ImageSubheader subheader, NITFUtilities.WriteCompression compression, RenderedImage ri, FileImageInputStreamExt fis) throws IOException {
        double ratio = Double.NaN;
        int numBits = ri.getSampleModel().getSampleSize(0);
        if (compression != null && compression != NITFUtilities.WriteCompression.UNCOMPRESSED) {
            NITFUtilities.setField("IC", subheader.getImageCompression(), "C8");
            if (fis != null) {
                long codeStreamSize = fis.length();
                long imageSize = ri.getWidth() * ri.getHeight() * ri.getSampleModel().getNumBands();
                ratio = (double)codeStreamSize / ((double)imageSize / (double)numBits);
            }
            String comrat = "";
            if (compression.getCompression() == JP2KKakaduImageWriteParam.Compression.NUMERICALLY_LOSSLESS) {
                String ratioString = Double.toString(ratio);
                ratioString = ratioString.replace(".", "");
                ratioString = ratioString.replace(",", "");
                comrat = ratioString = "N0" + ratioString.substring(0, 2);
            } else if (compression == NITFUtilities.WriteCompression.RATIO_15_1) {
                comrat = "L005";
            } else if (compression.toString().endsWith("VL")) {
                comrat = "V039";
            }
            NITFUtilities.setField("COMRAT", subheader.getCompressionRate(), comrat);
        } else {
            NITFUtilities.setField("IC", subheader.getImageCompression(), "NC");
        }
        return ratio;
    }

    private static TRE setTRE(String treName, Map<String, String> fieldsMap) throws NITFException {
        TRE tre = new TRE(treName);
        Set<String> keysSet = fieldsMap.keySet();
        for (String key : keysSet) {
            String value = fieldsMap.get(key);
            if (key.contains("[") && key.contains("]")) {
                NITFUtilities.setTREFieldDirect(tre, key, value);
                continue;
            }
            NITFUtilities.setTREField(tre, key, value, true);
        }
        return tre;
    }

    private boolean writeNITF(Record record, List<ImageWrapper> images, ShapeFileWrapper shp, FileImageInputStreamExt fis, List<TextWrapper> texts) throws NITFException, IOException {
        boolean isJP2;
        int numImages = images.size();
        ImageWrapper image = images.get(0);
        RenderedImage ri = image.getImage();
        NITFUtilities.WriteCompression compression = image.getCompression();
        int nBands = ri.getSampleModel().getNumBands();
        boolean written = false;
        Writer writer = new Writer();
        IOHandle handle = new IOHandle(this.outputFile.getCanonicalPath(), 2, 10);
        byte[] shapeFileData = null;
        boolean bl = isJP2 = compression != NITFUtilities.WriteCompression.UNCOMPRESSED;
        if (shp != null) {
            shapeFileData = this.getShapeData(record, shp);
        }
        boolean prepared = false;
        if (isJP2) {
            StreamIOWriteHandler codeStream = null;
            int size = (int)fis.length();
            IOFileInputStream io = new IOFileInputStream(fis);
            writer.prepare(record, (IOInterface)handle);
            if (shapeFileData != null) {
                this.writeData(shapeFileData, writer);
            }
            codeStream = new StreamIOWriteHandler((IOInterface)io, 0L, (long)size);
            writer.setImageWriteHandler(0, (WriteHandler)codeStream);
            prepared = true;
        }
        if (!isJP2 || numImages > 1) {
            MemorySource bs;
            DataBufferByte dbb;
            if (!prepared) {
                writer.prepare(record, (IOInterface)handle);
            }
            if (numImages == 1) {
                boolean isMono;
                if (shapeFileData != null) {
                    this.writeData(shapeFileData, writer);
                }
                ImageSource imageSource = new ImageSource();
                ImageWriter imageWriter = writer.getNewImageWriter(0);
                boolean[] successes = new boolean[nBands];
                boolean bl2 = isMono = images.get(0).getImage().getSampleModel().getNumBands() == 1;
                if (isMono) {
                    dbb = (DataBufferByte)ri.getData().getDataBuffer();
                    bs = new MemorySource(dbb.getData(), dbb.getSize(), 0, 0, 0);
                    successes[0] = imageSource.addBand((BandSource)bs);
                } else {
                    for (int i = 0; i < nBands; ++i) {
                        RenderedOp band = BandSelectDescriptor.create((RenderedImage)ri, (int[])new int[]{i}, null);
                        DataBufferByte dbb2 = (DataBufferByte)band.getData().getDataBuffer();
                        MemorySource bs2 = new MemorySource(dbb2.getData(), dbb2.getSize(), 0, 0, 0);
                        successes[i] = imageSource.addBand((BandSource)bs2);
                    }
                }
                imageWriter.attachSource(imageSource);
            } else {
                ImageWrapper img = images.get(1);
                ri = img.getImage();
                nBands = ri.getSampleModel().getNumBands();
                ImageSource imageSource = new ImageSource();
                ImageWriter imageWriter2 = writer.getNewImageWriter(1);
                boolean[] successes = new boolean[nBands];
                dbb = (DataBufferByte)ri.getData().getDataBuffer();
                bs = new MemorySource(dbb.getData(), dbb.getSize(), 0, 0, 0);
                successes[0] = imageSource.addBand((BandSource)bs);
                imageWriter2.attachSource(imageSource);
            }
        }
        if (texts != null && !texts.isEmpty()) {
            int i = 0;
            for (TextWrapper text : texts) {
                byte[] textContent = text.getTextContent();
                if (textContent == null) continue;
                SegmentWriter textWriter = writer.getNewTextWriter(i++);
                SegmentSource source = SegmentSource.makeSegmentMemorySource((byte[])textContent, (int)textContent.length, (int)0, (int)0);
                textWriter.attachSource(source);
            }
        }
        written = writer.write();
        if (handle != null) {
            handle.close();
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareJP2Image(RenderedImage ri, File outputFile, NITFUtilities.WriteCompression compression) throws FileNotFoundException, IOException {
        JP2KKakaduImageWriter kakaduWriter = null;
        try {
            int numBands = ri.getSampleModel().getNumBands();
            boolean isMulti = numBands != 1;
            kakaduWriter = new JP2KKakaduImageWriter((ImageWriterSpi)KAKADU_SPI);
            kakaduWriter.setOutput((Object)outputFile);
            JP2KKakaduImageWriteParam param = NITFUtilities.getCompressionParam(kakaduWriter, compression, isMulti);
            kakaduWriter.write(null, new IIOImage(ri, null, null), (ImageWriteParam)param);
        }
        finally {
            if (kakaduWriter != null) {
                try {
                    kakaduWriter.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void writeData(byte[] fullData, Writer writer) throws NITFException {
        SegmentWriter deWriter = writer.getNewDEWriter(0);
        SegmentSource source = SegmentSource.makeSegmentMemorySource((byte[])fullData, (int)fullData.length, (int)0, (int)0);
        deWriter.attachSource(source);
    }

    private byte[] getShapeData(Record record, ShapeFileWrapper shape) throws NITFException, IOException {
        DESegment des = record.newDESegment();
        byte[] fullData = null;
        TRE csshpa = new TRE("CSSHPA");
        TRE tre = des.getSubheader().setSubheaderFields(csshpa);
        byte[] bshp = shape.getShp();
        byte[] bshx = shape.getShx();
        byte[] bdbf = shape.getDbf();
        int shp = shape.getShpLength();
        int shx = shape.getShxLength();
        int dbf = shape.getDbfLength();
        if (bshp == null || bshx == null || bdbf == null) {
            throw new NITFException("Unable to write CSSHPA ShapeFile");
        }
        fullData = new byte[shp + shx + dbf];
        System.arraycopy(bshp, 0, fullData, 0, shp);
        System.arraycopy(bshx, 0, fullData, shp, shx);
        System.arraycopy(bdbf, 0, fullData, shp + shx, dbf);
        tre.setField("SHAPE_USE", "IMAGE_SHAPE              ");
        NITFUtilities.setTREField(tre, "SHAPE_CLASS", "POLYGON   ", false);
        NITFUtilities.setTREField(tre, "SHAPE1_NAME", "SHP", false);
        NITFUtilities.setTREField(tre, "SHAPE1_START", "0", false);
        NITFUtilities.setTREField(tre, "SHAPE2_NAME", "SHX", false);
        NITFUtilities.setTREField(tre, "SHAPE2_START", String.valueOf(shp), false);
        NITFUtilities.setTREField(tre, "SHAPE3_NAME", "DBF", false);
        NITFUtilities.setTREField(tre, "SHAPE3_START", String.valueOf(shx + shp), false);
        NITFUtilities.setField("DE", des.getSubheader().getFilePartType(), "DE");
        NITFUtilities.setField("DESID", des.getSubheader().getTypeID(), "CSSHPA DES");
        NITFUtilities.setField("DESVER", des.getSubheader().getVersion(), "01");
        NITFUtilities.setField("DECLAS", des.getSubheader().getSecurityClass(), "U");
        NITFUtilities.setField("DESCLSY", des.getSubheader().getSecurityGroup().getClassificationSystem(), "US");
        return fullData;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        NITFImageWriteParam nitfParam = null;
        HeaderWrapper header = null;
        Object extensionsMap = null;
        ShapeFileWrapper shape = null;
        List<TextWrapper> texts = null;
        NITFUtilities.WriteCompression compression = null;
        List<ImageWrapper> inputImages = null;
        if (param != null && param instanceof NITFImageWriteParam) {
            nitfParam = (NITFImageWriteParam)param;
            NITFProperties nitfMetadata = nitfParam.getNitfProperties();
            if (nitfMetadata != null) {
                header = nitfMetadata.getHeader();
                shape = nitfMetadata.getShape();
                texts = nitfMetadata.getTextsWrapper();
                inputImages = nitfMetadata.getImagesWrapper();
            }
            compression = nitfParam.getWriteCompression();
        }
        ImageWrapper imageW = (ImageWrapper)inputImages.get(0);
        RenderedImage ri = imageW.getImage();
        boolean isJP2 = compression != null && compression != NITFUtilities.WriteCompression.UNCOMPRESSED;
        FileImageInputStreamExtImpl jp2Stream = null;
        File tempFile = null;
        try {
            Record record = new Record(Version.NITF_21);
            if (isJP2) {
                if (JP2_TEMP_FOLDER != null) {
                    tempFile = File.createTempFile("jp2compressed", ".jpc", new File(JP2_TEMP_FOLDER));
                }
                String parentPath = this.outputFile.getParent();
                String name = FilenameUtils.getBaseName((String)this.outputFile.getCanonicalPath());
                tempFile = new File(parentPath + File.separatorChar + name + ".j2c");
                this.prepareJP2Image(ri, tempFile, compression);
                jp2Stream = new FileImageInputStreamExtImpl(tempFile);
            }
            NITFImageWriter.initFileHeader(record, header);
            NITFImageWriter.addImageSegment(record, inputImages, jp2Stream, compression);
            if (texts != null && !texts.isEmpty()) {
                this.addTextSegment(record, texts);
            }
            if (!this.writeNITF(record, inputImages, shape, (FileImageInputStreamExt)jp2Stream, texts)) {
                throw new IOException("Unable to successfully write");
            }
        }
        catch (Throwable t) {
            IOException ioe = new IOException();
            ioe.initCause(t);
            throw ioe;
        }
        finally {
            if (jp2Stream != null) {
                try {
                    jp2Stream.close();
                }
                catch (Throwable record) {}
            }
            if (tempFile != null) {
                try {
                    tempFile.delete();
                }
                catch (Throwable record) {}
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Successfully wrote NITF: " + this.outputFile);
        }
    }

    private void addTextSegment(Record record, List<TextWrapper> texts) throws NITFException {
        if (texts != null && !texts.isEmpty()) {
            for (TextWrapper wrapper : texts) {
                TextSegment text = record.newTextSegment();
                TextSubheader textSubHeader = text.getSubheader();
                NITFUtilities.setField("TEXTID", textSubHeader.getTextID(), wrapper.getId());
                NITFUtilities.setField("TXTITL", textSubHeader.getTitle(), wrapper.getTitle());
                NITFUtilities.setField("TXTALVL", textSubHeader.getAttachmentLevel(), wrapper.getAttachmentLevel());
                NITFUtilities.setField("TSCLSY", textSubHeader.getSecurityGroup().getClassificationSystem(), wrapper.getSecurityClassificationSystem());
                NITFUtilities.setField("TXTDT", textSubHeader.getDateTime(), wrapper.getDateTime());
                NITFUtilities.setField("ENCRYP", textSubHeader.getEncrypted(), Integer.toString(wrapper.getEncrypted()));
                NITFUtilities.setField("TXTFMT", textSubHeader.getFormat(), wrapper.getFormat());
            }
        }
    }

    private static String customFormat(double value) {
        DecimalFormat myFormatter = new DecimalFormat("00.000000");
        return myFormatter.format(value).replace(",", ".");
    }

    static {
        String jp2TempFolder = System.getProperty(JP2_TEMP_FOLDER_PROPERTY);
        if (jp2TempFolder != null) {
            File file = new File(jp2TempFolder);
            boolean exist = file.exists();
            boolean isDirectory = file.isDirectory();
            boolean canWrite = file.canWrite();
            if (!(exist && isDirectory && canWrite || !LOGGER.isLoggable(Level.WARNING))) {
                StringBuilder warningMessage = new StringBuilder("The specified folder can't be used as jp2 temporary folder: " + jp2TempFolder);
                warningMessage.append(" since it ");
                boolean comma = false;
                if (!exist) {
                    warningMessage.append("doesn't exist");
                    comma = true;
                }
                if (!isDirectory) {
                    warningMessage.append(comma ? "," : "").append("isn't a directory");
                }
                if (!canWrite) {
                    warningMessage.append(comma ? "," : "").append("can't be written");
                }
                warningMessage.append("\nUsing default temp dir: ");
                jp2TempFolder = System.getProperty("java.io.tmpdir");
                warningMessage.append(jp2TempFolder);
                LOGGER.log(Level.WARNING, warningMessage.toString());
            }
        } else {
            jp2TempFolder = null;
        }
        JP2_TEMP_FOLDER = jp2TempFolder;
    }
}

