/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.plugins.nitronitf.NITFImageWriter;
import it.geosolutions.imageio.stream.output.FileImageOutputStreamExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NITFImageWriterSpi
extends ImageWriterSpi {
    private static final Log log = LogFactory.getLog(NITFImageWriterSpi.class);

    public NITFImageWriterSpi() {
        super("NITRO", "1.0", new String[]{"NITF", "nitf", "NSIF"}, new String[]{"ntf", "nitf", "nsf"}, new String[]{"image/x-ntf", "image/x-nitf"}, NITFImageWriter.class.getName(), new Class[]{File.class, FileImageOutputStreamExt.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNITF(File file) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] firstFour = new byte[4];
            fin.read(firstFour);
            boolean bl = new String(firstFour).equals("NITF");
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new NITFImageWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "NITF 2.0/2.1 Writer";
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return true;
    }
}

