/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLInt32;
import it.geosolutions.imageio.matfile5.Utils;
import it.geosolutions.imageio.utilities.Utilities;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASTileMetadata
extends IIOMetadata {
    private static Set<String> filterElements = new HashSet<String>();
    public static final String SAS_PIXELS = "pixels";
    public static final String SAS_LATITUDE = "latitude";
    public static final String SAS_LONGITUDE = "longitude";
    public static final String SAS_ORIENTATION = "orientation";
    public static final String SAS_PIXEL_DIMS = "pixel_dims";
    public static final String SAS_CHANNEL = "channel";
    public static final String SAS_TILE_RAW = "sas_tile_raw";
    public static final String SAS_TILE_LOG = "sas_tile_log";
    public static final String SAS_MU = "mu";
    public static final String SAS_PINGS = "pings";
    public static final String SAS_TILE_RANGES = "tile_ranges";
    public static final String SAS_AV_VELOCITY = "av_velocity";
    public static final String SAS_AV_ALTITUDE = "av_altitude";
    public static final String SAS_X = "x";
    public static final String SAS_Y = "y";
    public static final String SAS_THETA = "theta";
    private int xPixels;
    private int yPixels;
    private double latitude;
    private double longitude;
    private double orientation;
    private double xPixelDim;
    private double yPixelDim;
    private boolean logScale;
    private int dataType;
    private Channel channel;

    public static Set<String> getFilterElements() {
        return new HashSet<String>(filterElements);
    }

    public static boolean isSASFile(MatFileReader matReader) {
        MLArray sasTileData = matReader.getMLArray(SAS_TILE_RAW);
        if (sasTileData != null) {
            return true;
        }
        sasTileData = matReader.getMLArray(SAS_TILE_LOG);
        return sasTileData != null;
    }

    public SASTileMetadata(MatFileReader matReader) {
        Utilities.checkNotNull((Object)matReader, (String)"The provided MatFileReader was null");
        MLArray sasTileData = matReader.getMLArray(SAS_TILE_RAW);
        if (sasTileData != null) {
            this.logScale = false;
        } else {
            this.logScale = true;
            sasTileData = matReader.getMLArray(SAS_TILE_LOG);
        }
        Utilities.checkNotNull((Object)sasTileData, (String)"The provided input doesn't contain any valid SAS tile data");
        this.dataType = Utils.getDatatype(sasTileData);
        this.latitude = SASTileMetadata.getDouble(matReader, SAS_LATITUDE);
        this.longitude = SASTileMetadata.getDouble(matReader, SAS_LONGITUDE);
        this.orientation = SASTileMetadata.getDouble(matReader, SAS_ORIENTATION);
        double[] pixelDims = new double[2];
        int[] pixels = null;
        int pixelType = SASTileMetadata.getElementType(matReader, SAS_PIXELS);
        if (pixelType == 6) {
            double[] pixelsD = new double[2];
            SASTileMetadata.getDoubles(matReader, SAS_PIXELS, pixelsD);
            pixels = new int[]{Double.isNaN(pixelsD[0]) ? Integer.MIN_VALUE : (int)pixelsD[0], Double.isNaN(pixelsD[1]) ? Integer.MIN_VALUE : (int)pixelsD[1]};
        } else if (pixelType == 12) {
            int[] pixelsI = new int[2];
            SASTileMetadata.getIntegers(matReader, SAS_PIXELS, pixelsI);
            pixels = pixelsI;
        }
        SASTileMetadata.getDoubles(matReader, SAS_PIXEL_DIMS, pixelDims);
        String channel = Utils.getString(matReader, SAS_CHANNEL);
        this.xPixels = pixels[0];
        this.yPixels = pixels[1];
        this.channel = Channel.getChannel(channel);
        this.xPixelDim = pixelDims[0];
        this.yPixelDim = pixelDims[1];
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getXPixels() {
        return this.xPixels;
    }

    public void setXPixels(int pixels) {
        this.xPixels = pixels;
    }

    public int getYPixels() {
        return this.yPixels;
    }

    public void setYPixels(int pixels) {
        this.yPixels = pixels;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public double getXPixelDim() {
        return this.xPixelDim;
    }

    public void setXPixelDim(double pixelDim) {
        this.xPixelDim = pixelDim;
    }

    public double getYPixelDim() {
        return this.yPixelDim;
    }

    public void setYPixelDim(double pixelDim) {
        this.yPixelDim = pixelDim;
    }

    @Override
    public Node getAsTree(String formatName) {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
    }

    @Override
    public void reset() {
    }

    public String getMetadataAsXML() {
        return null;
    }

    static double[] getDoubles(MatFileReader reader, String element, double[] values) {
        MLDouble dArray;
        MLArray array = reader.getMLArray(element);
        MLDouble mLDouble = dArray = array != null ? (MLDouble)array : null;
        if (dArray != null) {
            int nDims;
            if (values == null) {
                nDims = dArray.getM();
                values = new double[nDims];
            } else {
                nDims = values.length;
            }
            for (int i = 0; i < nDims; ++i) {
                values[i] = (Double)dArray.get(i);
            }
        } else if (values == null) {
            values = new double[]{Double.NaN, Double.NaN};
        } else {
            for (int i = 0; i < values.length; ++i) {
                values[i] = Double.NaN;
            }
        }
        return values;
    }

    static int[] getIntegers(MatFileReader reader, String element, int[] values) {
        MLInt32 iArray;
        MLArray array = reader.getMLArray(element);
        MLInt32 mLInt32 = iArray = array != null ? (MLInt32)array : null;
        if (iArray != null) {
            int nDims;
            if (values == null) {
                nDims = iArray.getM();
                values = new int[nDims];
            } else {
                nDims = values.length;
            }
            for (int i = 0; i < nDims; ++i) {
                values[i] = (Integer)iArray.get(i);
            }
        } else if (values == null) {
            values = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        } else {
            for (int i = 0; i < values.length; ++i) {
                values[i] = Integer.MAX_VALUE;
            }
        }
        return values;
    }

    static double getDouble(MatFileReader reader, String element) {
        return SASTileMetadata.getDouble(reader, element, 0);
    }

    static double getDouble(MatFileReader reader, String element, int index) {
        double value = Double.NaN;
        if (element != null && reader != null) {
            MLDouble arrayD;
            MLArray array = reader.getMLArray(element);
            MLDouble mLDouble = arrayD = array != null ? (MLDouble)array : null;
            if (arrayD != null) {
                value = (Double)arrayD.get(index);
            }
        }
        return value;
    }

    static int getElementType(MatFileReader reader, String element) {
        Utilities.checkNotNull((Object)reader, (String)"The provided MatFileReader is null");
        if (reader != null) {
            MLArray array = reader.getMLArray(element);
            return Utils.getMatDatatype(array);
        }
        return 0;
    }

    static {
        filterElements.add(SAS_TILE_RAW);
        filterElements.add(SAS_TILE_LOG);
        filterElements.add(SAS_PIXELS);
        filterElements.add(SAS_LATITUDE);
        filterElements.add(SAS_LONGITUDE);
        filterElements.add(SAS_PIXEL_DIMS);
        filterElements.add(SAS_ORIENTATION);
        filterElements.add(SAS_CHANNEL);
        filterElements.add(SAS_MU);
        filterElements.add(SAS_X);
        filterElements.add(SAS_Y);
        filterElements.add(SAS_THETA);
        filterElements.add(SAS_PINGS);
        filterElements.add(SAS_TILE_RANGES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        PORT,
        STARBOARD,
        UNKNOWN;


        public static Channel getChannel(String channel) {
            if (channel != null && channel.trim().length() > 0) {
                if (channel.equalsIgnoreCase("port")) {
                    return PORT;
                }
                if (channel.equalsIgnoreCase("starboard")) {
                    return STARBOARD;
                }
            }
            return UNKNOWN;
        }
    }
}

