/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLNumericArray;
import it.geosolutions.imageio.matfile5.MatFileImageReader;
import it.geosolutions.imageio.matfile5.sas.SASAffineTransformOp;
import it.geosolutions.imageio.matfile5.sas.SASBufferedImageOp;
import it.geosolutions.imageio.matfile5.sas.SASTileImageReaderSpi;
import it.geosolutions.imageio.matfile5.sas.SASTileMetadata;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASTileImageReader
extends MatFileImageReader {
    private static final boolean COMPUTE_LOGARITHM;
    private static final boolean DISABLE_MEDIALIB_LOG;
    private boolean isInitialized = false;
    private SASTileMetadata sasTile = null;

    public SASTileImageReader(SASTileImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    protected synchronized void initialize() {
        if (!this.isInitialized) {
            Object datainput = super.getInput();
            String fileName = this.getDatasetSource(datainput).getAbsolutePath();
            MatFileFilter filter = new MatFileFilter();
            SASTileImageReader.initFilter(filter, SASTileMetadata.getFilterElements());
            try {
                this.matReader = new MatFileReader(fileName, filter, true);
                this.sasTile = new SASTileMetadata(this.matReader);
                this.dataArrays = new LinkedList();
                this.dataArrays.add(this.sasTile.isLogScale() ? "sas_tile_log" : "sas_tile_raw");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to Initialize the reader", e);
            }
        }
        this.isInitialized = true;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile.getYPixels();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile.getXPixels();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        WritableRaster originalRasterData;
        DataBuffer dbb;
        Buffer buffImaginary;
        Buffer buffReal;
        Object dataArray;
        this.initialize();
        int width = this.getWidth(imageIndex);
        int height = this.getHeight(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        int dstWidth = -1;
        int dstHeight = -1;
        int srcRegionWidth = -1;
        int srcRegionHeight = -1;
        int srcRegionXOffset = -1;
        int srcRegionYOffset = -1;
        int xSubsamplingFactor = -1;
        int ySubsamplingFactor = -1;
        int xSubsamplingOffset = 0;
        int ySubsamplingOffset = 0;
        Rectangle srcRegion = param.getSourceRegion();
        if (srcRegion != null) {
            srcRegionWidth = (int)srcRegion.getWidth();
            srcRegionHeight = (int)srcRegion.getHeight();
            srcRegionXOffset = (int)srcRegion.getX();
            srcRegionYOffset = (int)srcRegion.getY();
            if (srcRegionXOffset < 0) {
                srcRegionXOffset = 0;
            }
            if (srcRegionYOffset < 0) {
                srcRegionYOffset = 0;
            }
            if (srcRegionXOffset + srcRegionWidth > width) {
                srcRegionWidth = width - srcRegionXOffset;
            }
            dstWidth = srcRegionWidth;
            if (srcRegionYOffset + srcRegionHeight > height) {
                srcRegionHeight = height - srcRegionYOffset;
            }
            dstHeight = srcRegionHeight;
        } else {
            dstWidth = width;
            dstHeight = height;
            srcRegionYOffset = 0;
            srcRegionXOffset = 0;
            srcRegionWidth = width;
            srcRegionHeight = height;
        }
        xSubsamplingFactor = param.getSourceXSubsampling();
        ySubsamplingFactor = param.getSourceYSubsampling();
        xSubsamplingOffset = param.getSubsamplingXOffset();
        ySubsamplingOffset = param.getSubsamplingYOffset();
        dstWidth = (dstWidth - 1 - xSubsamplingOffset) / xSubsamplingFactor + 1;
        dstHeight = (dstHeight - 1 - ySubsamplingOffset) / ySubsamplingFactor + 1;
        Rectangle roi = new Rectangle(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight);
        MLArray mlArrayRetrived = this.matReader.getMLArray((String)this.dataArrays.get(imageIndex));
        ByteBuffer real = ((MLNumericArray)mlArrayRetrived).getRealByteBuffer();
        ByteBuffer imaginary = ((MLNumericArray)mlArrayRetrived).getImaginaryByteBuffer();
        boolean isDouble = mlArrayRetrived instanceof MLDouble;
        int imageSize = width * height;
        int smWidth = height;
        int smHeight = width;
        BandedSampleModel sampleModel = new BandedSampleModel(isDouble ? 5 : 4, smWidth, smHeight, 2);
        ColorModel cm = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        if (isDouble) {
            dataArray = new double[2][imageSize];
            buffReal = real.asDoubleBuffer();
            ((DoubleBuffer)buffReal).get(dataArray[0]);
            buffImaginary = imaginary.asDoubleBuffer();
            ((DoubleBuffer)buffImaginary).get(dataArray[1]);
            dbb = new DataBufferDouble((double[][])dataArray, imageSize);
            originalRasterData = Raster.createWritableRaster(sampleModel, dbb, null);
        } else {
            dataArray = new float[2][imageSize];
            buffReal = real.asFloatBuffer();
            ((FloatBuffer)buffReal).get((float[])dataArray[0]);
            buffImaginary = imaginary.asFloatBuffer();
            ((FloatBuffer)buffImaginary).get((float[])dataArray[1]);
            dbb = new DataBufferFloat((float[][])dataArray, imageSize);
            originalRasterData = Raster.createWritableRaster(sampleModel, dbb, null);
        }
        BufferedImage data = new BufferedImage(cm, originalRasterData, false, null);
        if (srcRegion != null) {
            int x = roi.y;
            int y = roi.x;
            int w = roi.height;
            int h = roi.width;
            data = data.getSubimage(x, y, w, h);
        }
        ImageReadParam tunedParam = this.getDefaultReadParam();
        tunedParam.setSourceSubsampling(xSubsamplingFactor, ySubsamplingFactor, xSubsamplingOffset, ySubsamplingOffset);
        tunedParam.setSourceRegion(roi);
        AffineTransform transform = this.getAffineTransform(tunedParam);
        SASAffineTransformOp transformOp = new SASAffineTransformOp(transform, null);
        BufferedImage dst = null;
        dst = transformOp.filter(data, dst);
        return new SASBufferedImageOp(COMPUTE_LOGARITHM, null).filter(dst, null);
    }

    @Override
    protected AffineTransform getPreTransform(ImageReadParam param) throws IOException {
        int xSubsamplingFactor = 1;
        int ySubsamplingFactor = 1;
        int height = this.getHeight(0);
        int width = this.getWidth(0);
        if (param != null) {
            xSubsamplingFactor = param.getSourceXSubsampling();
            ySubsamplingFactor = param.getSourceYSubsampling();
            Rectangle sourceRegion = param.getSourceRegion();
            if (sourceRegion != null) {
                width = sourceRegion.width;
                height = sourceRegion.height;
            }
        }
        AffineTransform transform = AffineTransform.getRotateInstance(0.0);
        SASTileMetadata.Channel channel = this.sasTile.getChannel();
        if (channel == SASTileMetadata.Channel.STARBOARD) {
            transform.preConcatenate(AffineTransform.getScaleInstance(1.0, -1.0));
            double ty = height;
            if (ySubsamplingFactor != 1) {
                ty /= (double)ySubsamplingFactor;
            }
            transform.preConcatenate(AffineTransform.getTranslateInstance(0.0, ty));
        } else {
            transform.preConcatenate(AffineTransform.getScaleInstance(-1.0, -1.0));
            double ty = height;
            if (ySubsamplingFactor != 1) {
                ty /= (double)ySubsamplingFactor;
            }
            double tx = width;
            if (xSubsamplingFactor != 1) {
                tx /= (double)xSubsamplingFactor;
            }
            transform.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        }
        return transform;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.initialize();
        int width = this.sasTile.getXPixels();
        int height = this.sasTile.getYPixels();
        int dataType = this.sasTile.getDataType();
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, width, height, 1);
        ColorModel cm = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(1);
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(cm, sampleModel);
        l.add(imageType);
        return l.iterator();
    }

    static {
        String cl = System.getenv("SAS_COMPUTE_LOG");
        String disableMediaLog = System.getenv("DISABLE_MEDIALIB_LOG");
        COMPUTE_LOGARITHM = cl != null && cl.trim().length() > 0 ? Boolean.parseBoolean(cl) : true;
        DISABLE_MEDIALIB_LOG = disableMediaLog != null && disableMediaLog.trim().length() > 0 ? Boolean.parseBoolean(disableMediaLog) : false;
        if (DISABLE_MEDIALIB_LOG) {
            Utilities.setNativeAccelerationAllowed((String)"Log", (boolean)false);
        }
    }
}

