/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

class SASBufferedImageOp
implements BufferedImageOp,
RasterOp {
    private boolean computeLog;
    private RenderingHints hints = null;

    public SASBufferedImageOp(boolean computeLog, RenderingHints hints) {
        this.computeLog = computeLog;
        this.hints = hints;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        WritableRaster wr = src.getRaster().createCompatibleWritableRaster();
        return new BufferedImage(dstCM, wr, src.isAlphaPremultiplied(), null);
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src.getSampleModel().getNumBands() != 2) {
            throw new IllegalArgumentException();
        }
        if (dst == null) {
            PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(src.getSampleModel().getDataType(), src.getWidth(), src.getHeight(), 1, src.getWidth(), new int[]{0});
            ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, null);
            dst = new BufferedImage(colorModel, raster, false, null);
        } else if (dst.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException();
        }
        WritableRaster wsrc = src.getRaster();
        WritableRaster wdst = dst.getRaster();
        this.filter(wsrc, wdst);
        return dst;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getData().getBounds();
    }

    public Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = (Point2D)src.clone();
        } else {
            dst.setLocation(src);
        }
        return dst;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        if (src.getNumBands() != 2) {
            throw new IllegalArgumentException();
        }
        if (dest.getNumBands() != 1) {
            throw new IllegalArgumentException();
        }
        double[] pixel = new double[2];
        int minx = src.getMinX();
        int miny = src.getMinX();
        int maxx = src.getWidth() + minx;
        int maxy = src.getHeight() + miny;
        for (int y = miny; y < maxy; ++y) {
            for (int x = minx; x < maxx; ++x) {
                src.getPixel(x, y, pixel);
                double magnitude = Math.sqrt(Math.pow(pixel[0], 2.0) + Math.pow(pixel[1], 2.0));
                double value = this.computeLog ? 20.0 * Math.log10(magnitude) : magnitude;
                dest.setSample(x, y, 0, value);
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster arg0) {
        return null;
    }
}

