/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

class SASAffineTransformOp
implements BufferedImageOp,
RasterOp {
    AffineTransform xform;
    AffineTransform inv_xform;
    private RenderingHints hints = null;

    public SASAffineTransformOp(AffineTransform xform, RenderingHints hints) {
        this.hints = hints;
        this.xform = (AffineTransform)xform.clone();
        try {
            this.inv_xform = xform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        WritableRaster wsrc = src.getRaster();
        WritableRaster wdst = dst.getRaster();
        this.filter(wsrc, wdst);
        return dst;
    }

    public Point2D mapSourcePoint(Point2D sourcePt, Point2D destPt) {
        Utilities.checkNotNull((Object)sourcePt, (String)"The provided source point is null");
        Utilities.checkNotNull((Object)destPt, (String)"The provided destination point is null");
        sourcePt.setLocation(sourcePt.getX() + 0.5, sourcePt.getY() + 0.5);
        Point2D dpt = this.xform.transform(sourcePt, destPt);
        sourcePt.setLocation(sourcePt.getX() - 0.5, sourcePt.getY() - 0.5);
        dpt.setLocation(dpt.getX() - 0.5, dpt.getY() - 0.5);
        return dpt;
    }

    public Point2D mapDestPoint(Point2D destPt, Point2D sourcePt) {
        Utilities.checkNotNull((Object)sourcePt, (String)"The provided source point is null");
        Utilities.checkNotNull((Object)destPt, (String)"The provided destination point is null");
        destPt.setLocation(destPt.getX() + 0.5, destPt.getY() + 0.5);
        Point2D spt = this.inv_xform.transform(destPt, sourcePt);
        destPt.setLocation(destPt.getX() - 0.5, destPt.getY() - 0.5);
        spt.setLocation(spt.getX() - 0.5, spt.getY() - 0.5);
        return spt;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM, Rectangle dstRegion) {
        BufferedImage image;
        Rectangle r = this.getBounds2D(src).getBounds();
        int w = r.x + r.width;
        int h = r.y + r.height;
        if (w <= 0) {
            throw new RasterFormatException("Transformed width (" + w + ") is less than or equal to 0.");
        }
        if (h <= 0) {
            throw new RasterFormatException("Transformed height (" + h + ") is less than or equal to 0.");
        }
        if (dstRegion != null) {
            w = dstRegion.width;
            h = dstRegion.height;
        }
        if (destCM == null) {
            ColorModel cm = src.getColorModel();
            image = new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster(w, h), cm.isAlphaPremultiplied(), null);
        } else {
            image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }
        return image;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return this.createCompatibleDestImage(src, destCM, null);
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public Rectangle2D getBounds2D(Raster src) {
        int w = src.getWidth();
        int h = src.getHeight();
        float[] pts = new float[]{0.0f, 0.0f, w, 0.0f, w, h, 0.0f, h};
        this.xform.transform(pts, 0, pts, 0, 4);
        float fmaxX = pts[0];
        float fmaxY = pts[1];
        float fminX = pts[0];
        float fminY = pts[1];
        for (int i = 2; i < 8; i += 2) {
            if (pts[i] > fmaxX) {
                fmaxX = pts[i];
            } else if (pts[i] < fminX) {
                fminX = pts[i];
            }
            if (pts[i + 1] > fmaxY) {
                fmaxY = pts[i + 1];
                continue;
            }
            if (!(pts[i + 1] < fminY)) continue;
            fminY = pts[i + 1];
        }
        return new Rectangle2D.Float(fminX, fminY, fmaxX - fminX, fmaxY - fminY);
    }

    public Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = (Point2D)src.clone();
        } else {
            dst.setLocation(src);
        }
        return dst;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == null) {
            dst = src.createCompatibleWritableRaster();
        }
        if (src.getNumBands() != 2) {
            throw new IllegalArgumentException();
        }
        if (dst.getNumBands() != 2) {
            throw new IllegalArgumentException();
        }
        int minX = src.getMinX();
        int minY = src.getMinY();
        int width = src.getWidth();
        int height = src.getHeight();
        int maxX = minX + width - 1;
        int maxY = minY + height - 1;
        int minXD = dst.getMinX();
        int minYD = dst.getMinY();
        int widthD = dst.getWidth();
        int heightD = dst.getHeight();
        int maxXD = minXD + widthD - 1;
        int maxYD = minYD + heightD - 1;
        Object[] pixel = null;
        int dataType = src.getSampleModel().getDataType();
        if (dataType == 5) {
            pixel = new double[2];
        } else if (dataType == 4) {
            pixel = new float[2];
        } else if (dataType == 3) {
            pixel = new int[2];
        } else {
            throw new IllegalArgumentException("Unsupported datatype");
        }
        Point2D srcPt = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float destPt = new Point2D.Float(0.0f, 0.0f);
        for (int i = minYD; i <= maxYD; ++i) {
            for (int j = minXD; j <= maxXD; ++j) {
                ((Point2D)destPt).setLocation(j, i);
                srcPt = this.mapDestPoint(destPt, srcPt);
                int nearestX = this.findNearest(srcPt.getX(), minX, maxX);
                int nearestY = this.findNearest(srcPt.getY(), minY, maxY);
                src.getDataElements(nearestX, nearestY, pixel);
                dst.setDataElements(j, i, pixel);
            }
        }
        return dst;
    }

    private int findNearest(double a, int minA, int maxA) {
        int nearestA = (int)Math.round(a);
        if (nearestA < minA) {
            nearestA = minA;
        } else if (nearestA > maxA) {
            nearestA = maxA;
        }
        return nearestA;
    }
}

