/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5;

import com.jmatio.io.MatlabIOException;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.utilities.Utilities;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatFileImageReaderSpi
extends ImageReaderSpi {
    static final String[] suffixes = new String[]{"mat"};
    static final String[] formatNames = new String[]{"Mat", "Mat5"};
    static final String[] MIMETypes = new String[]{"image/mat"};
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.matfile5.MatFileImageReader";
    static final String vendorName = "GeoSolutions";
    static final String[] wSN = new String[]{null};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = new String[]{null};
    static final String[] extraStreamMetadataFormatClassNames = new String[]{null};
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = "";
    static final String nativeImageMetadataFormatClassName = "";
    static final String[] extraImageMetadataFormatNames = new String[]{null};
    static final String[] extraImageMetadataFormatClassNames = new String[]{null};
    private static final String MAT_FILE_5 = "MATLAB 5.0 MAT-file.*";
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.matfile5");

    public MatFileImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, readerCN, new Class[]{File.class, FileImageInputStreamExtImpl.class}, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, "", "", extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public MatFileImageReaderSpi(String vendorName, String version, String[] formatNames, String[] suffixes, String[] types, String readerCN, Class<?>[] classes, String[] wsn, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version, formatNames, suffixes, types, readerCN, classes, wsn, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Can Decode Input");
        }
        if (input instanceof ImageInputStream) {
            ((ImageInputStream)input).mark();
        }
        if (input instanceof String) {
            input = new File((String)input);
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            input = tempURL.getProtocol().equalsIgnoreCase("file") ? Utilities.urlToFile((URL)tempURL) : ((URL)input).openStream();
        }
        if (input instanceof File) {
            input = new FileImageInputStreamExtImpl((File)input);
        }
        boolean isInputDecodable = false;
        try {
            String file = ((FileImageInputStreamExtImpl)input).getFile().getAbsolutePath();
            isInputDecodable = this.isDecodable(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInputDecodable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDecodable(String file) throws IOException {
        if (file == null || file.trim().length() < 1) {
            return false;
        }
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        FileChannel roChannel = raFile.getChannel();
        ByteBuffer buf = ByteBuffer.allocateDirect(128);
        roChannel.read(buf, 0L);
        buf.rewind();
        try {
            this.checkHeader(buf);
        }
        catch (MatlabIOException mlio) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("This is not a valid MATLAB 5.0 MAT-file.");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (roChannel != null) {
                roChannel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
        }
        return true;
    }

    private void checkHeader(ByteBuffer buf) throws IOException {
        byte[] descriptionBuffer = new byte[116];
        buf.get(descriptionBuffer);
        String description = new String(descriptionBuffer);
        if (!description.matches(MAT_FILE_5)) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
    }

    @Override
    public String getDescription(Locale locale) {
        return new StringBuffer("MATLAB 5.0 MAT-Files Image Reader, version ").append(version).toString();
    }
}

