/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileReader;
import it.geosolutions.imageio.matfile5.MatFileImageReaderSpi;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatFileImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.matfile5");
    private ImageInputStream imageInputStream;
    private File dataSource = null;
    protected MatFileReader matReader = null;
    protected List<String> dataArrays = new LinkedList<String>();

    @Override
    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    protected MatFileImageReader(MatFileImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected abstract void initialize();

    protected File getDatasetSource(Object myInput) {
        if (this.dataSource == null) {
            if (myInput instanceof File) {
                this.dataSource = (File)myInput;
            } else if (myInput instanceof FileImageInputStreamExt) {
                this.dataSource = ((FileImageInputStreamExt)myInput).getFile();
            } else if (this.input instanceof URL) {
                URL tempURL = (URL)this.input;
                if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                    this.dataSource = Utilities.urlToFile((URL)tempURL);
                }
            } else {
                throw new RuntimeException("Unable to retrieve the Data Source for the provided input");
            }
        }
        return this.dataSource;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        URL tempURL;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting Input");
        }
        if (this.imageInputStream != null) {
            this.reset();
            this.imageInputStream = null;
        }
        if (input == null) {
            throw new IllegalArgumentException("The provided input is null!");
        }
        if (input instanceof File) {
            this.dataSource = (File)input;
            try {
                this.imageInputStream = new FileImageInputStreamExtImpl((File)input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create a valid input stream ", e);
            }
        }
        if (input instanceof FileImageInputStreamExt) {
            this.dataSource = ((FileImageInputStreamExt)input).getFile();
            this.imageInputStream = (ImageInputStream)input;
        } else if (input instanceof URL && (tempURL = (URL)input).getProtocol().equalsIgnoreCase("file")) {
            try {
                this.dataSource = Utilities.urlToFile((URL)tempURL);
                this.imageInputStream = ImageIO.createImageInputStream(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create a valid input stream ", e);
            }
        }
        boolean isInputDecodable = false;
        try {
            isInputDecodable = ((MatFileImageReaderSpi)this.getOriginatingProvider()).isDecodable(this.dataSource.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("The provided input is not supported by this reader", e);
        }
        if (!isInputDecodable) {
            StringBuilder sb = new StringBuilder();
            if (this.imageInputStream == null) {
                sb.append("Unable to create a valid ImageInputStream for the provided input:").append("\n").append(input.toString());
            } else {
                sb.append("The provided input is not supported by this reader");
            }
            throw new RuntimeException(sb.toString());
        }
        super.setInput(this.imageInputStream, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.imageInputStream != null) {
            try {
                this.imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.imageInputStream = null;
        if (this.matReader != null) {
            this.matReader.dispose();
        }
        if (this.dataArrays != null) {
            this.dataArrays.clear();
            this.dataArrays = null;
        }
        this.matReader = null;
    }

    @Override
    public synchronized void reset() {
        super.setInput(null, false, false);
        this.dispose();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting NumImages");
        }
        return 1;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    protected static void initFilter(MatFileFilter filter, Set<String> filterElements) {
        if (filterElements != null && !filterElements.isEmpty()) {
            for (String element : filterElements) {
                filter.addArrayName(element);
            }
        }
    }

    protected AffineTransform getAffineTransform(ImageReadParam param) throws IOException {
        AffineTransform transposed = this.getTransposed(param);
        transposed.preConcatenate(this.getPreTransform(param));
        return transposed;
    }

    protected AffineTransform getPreTransform(ImageReadParam param) throws IOException {
        return AffineTransform.getRotateInstance(0.0);
    }

    private AffineTransform getTransposed(ImageReadParam param) {
        AffineTransform transform = AffineTransform.getRotateInstance(0.0);
        if (param != null) {
            int xSubsamplingFactor = param.getSourceXSubsampling();
            int ySubsamplingFactor = param.getSourceYSubsampling();
            if (xSubsamplingFactor != 1 || ySubsamplingFactor != 1) {
                transform.preConcatenate(AffineTransform.getScaleInstance(1.0 / (double)ySubsamplingFactor, 1.0 / (double)xSubsamplingFactor));
            }
        }
        AffineTransform transposeTransform = AffineTransform.getRotateInstance(0.0);
        transposeTransform.preConcatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        transposeTransform.preConcatenate(AffineTransform.getRotateInstance(1.5707963267948966));
        transform.preConcatenate(transposeTransform);
        return transform;
    }
}

