/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.utilities.Utilities;
import it.geosolutions.util.KakaduUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jpx_source;
import kdu_jni.KduException;
import kdu_jni.Kdu_simple_file_source;

public class JP2KKakaduImageReaderSpi
extends ImageReaderSpi {
    protected boolean registered = false;
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    static final String vendorName = "GeoSolutions";
    static final String[] wSN;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    public JP2KKakaduImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, readerCN, new Class[]{File.class, FileImageInputStreamExt.class, URL.class}, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        boolean isDecodable = true;
        File source = null;
        if (input instanceof File) {
            source = (File)input;
        } else if (input instanceof FileImageInputStreamExt) {
            source = ((FileImageInputStreamExt)input).getFile();
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                source = Utilities.urlToFile((URL)tempURL);
            }
        } else {
            return false;
        }
        Jp2_family_src familySource = new Jp2_family_src();
        Jpx_source wrappedSource = new Jpx_source();
        Kdu_simple_file_source rawSource = null;
        try {
            String fileName = source.getAbsolutePath();
            familySource.Open(fileName);
            int success = wrappedSource.Open(familySource, true);
            if (success < 0) {
                familySource.Close();
                wrappedSource.Close();
                rawSource = new Kdu_simple_file_source(fileName);
                if (rawSource != null) {
                    if (fileName != null) {
                        FileInputStream fis = new FileInputStream(new File(fileName));
                        byte[] jp2SocMarker = new byte[2];
                        fis.read(jp2SocMarker);
                        isDecodable = jp2SocMarker[0] == -1 && jp2SocMarker[1] == 79;
                        fis.close();
                    }
                } else {
                    isDecodable = false;
                }
            }
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during creation of key objects! ", e);
        }
        wrappedSource.Native_destroy();
        familySource.Native_destroy();
        if (rawSource != null) {
            rawSource.Native_destroy();
        }
        return isDecodable;
    }

    @Override
    public ImageReader createReaderInstance(Object source) throws IOException {
        return new JP2KKakaduImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return new StringBuffer("JP2K Image Reader, version ").append(version).toString();
    }

    public synchronized void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!KakaduUtilities.isKakaduAvailable()) {
            IIORegistry iioRegistry = (IIORegistry)registry;
            Class<ImageReaderSpi> spiClass = ImageReaderSpi.class;
            Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
            while (iter.hasNext()) {
                ImageReaderSpi provider = iter.next();
                if (!(provider instanceof JP2KKakaduImageReaderSpi)) continue;
                registry.deregisterServiceProvider(provider);
            }
            return;
        }
        List<ImageReaderWriterSpi> readers = KakaduUtilities.getJDKImageReaderWriterSPI(registry, "jpeg2000", true);
        for (ImageReaderWriterSpi elem : readers) {
            ImageReaderSpi spi;
            if (!(elem instanceof ImageReaderSpi) || (spi = (ImageReaderSpi)elem) == this) continue;
            registry.deregisterServiceProvider(spi);
            registry.setOrdering(category, this, spi);
        }
    }

    static {
        KakaduUtilities.loadKakadu();
        suffixes = new String[]{"jp2", "jp2k", "j2k", "j2c"};
        formatNames = new String[]{"JP2KSimpleBox", "jpeg2000", "jpeg 2000", "JPEG 2000", "JPEG2000"};
        MIMETypes = new String[]{"image/jp2", "image/jp2k", "image/j2k", "image/j2c"};
        wSN = new String[]{null};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = new String[]{null};
        extraStreamMetadataFormatClassNames = new String[]{null};
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
    }
}

