/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.aps;

import it.geosolutions.imageio.plugins.hdf4.HDF4ImageReaderSpi;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.dataset.NetcdfDataset;

public class HDF4APSImageReaderSpi
extends HDF4ImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger(HDF4APSImageReaderSpi.class.toString());
    static final String readerCN = "it.geosolutions.imageio.plugins.hdf4.HDF4APSImageReader";

    public HDF4APSImageReaderSpi() {
        super(readerCN);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("HDF4TeraScanImageReaderSpi Constructor");
        }
    }

    @Override
    protected boolean isValidDataset(NetcdfDataset dataset) {
        boolean found = false;
        String attrib = NetCDFUtilities.getGlobalAttributeAsString((NetcdfDataset)dataset, (String)"createSoftware");
        if (attrib != null && attrib.length() > 0 && attrib.startsWith("APS")) {
            found = true;
        }
        return found;
    }

    @Override
    public ImageReader createReaderInstance(Object input) throws IOException {
        return new HDF4APSImageReader((ImageReaderSpi)((Object)this));
    }
}

