/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4;

import it.geosolutions.imageio.ndplugin.BaseImageReaderSpi;
import it.geosolutions.imageio.plugins.hdf4.HDF4ImageReaderProxy;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf4.H4iosp;

public abstract class HDF4ImageReaderSpi
extends BaseImageReaderSpi {
    private static final Logger LOGGER;
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.hdf4.BaseHDF4ImageReader";
    static final String[] wSN;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    public HDF4ImageReaderSpi() {
        super("GeoSolutions", version, formatNames, suffixes, MIMETypes, readerCN, DIRECT_STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("HDF4TeraScanImageReaderSpi Constructor");
        }
    }

    public HDF4ImageReaderSpi(String readerCN) {
        super("GeoSolutions", version, formatNames, suffixes, MIMETypes, readerCN, DIRECT_STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object input) throws IOException {
        NetcdfDataset dataset;
        boolean found = false;
        if (input instanceof FileImageInputStreamExtImpl) {
            input = ((FileImageInputStreamExtImpl)input).getFile();
        }
        if (input instanceof File && (dataset = NetCDFUtilities.getDataset((Object)input)) != null) {
            if (!(dataset.getIosp() instanceof H4iosp)) {
                return false;
            }
            try {
                found = this.isValidDataset(dataset);
            }
            finally {
                block11: {
                    try {
                        dataset.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block11;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return found;
    }

    protected boolean isValidDataset(NetcdfDataset dataset) {
        return false;
    }

    public ImageReader createReaderInstance(Object input) throws IOException {
        return new HDF4ImageReaderProxy((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "HDF4 Image Reader, version 1.0";
    }

    static {
        NetcdfDataset.setDefaultEnhanceMode(EnumSet.of(NetcdfDataset.Enhance.CoordSystems));
        LOGGER = Logger.getLogger(HDF4ImageReaderSpi.class.toString());
        suffixes = new String[]{"hdf", "hdf4"};
        formatNames = new String[]{"HDF4"};
        MIMETypes = new String[]{"image/hdf4"};
        wSN = new String[]{null};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = new String[]{null};
        extraStreamMetadataFormatClassNames = new String[]{null};
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
    }
}

