/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.grib1;

import it.geosolutions.imageio.ndplugin.BaseImageReaderSpi;
import it.geosolutions.imageio.plugins.grib1.GRIB1ImageReader;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.NetcdfFile;

public class GRIB1ImageReaderSpi
extends BaseImageReaderSpi {
    static final String[] suffixes = new String[]{"grib", "grb"};
    static final String[] formatNames = new String[]{"GRIB1"};
    static final String[] MIMETypes = new String[]{"image/grib", "image/grb"};
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.grib1.GRIB1ImageReader";
    static final String[] wSN = new String[]{null};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = new String[]{null};
    static final String[] extraStreamMetadataFormatClassNames = new String[]{null};
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = new String[]{null};
    static final String[] extraImageMetadataFormatClassNames = new String[]{null};

    public GRIB1ImageReaderSpi() {
        super("GeoSolutions", version, formatNames, suffixes, MIMETypes, readerCN, DIRECT_STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("GRIB1ImageReaderSpi Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object source) throws IOException {
        boolean canDecode = false;
        File input = null;
        if (source instanceof FileImageInputStreamExtImpl) {
            input = ((FileImageInputStreamExtImpl)source).getFile();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a valid FileImageInputStream");
            }
        }
        if (source instanceof File) {
            input = (File)source;
        }
        if (input != null) {
            try (NetcdfFile file = null;){
                file = NetcdfFile.open((String)input.getPath());
                if (file != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("File successfully opened");
                    }
                    canDecode = true;
                }
            }
        }
        return canDecode;
    }

    public ImageReader createReaderInstance(Object input) throws IOException {
        return new GRIB1ImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "GRIB1 Image Reader, version 1.0";
    }
}

