/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.gdalframework.GDALWritableCommonIIOImageMetadata;
import it.geosolutions.imageio.pam.PAMDataset;
import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.gdal.gdal.Band;
import org.gdal.gdal.ColorTable;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.GCP;
import org.gdal.gdal.RasterAttributeTable;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;
import org.w3c.dom.Node;

public class GDALCommonIIOImageMetadata
extends CoreCommonImageMetadata {
    private static final Logger LOGGER = Logger.getLogger(GDALCommonIIOImageMetadata.class.toString());
    Map<String, Map<String, String>> gdalDomainMetadataMap;
    private PAMDataset pamDataSet;

    public GDALCommonIIOImageMetadata(String sDatasetName) {
        this(sDatasetName, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    public GDALCommonIIOImageMetadata(String sDatasetName, String formatName, String formatClassName) {
        this(GDALUtilities.acquireDataSet(sDatasetName, gdalconst.GA_ReadOnly), sDatasetName, true, formatName, formatClassName, true);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired, String formatName, String formatClassName) {
        this(dataset, name, initializationRequired, formatName, formatClassName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired, String formatName, String formatClassName, boolean closeDataset) {
        super(false, formatName, formatClassName, null, null);
        this.setDatasetName(name);
        if (dataset == null) {
            return;
        }
        this.setDatasetDescription(dataset.GetDescription());
        Driver driver = null;
        try {
            Hashtable imageStMap;
            driver = dataset.GetDriver();
            if (driver != null) {
                this.setDriverDescription(driver.GetDescription());
                this.setDriverName(driver.getShortName());
            }
            this.gdalDomainMetadataMap = new HashMap<String, Map<String, String>>();
            Hashtable defMap = dataset.GetMetadata_Dict("");
            if (defMap != null && defMap.size() > 0) {
                this.gdalDomainMetadataMap.put("DEF", defMap);
            }
            if ((imageStMap = dataset.GetMetadata_Dict("IMAGE_STRUCTURE")) != null && imageStMap.size() > 0) {
                this.gdalDomainMetadataMap.put("IMAGE_STRUCTURE", imageStMap);
            }
            if (initializationRequired) {
                this.setMembers(dataset);
            }
            this.setGeoreferencingInfo(dataset);
        }
        finally {
            block20: {
                block19: {
                    if (driver != null) {
                        try {
                            driver.delete();
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                }
                if (closeDataset && dataset != null) {
                    try {
                        GDALUtilities.closeDataSet(dataset);
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block20;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, String formatName, String formatClassName) {
        this(dataset, name, true, formatName, formatClassName);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired) {
        this(dataset, name, initializationRequired, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    private void setGeoreferencingInfo(Dataset dataset) {
        double[] geoT = new double[6];
        dataset.GetGeoTransform(geoT);
        this.setGeoTransformation(geoT);
        this.setProjection(dataset.GetProjection());
        this.setGcpProjection(dataset.GetGCPProjection());
        this.setGcpNumber(dataset.GetGCPCount());
        this.setPamDataset(dataset);
    }

    public PAMDataset getPamDataset() {
        return this.pamDataSet;
    }

    private void setPamDataset(Dataset dataset) {
        PAMDataset pd = new PAMDataset();
        int bandCount = dataset.getRasterCount();
        for (int b = 1; b <= bandCount; ++b) {
            Band band = dataset.GetRasterBand(b);
            PAMDataset.PAMRasterBand pdBand = new PAMDataset.PAMRasterBand();
            pdBand.setBand(Integer.valueOf(b));
            double[] min = new double[1];
            double[] max = new double[1];
            double[] mean = new double[1];
            double[] stddev = new double[1];
            if (band.GetStatistics(false, false, min, max, mean, stddev) != gdalconstConstants.CE_None) {
                PAMDataset.PAMRasterBand.Metadata metadata = new PAMDataset.PAMRasterBand.Metadata();
                List mdis = metadata.getMDI();
                mdis.add(this.createMDI("STATISTICS_MINIMUM", min[0]));
                mdis.add(this.createMDI("STATISTICS_MAXIMUM", max[0]));
                mdis.add(this.createMDI("STATISTICS_MEAN", mean[0]));
                mdis.add(this.createMDI("STATISTICS_STDDEV", stddev[0]));
                pdBand.setMetadata(metadata);
            }
            GDALCommonIIOImageMetadata.setupRasterAttributeTable(band, pdBand);
            band.delete();
            pd.getPAMRasterBand().add(pdBand);
        }
        this.pamDataSet = pd;
    }

    private static void setupRasterAttributeTable(Band band, PAMDataset.PAMRasterBand pdBand) {
        RasterAttributeTable rat = band.GetDefaultRAT();
        if (rat != null) {
            PAMDataset.PAMRasterBand.GDALRasterAttributeTable pdRAT = new PAMDataset.PAMRasterBand.GDALRasterAttributeTable();
            List fields = pdRAT.getFieldDefn();
            int columns = rat.GetColumnCount();
            for (int i = 0; i < columns; ++i) {
                PAMDataset.PAMRasterBand.FieldDefn field = new PAMDataset.PAMRasterBand.FieldDefn();
                field.setIndex(i);
                field.setName(rat.GetNameOfCol(i));
                field.setType(PAMDataset.PAMRasterBand.FieldType.fromValue((int)rat.GetTypeOfCol(i)));
                field.setUsage(PAMDataset.PAMRasterBand.FieldUsage.fromValue((int)rat.GetUsageOfCol(i)));
                fields.add(field);
            }
            List pdRows = pdRAT.getRow();
            int rows = rat.GetRowCount();
            for (int r = 0; r < rows; ++r) {
                PAMDataset.PAMRasterBand.Row row = new PAMDataset.PAMRasterBand.Row();
                List values = row.getF();
                for (int c = 0; c < columns; ++c) {
                    values.add(rat.GetValueAsString(r, c));
                }
                pdRows.add(row);
            }
            pdBand.setGdalRasterAttributeTable(pdRAT);
            rat.delete();
        }
    }

    private PAMDataset.PAMRasterBand.Metadata.MDI createMDI(String key, Object value) {
        PAMDataset.PAMRasterBand.Metadata.MDI mdi = new PAMDataset.PAMRasterBand.Metadata.MDI();
        mdi.setKey(key);
        mdi.setValue(String.valueOf(value));
        return mdi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMembers(Dataset dataset) {
        this.setWidth(dataset.getRasterXSize());
        this.setHeight(dataset.getRasterYSize());
        int[] xBlockSize = new int[1];
        int[] yBlockSize = new int[1];
        Band rband = null;
        try {
            rband = dataset.GetRasterBand(1);
            rband.GetBlockSize(xBlockSize, yBlockSize);
            int tileHeight = yBlockSize[0];
            int tileWidth = xBlockSize[0];
            this.setTileHeight(tileHeight);
            this.setTileWidth(tileWidth);
            if ((long)tileHeight * (long)tileWidth > Integer.MAX_VALUE) {
                this.performTileSizeTuning(dataset);
            }
            int numBands = dataset.getRasterCount();
            this.setNumBands(numBands);
            if (numBands <= 0) {
                boolean bl = false;
                return bl;
            }
            int tileSize = tileWidth * tileHeight * numBands * (gdal.GetDataTypeSize((int)rband.getDataType()) / 8);
            int[] banks = new int[numBands];
            int[] offsetsR = new int[numBands];
            Double[] noDataValues = new Double[numBands];
            Double[] scales = new Double[numBands];
            Double[] offsets = new Double[numBands];
            Double[] minimums = new Double[numBands];
            Double[] maximums = new Double[numBands];
            int[] numOverviews = new int[numBands];
            int[] colorInterpretations = new int[numBands];
            int buf_type = 0;
            Band pBand = null;
            Double[] tempD = new Double[1];
            double[] min = new double[1];
            double[] max = new double[1];
            double[] mean = new double[1];
            double[] stddev = new double[1];
            int[] bandsOffset = new int[numBands];
            for (int band = 0; band < numBands; ++band) {
                try {
                    pBand = dataset.GetRasterBand(band + 1);
                    buf_type = pBand.getDataType();
                    banks[band] = band;
                    offsetsR[band] = 0;
                    pBand.GetNoDataValue(tempD);
                    noDataValues[band] = tempD[0];
                    pBand.GetOffset(tempD);
                    offsets[band] = tempD[0];
                    pBand.GetScale(tempD);
                    scales[band] = tempD[0];
                    if (gdalconst.CE_None == pBand.GetStatistics(false, false, min, max, mean, stddev)) {
                        minimums[band] = min[0];
                        maximums[band] = max[0];
                    }
                    colorInterpretations[band] = pBand.GetRasterColorInterpretation();
                    numOverviews[band] = pBand.GetOverviewCount();
                    bandsOffset[band] = band;
                    continue;
                }
                finally {
                    block52: {
                        if (pBand != null) {
                            try {
                                pBand.delete();
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block52;
                                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
            }
            this.setNoDataValues(noDataValues);
            this.setScales(scales);
            this.setOffsets(offsets);
            this.setMinimums(minimums);
            this.setMaximums(maximums);
            this.setNumOverviews(numOverviews);
            this.setColorInterpretations(colorInterpretations);
            int buffer_type = 0;
            if (buf_type == gdalconstConstants.GDT_Byte) {
                buffer_type = 0;
            } else if (buf_type == gdalconstConstants.GDT_UInt16) {
                buffer_type = 1;
            } else if (buf_type == gdalconstConstants.GDT_Int16) {
                buffer_type = 2;
            } else if (buf_type == gdalconstConstants.GDT_Int32 || buf_type == gdalconstConstants.GDT_UInt32) {
                buffer_type = 3;
            } else if (buf_type == gdalconstConstants.GDT_Float32) {
                buffer_type = 4;
            } else if (buf_type == gdalconstConstants.GDT_Float64) {
                buffer_type = 5;
            } else {
                boolean e = false;
                return e;
            }
            if (tileSize < 0) {
                this.setSampleModel(new BandedSampleModel(buffer_type, tileWidth, tileHeight, tileWidth, banks, offsetsR));
            } else {
                this.setSampleModel(new PixelInterleavedSampleModel(buffer_type, tileWidth, tileHeight, numBands, tileWidth * numBands, bandsOffset));
            }
            if (colorInterpretations[0] == gdalconstConstants.GCI_PaletteIndex) {
                ColorTable ct = null;
                try {
                    ct = rband.GetRasterColorTable();
                    IndexColorModel icm = ct.getIndexColorModel(gdal.GetDataTypeSize((int)buf_type));
                    this.setColorModel(icm);
                }
                finally {
                    block53: {
                        if (ct != null) {
                            try {
                                ct.delete();
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block53;
                                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
            }
            this.setColorModel(GDALUtilities.buildColorModel(this.getSampleModel()));
            if (this.getColorModel() == null || this.getSampleModel() == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            block55: {
                if (rband != null) {
                    try {
                        rband.delete();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block55;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<it.geosolutions.imageio.core.GCP> getGCPs() {
        if (!super.getGCPs().isEmpty()) return super.getGCPs();
        Dataset ds = null;
        try {
            int nGCP = this.getGcpNumber();
            Vector gcps = new Vector(nGCP);
            ds = GDALUtilities.acquireDataSet(this.getDatasetName(), gdalconst.GA_ReadOnly);
            ds.GetGCPs(gcps);
            if (gcps != null && !gcps.isEmpty()) {
                ArrayList<it.geosolutions.imageio.core.GCP> groundControlPoints = new ArrayList<it.geosolutions.imageio.core.GCP>(nGCP);
                Iterator it = gcps.iterator();
                while (it.hasNext()) {
                    GCP gdalGcp = null;
                    try {
                        gdalGcp = (GCP)it.next();
                        it.geosolutions.imageio.core.GCP gcp = new it.geosolutions.imageio.core.GCP();
                        gcp.setId(gdalGcp.getId());
                        gcp.setDescription(gdalGcp.getInfo());
                        gcp.setColumn((int)gdalGcp.getGCPPixel());
                        gcp.setRow((int)gdalGcp.getGCPLine());
                        gcp.setEasting(gdalGcp.getGCPX());
                        gcp.setNorthing(gdalGcp.getGCPY());
                        gcp.setElevation(gdalGcp.getGCPZ());
                        groundControlPoints.add(gcp);
                    }
                    finally {
                        if (gdalGcp == null) continue;
                        try {
                            gdalGcp.delete();
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) continue;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                }
                this.setGcps(groundControlPoints);
            }
            if (ds == null) return super.getGCPs();
        }
        catch (Throwable throwable) {
            if (ds == null) throw throwable;
            try {
                GDALUtilities.closeDataSet(ds);
                throw throwable;
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            GDALUtilities.closeDataSet(ds);
            return super.getGCPs();
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINEST)) return super.getGCPs();
            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
        }
        return super.getGCPs();
    }

    private void performTileSizeTuning(Dataset dataset) {
        int width = dataset.getRasterXSize();
        int height = dataset.getRasterYSize();
        Dimension imageSize = new Dimension(width, height);
        Dimension tileSize = GDALUtilities.toTileSize(imageSize);
        this.setTileHeight(tileSize.height);
        this.setTileWidth(tileSize.width);
    }

    protected Map getGdalMetadataDomain(String metadataDomain) {
        if (metadataDomain.equalsIgnoreCase("")) {
            if (this.gdalDomainMetadataMap.containsKey("DEF")) {
                return this.gdalDomainMetadataMap.get("DEF");
            }
        } else if ((metadataDomain.equalsIgnoreCase("IMAGE_STRUCTURE") || metadataDomain.startsWith("xml:")) && this.gdalDomainMetadataMap.containsKey(metadataDomain)) {
            return this.gdalDomainMetadataMap.get(metadataDomain);
        }
        return null;
    }

    protected List<String> getGdalMetadataDomainsList() {
        Set<String> keys = this.gdalDomainMetadataMap.keySet();
        ArrayList<String> list = null;
        if (keys != null) {
            Iterator<String> keysIt = keys.iterator();
            list = new ArrayList<String>(keys.size());
            while (keysIt.hasNext()) {
                String key = keysIt.next();
                if (key.equals("DEF")) {
                    list.add("");
                    continue;
                }
                list.add(key);
            }
        }
        return list;
    }

    public GDALWritableCommonIIOImageMetadata asWritable() {
        GDALWritableCommonIIOImageMetadata metadata = new GDALWritableCommonIIOImageMetadata(this.getDatasetName());
        metadata.setDatasetDescription(this.getDatasetDescription());
        metadata.setProjection(this.getProjection());
        metadata.setGcpNumber(this.getGcpNumber());
        metadata.setGcpProjection(this.getGcpProjection());
        metadata.setGeoTransformation(this.getGeoTransformation());
        if (this.gdalDomainMetadataMap != null) {
            Map<String, Map<String, String>> inputMap = this.gdalDomainMetadataMap;
            HashMap map = new HashMap(inputMap.size());
            for (String key : inputMap.keySet()) {
                Map<String, String> valuesMap = inputMap.get(key);
                Iterator<String> inKeys = valuesMap.keySet().iterator();
                HashMap<String, String> innerMap = new HashMap<String, String>(valuesMap.size());
                while (inKeys.hasNext()) {
                    String ikey = inKeys.next();
                    String value = valuesMap.get(ikey);
                    innerMap.put(ikey, value);
                }
                map.put(key, innerMap);
            }
            metadata.gdalDomainMetadataMap = map;
        }
        metadata.setWidth(this.getWidth());
        metadata.setHeight(this.getHeight());
        metadata.setTileHeight(this.getTileHeight());
        metadata.setTileWidth(this.getTileWidth());
        metadata.setSampleModel(null);
        SampleModel sm = this.getSampleModel();
        if (sm != null) {
            int smWidth = sm.getWidth();
            int smHeight = sm.getHeight();
            metadata.setSampleModel(sm.createCompatibleSampleModel(smWidth, smHeight));
        }
        metadata.setNumBands(this.getNumBands());
        metadata.setColorModel(null);
        ColorModel cm = this.getColorModel();
        if (cm != null) {
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int mapSize = icm.getMapSize();
                byte[] r = new byte[mapSize];
                byte[] g = new byte[mapSize];
                byte[] b = new byte[mapSize];
                icm.getBlues(b);
                icm.getReds(r);
                icm.getGreens(g);
                if (icm.hasAlpha()) {
                    byte[] a = new byte[mapSize];
                    icm.getAlphas(a);
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b, a));
                } else {
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b));
                }
            } else {
                metadata.setColorModel(GDALUtilities.buildColorModel(metadata.getSampleModel()));
            }
        }
        metadata.setMaximums(this.getMaximums());
        metadata.setMinimums(this.getMinimums());
        metadata.setNoDataValues(this.getNoDataValues());
        metadata.setScales(this.getScales());
        metadata.setOffsets(this.getOffsets());
        metadata.setNumOverviews(this.getNumOverviews());
        metadata.setColorInterpretations(this.getColorInterpretations());
        return metadata;
    }
}

