/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.ecw;

import it.geosolutions.imageio.gdalframework.GDALImageReader;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.plugins.ecw.ECWImageReaderSpi;
import it.geosolutions.imageio.plugins.ecw.ECWPImageInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECWImageReader
extends GDALImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.ecw");

    public ECWImageReader(ECWImageReaderSpi originatingProvider) {
        super((GDALImageReaderSpi)originatingProvider, 0);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ECWImageReader Constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting Input");
        }
        if (input != null && input instanceof ECWPImageInputStream) {
            try {
                boolean isDecodable = ((GDALImageReaderSpi)this.getOriginatingProvider()).canDecodeInput(input);
                if (!isDecodable) return;
                super.setInput(input, seekForwardOnly, ignoreMetadata);
                return;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to create a valid input stream ", e);
            }
        } else {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
        }
    }
}

