/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.PropertyLocator;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class S3ConfigurationProperties {
    private static final String S3_DOT = "s3.";
    private static final String S3_DASH = "s3-";
    static final String S3_DOT_VH = ".s3.";
    private static final String S3_DASH_VH = ".s3-";
    static final String AMAZON_AWS = ".amazonaws.com";
    private String user;
    private String password;
    private String endpoint;
    private String region;
    private String alias;
    private String bucket;
    private String key;
    private String filename;
    private int corePoolSize;
    private int maxPoolSize;
    private int keepAliveTime;
    private boolean forcePathStyle;
    public final String AWS_S3_USER_KEY;
    public final String AWS_S3_PASSWORD_KEY;
    public final String AWS_S3_ENDPOINT_KEY;
    public final String AWS_S3_REGION_KEY;
    public final String AWS_S3_CORE_POOL_SIZE_KEY;
    public final String AWS_S3_MAX_POOL_SIZE_KEY;
    public final String AWS_S3_KEEP_ALIVE_TIME;
    public final String AWS_S3_FORCE_PATH_STYLE;
    private static final Logger LOGGER = Logger.getLogger(S3ConfigurationProperties.class.getName());

    public S3ConfigurationProperties(String alias, BasicAuthURI cogUri) {
        this.alias = alias.toUpperCase();
        this.AWS_S3_USER_KEY = "IIO_" + this.alias + "_AWS_USER";
        this.AWS_S3_PASSWORD_KEY = "IIO_" + this.alias + "_AWS_PASSWORD";
        this.AWS_S3_ENDPOINT_KEY = "IIO_" + this.alias + "_AWS_ENDPOINT";
        this.AWS_S3_REGION_KEY = "IIO_" + this.alias + "_AWS_REGION";
        this.AWS_S3_CORE_POOL_SIZE_KEY = "IIO_" + this.alias + "_AWS_CORE_POOL_SIZE";
        this.AWS_S3_MAX_POOL_SIZE_KEY = "IIO_" + this.alias + "_AWS_MAX_POOL_SIZE";
        this.AWS_S3_KEEP_ALIVE_TIME = "IIO_" + this.alias + "_AWS_KEEP_ALIVE_TIME";
        this.AWS_S3_FORCE_PATH_STYLE = "IIO_" + this.alias + "_AWS_FORCE_PATH_STYLE";
        this.user = PropertyLocator.getEnvironmentValue((String)this.AWS_S3_USER_KEY, null);
        this.password = PropertyLocator.getEnvironmentValue((String)this.AWS_S3_PASSWORD_KEY, null);
        this.region = PropertyLocator.getEnvironmentValue((String)this.AWS_S3_REGION_KEY, null);
        this.endpoint = PropertyLocator.getEnvironmentValue((String)this.AWS_S3_ENDPOINT_KEY, null);
        this.corePoolSize = Integer.parseInt(PropertyLocator.getEnvironmentValue((String)this.AWS_S3_CORE_POOL_SIZE_KEY, (String)"50"));
        this.maxPoolSize = Integer.parseInt(PropertyLocator.getEnvironmentValue((String)this.AWS_S3_MAX_POOL_SIZE_KEY, (String)"128"));
        this.keepAliveTime = Integer.parseInt(PropertyLocator.getEnvironmentValue((String)this.AWS_S3_KEEP_ALIVE_TIME, (String)"10"));
        this.forcePathStyle = Boolean.parseBoolean(PropertyLocator.getEnvironmentValue((String)this.AWS_S3_FORCE_PATH_STYLE, (String)"false"));
        if (cogUri.getUser() != null && cogUri.getPassword() != null) {
            this.user = cogUri.getUser();
            this.password = cogUri.getPassword();
        }
        S3URIParser parser = null;
        URI uri = cogUri.getUri();
        String scheme = uri.getScheme().toLowerCase();
        if (scheme.startsWith("http")) {
            String host = uri.getHost();
            String hostLowerCase = host.toLowerCase();
            if ((hostLowerCase.startsWith(S3_DASH) || hostLowerCase.startsWith(S3_DOT)) && host.contains(".")) {
                parser = new HTTPPathStyleParser(uri, this.region, hostLowerCase.startsWith(S3_DASH));
            } else if (hostLowerCase.contains(S3_DASH_VH) || hostLowerCase.contains(S3_DOT_VH)) {
                parser = new HTTPVirtualHostedStyleParser(uri, this.region, hostLowerCase.contains(S3_DASH_VH));
            }
        } else if (scheme.startsWith("s3")) {
            parser = new S3Parser(uri, this.region);
        }
        if (parser == null) {
            throw new RuntimeException("Unable to parse the specified URI: " + uri);
        }
        this.region = parser.region;
        if (this.region == null) {
            throw new RuntimeException("No region info found for alias " + this.alias + ".  Please set environment variable '" + this.AWS_S3_REGION_KEY + "' or system property '" + PropertyLocator.convertEnvVarToProperty((String)this.AWS_S3_REGION_KEY) + "'");
        }
        this.bucket = parser.bucket;
        this.key = parser.key;
        this.filename = this.nameFromKey(this.key);
    }

    private String nameFromKey(String key) {
        String[] parts = key.split("/");
        return parts[parts.length - 1];
    }

    public static Map<String, List<String>> splitQuery(URI uri) {
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            String[] pairs;
            LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
            for (String pair : pairs = query.split("&")) {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                if (!query_pairs.containsKey(key)) {
                    query_pairs.put(key, new LinkedList());
                }
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                ((List)query_pairs.get(key)).add(value);
            }
            return query_pairs;
        }
        catch (Exception e) {
            LOGGER.warning("Unable to split query into key/value pairs for URI " + uri + ". " + e.getMessage());
            return Collections.emptyMap();
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public boolean getForcePathStyle() {
        return this.forcePathStyle;
    }

    class S3Parser
    extends S3URIParser {
        S3Parser(URI uri, String defaultRegion) {
            super(uri, defaultRegion);
            String path = uri.getPath();
            path = path.startsWith("/") ? path.substring(1) : path;
            this.bucket = uri.getHost();
            this.key = path;
            String queryRegion = null;
            for (Map.Entry<String, List<String>> entry : S3ConfigurationProperties.splitQuery(uri).entrySet()) {
                List<String> regions;
                if (!entry.getKey().equalsIgnoreCase("region") || (regions = entry.getValue()) == null || regions.size() <= 0) continue;
                queryRegion = regions.get(0);
            }
            if (queryRegion != null) {
                this.region = queryRegion;
            }
        }
    }

    class HTTPVirtualHostedStyleParser
    extends S3URIParser {
        private final boolean isOldDashRegion;

        HTTPVirtualHostedStyleParser(URI uri, String defaultRegion, boolean isOldDashRegion) {
            String path;
            String hostRegion;
            super(uri, defaultRegion);
            this.isOldDashRegion = isOldDashRegion;
            int domainIndex = this.host.indexOf(S3ConfigurationProperties.AMAZON_AWS);
            String s3Prefix = isOldDashRegion ? S3ConfigurationProperties.S3_DASH_VH : S3ConfigurationProperties.S3_DOT_VH;
            int s3Index = this.host.indexOf(s3Prefix);
            this.bucket = this.host.substring(0, s3Index);
            if (this.bucket.length() + s3Prefix.length() < domainIndex && (hostRegion = this.host.substring(this.bucket.length() + s3Prefix.length(), domainIndex)) != null) {
                this.region = hostRegion;
            }
            this.key = path = (path = uri.getPath()).startsWith("/") ? path.substring(1) : path;
        }
    }

    class HTTPPathStyleParser
    extends S3URIParser {
        private final boolean isOldDashRegion;

        HTTPPathStyleParser(URI uri, String defaultRegion, boolean isOldDashRegion) {
            String path;
            super(uri, defaultRegion);
            this.isOldDashRegion = isOldDashRegion;
            String hostRegion = this.host.substring(S3ConfigurationProperties.S3_DASH.length()).split("\\.")[0];
            if (hostRegion != null) {
                this.region = hostRegion;
            }
            path = (path = uri.getPath()).startsWith("/") ? path.substring(1) : path;
            this.bucket = path.split("/")[0];
            this.key = path.substring(this.bucket.length() + 1);
        }
    }

    static abstract class S3URIParser {
        protected String region;
        protected String bucket;
        protected String key;
        protected String scheme;
        protected String host;
        protected URI uri;

        S3URIParser(URI uri, String defaultRegion) {
            this.uri = uri;
            this.region = defaultRegion;
            this.scheme = uri.getScheme().toLowerCase();
            this.host = uri.getHost();
        }
    }
}

