/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.AbstractRangeReader;
import it.geosolutions.imageioimpl.plugins.cog.AsyncHttpCallback;
import it.geosolutions.imageioimpl.plugins.cog.HttpClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpRangeReader
extends AbstractRangeReader {
    protected OkHttpClient client;
    private String credentials;
    private static final int MAX_RETRIES;
    private static final Logger LOGGER;

    public HttpRangeReader(String url, int headerLength) {
        this(URI.create(url), headerLength);
    }

    public HttpRangeReader(URL url, int headerLength) {
        this(URI.create(url.toString()), headerLength);
    }

    public HttpRangeReader(URI uri, int headerLength) {
        this(new BasicAuthURI(uri), headerLength);
    }

    public HttpRangeReader(BasicAuthURI uri, int headerLength) {
        super(uri, headerLength);
        if (uri.getUser() != null && uri.getPassword() != null) {
            this.credentials = Credentials.basic((String)uri.getUser(), (String)uri.getPassword());
        }
        this.client = HttpClientFactory.getClient();
    }

    public byte[] readHeader() {
        byte[] byArray;
        block10: {
            LOGGER.fine("reading header");
            byte[] currentHeader = (byte[])HEADERS_CACHE.get(this.uri.toString());
            if (currentHeader != null) {
                return currentHeader;
            }
            Request request = this.buildRequest(new long[]{this.headerOffset, this.headerOffset + this.headerLength - 1}, null);
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("Unable to read header for " + this.uri + ". Code: " + response.code() + ". Reason: " + response.message());
                }
                byte[] headerBytes = response.body().bytes();
                this.data.put((Object)0L, (Object)headerBytes);
                HEADERS_CACHE.put(this.uri.toString(), headerBytes);
                byArray = headerBytes;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read header for " + this.uri, e);
                }
            }
            response.close();
        }
        return byArray;
    }

    public byte[] fetchHeader() {
        byte[] byArray;
        block11: {
            LOGGER.fine("Fetching header");
            byte[] currentHeader = (byte[])this.data.get((Object)0L);
            if (currentHeader != null) {
                this.headerOffset = currentHeader.length;
            }
            Request request = this.buildRequest(new long[]{this.headerOffset, this.headerOffset + this.headerLength - 1}, null);
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("Unable to read header for " + this.uri + ". Code: " + response.code() + ". Reason: " + response.message());
                }
                byte[] headerBytes = response.body().bytes();
                if (this.headerOffset != 0) {
                    byte[] oldHeader = (byte[])this.data.get((Object)0L);
                    byte[] newHeader = new byte[headerBytes.length + oldHeader.length];
                    System.arraycopy(oldHeader, 0, newHeader, 0, oldHeader.length);
                    System.arraycopy(headerBytes, 0, newHeader, oldHeader.length, headerBytes.length);
                    headerBytes = newHeader;
                    HEADERS_CACHE.put(this.uri.toString(), newHeader);
                }
                this.data.put((Object)0L, (Object)headerBytes);
                byArray = headerBytes;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read header for " + this.uri, e);
                }
            }
            response.close();
        }
        return byArray;
    }

    public Map<Long, byte[]> read(Collection<long[]> ranges) {
        return this.read((long[][])ranges.toArray((T[])new long[0][]));
    }

    public Map<Long, byte[]> read(long[] ... ranges) {
        if ((ranges = this.reconcileRanges(ranges)).length == 0) {
            return this.data;
        }
        Instant start = Instant.now();
        ArrayList<AsyncHttpCallback> callbacks = new ArrayList<AsyncHttpCallback>(ranges.length);
        HashMap<Long, byte[]> values = new HashMap<Long, byte[]>();
        int[] missingRanges = new int[ranges.length];
        int missing = 0;
        for (int i = 0; i < ranges.length; ++i) {
            byte[] dataRange = (byte[])this.data.get((Object)ranges[i][0]);
            if (dataRange == null) {
                Call call = this.client.newCall(this.buildRequest(ranges[i], null));
                AsyncHttpCallback callback = new AsyncHttpCallback().initRange(ranges[i]);
                call.enqueue((Callback)callback);
                callbacks.add(callback);
                missingRanges[missing++] = i;
                continue;
            }
            values.put(ranges[i][0], dataRange);
        }
        this.awaitCompletion(values, callbacks);
        Instant end = Instant.now();
        LOGGER.fine("Time to read all ranges: " + Duration.between(start, end));
        for (int k = 0; k < missing; ++k) {
            long range = ranges[missingRanges[k]][0];
            this.data.put((Object)range, (Object)((byte[])values.get(range)));
        }
        return values;
    }

    protected void awaitCompletion(Map<Long, byte[]> data, List<AsyncHttpCallback> callbacks) {
        boolean stillWaiting = true;
        ArrayList<Long> completed = new ArrayList<Long>(callbacks.size());
        int attempts = 0;
        while (stillWaiting) {
            boolean allDone = true;
            for (AsyncHttpCallback callback : callbacks) {
                AsyncHttpCallback.Status status = callback.getStatus();
                if (status == AsyncHttpCallback.Status.DONE) {
                    if (completed.contains(callback.getStartPosition())) continue;
                    try {
                        data.put(callback.getStartPosition(), callback.getBytes());
                        completed.add(callback.getStartPosition());
                    }
                    catch (Exception e) {
                        LOGGER.severe("An error occurred while writing the contents of the HTTP response to the final ByteBuffer.  " + e.getMessage());
                    }
                    continue;
                }
                if (status == AsyncHttpCallback.Status.FAILED) {
                    if (attempts >= MAX_RETRIES) continue;
                    long[] range = new long[]{callback.getStartPosition(), callback.getEndPosition()};
                    callback.resetStatus();
                    Call call = this.client.newCall(this.buildRequest(range, "*/*"));
                    call.enqueue((Callback)callback);
                    allDone = false;
                    ++attempts;
                    continue;
                }
                allDone = false;
            }
            stillWaiting = !allDone;
        }
    }

    protected Request buildRequest(long[] range, String accept) {
        LOGGER.fine("Building request for range " + range[0] + "-" + range[1] + " to " + this.uri.toString());
        Request.Builder requestBuilder = new Request.Builder().url(this.uri.toString()).header("range", "bytes=" + range[0] + "-" + range[1]);
        if (accept != null && !accept.isEmpty()) {
            requestBuilder.header("Accept", accept);
        }
        if (this.credentials != null) {
            requestBuilder.header("Authorization", this.credentials);
        }
        return requestBuilder.build();
    }

    static {
        String maxRetries = System.getProperty("it.geosolutions.cog.http.maxretries", "5");
        MAX_RETRIES = Integer.parseInt(maxRetries);
        LOGGER = Logger.getLogger(HttpRangeReader.class.getName());
    }
}

