/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid.raster;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageWriter;
import it.geosolutions.imageio.plugins.arcgrid.raster.AsciiGridRaster;
import it.geosolutions.imageio.utilities.StringToDouble;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

final class GrassAsciiGridRaster
extends AsciiGridRaster {
    public static final String COLS = "COLS:";
    public static final String ROWS = "ROWS:";
    public static final String NORTH = "NORTH:";
    public static final String SOUTH = "SOUTH:";
    public static final String EAST = "EAST:";
    public static final String WEST = "WEST:";
    public static final String NO_DATA_MARKER = "*";

    public GrassAsciiGridRaster(ImageInputStream iis) {
        super(iis);
    }

    public GrassAsciiGridRaster(ImageInputStream iis, AsciiGridsImageReader reader) {
        super(iis, reader);
    }

    public GrassAsciiGridRaster(ImageOutputStream ios) {
        super(ios);
    }

    public GrassAsciiGridRaster(ImageOutputStream ios, AsciiGridsImageWriter writer) {
        super(ios, writer);
    }

    @Override
    public void parseHeader() throws IOException {
        byte b;
        double north = 0.0;
        double south = 0.0;
        double east = 0.0;
        double west = 0.0;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("Header Parsed: ");
        }
        boolean keepParsing = true;
        this.imageIS.mark();
        int requiredFields = 0;
        String sKey = null;
        int maxNumBytes = 100;
        double value = 0.0;
        StringToDouble doubleConverter = StringToDouble.acquire();
        while (keepParsing && !((sKey = this.getKey(this.imageIS, maxNumBytes, 6, (byte)58)) == null | sKey.length() == 0) && sKey != "" && !Double.isNaN(value = this.getValue(this.imageIS, maxNumBytes, 150, doubleConverter)) && !Double.isNaN(value)) {
            if (NORTH.equalsIgnoreCase(sKey)) {
                north = value;
                ++requiredFields;
                continue;
            }
            if (SOUTH.equalsIgnoreCase(sKey)) {
                south = value;
                ++requiredFields;
                continue;
            }
            if (EAST.equalsIgnoreCase(sKey)) {
                east = value;
                ++requiredFields;
                continue;
            }
            if (WEST.equalsIgnoreCase(sKey)) {
                west = value;
                ++requiredFields;
                continue;
            }
            if (ROWS.equalsIgnoreCase(sKey)) {
                this.nRows = (int)value;
                ++requiredFields;
                continue;
            }
            if (COLS.equalsIgnoreCase(sKey)) {
                this.nCols = (int)value;
                keepParsing = false;
                ++requiredFields;
                continue;
            }
            keepParsing = false;
        }
        StringToDouble.release((StringToDouble)doubleConverter);
        if (requiredFields != 6) {
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        }
        int limit = 0;
        do {
            b = (byte)(this.imageIS.read() & 0xFF);
            if (++limit > 100) {
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            }
            if (b != -1) continue;
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        } while (b == 32 || b == 9 || b == 10 || b == 13 || (b < 48 || b > 57) && b != 43 && b != 45 && b != 42);
        this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
        this.imageIS.reset();
        this.imageIS.mark();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("\tnCols:" + this.nCols);
            LOGGER.info("\tnRows:" + this.nRows);
        }
        this.xllCellCoordinate = west;
        this.yllCellCoordinate = south;
        this.isCorner = true;
        this.cellSizeY = (north - south) / (double)this.nRows;
        this.cellSizeX = (east - west) / (double)this.nCols;
    }

    @Override
    public void writeHeader(String columnsString, String rowsString, String xllString, String yllString, String cellsizeStringX, String cellsizeStringY, String rasterSpaceType, String noDataValue) throws IOException {
        this.nCols = Integer.parseInt(columnsString);
        this.nRows = Integer.parseInt(rowsString);
        this.cellSizeX = Double.parseDouble(cellsizeStringX);
        this.cellSizeY = Double.parseDouble(cellsizeStringY);
        this.xllCellCoordinate = Double.parseDouble(xllString);
        this.yllCellCoordinate = Double.parseDouble(yllString);
        this.noData = Double.parseDouble(noDataValue);
        double west = this.xllCellCoordinate;
        double south = this.yllCellCoordinate;
        double north = south + this.cellSizeY * (double)this.nRows;
        double east = west + this.cellSizeX * (double)this.nCols;
        this.imageOS.writeBytes(new StringBuffer(NORTH).append(" ").append(Double.toString(north)).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(SOUTH).append(" ").append(Double.toString(south)).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(EAST).append(" ").append(Double.toString(east)).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(WEST).append(" ").append(Double.toString(west)).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(ROWS).append(" ").append(rowsString).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(COLS).append(" ").append(columnsString).append(newline).toString());
    }

    @Override
    public String getNoDataMarker() {
        return NO_DATA_MARKER;
    }

    @Override
    public AsciiGridRaster.AsciiGridRasterType getRasterType() {
        return AsciiGridRaster.AsciiGridRasterType.GRASS;
    }
}

