/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.exception.ReservedUserGroupNameEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class UserGroupServiceImplTest
extends ServiceTestBase {
    @Test
    public void testGroupCRUDOperations() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        userGroupService.insert(ug1);
        UserGroup ug2 = new UserGroup();
        ug2.setGroupName("ug2");
        userGroupService.insert(ug2);
        UserGroup ug3 = new UserGroup();
        ug3.setGroupName("ug3");
        userGroupService.insert(ug3);
        UserGroup ug4 = new UserGroup();
        ug4.setGroupName("ug4");
        userGroupService.insert(ug4);
        List groups = userGroupService.getAll(null, null);
        UserGroupServiceImplTest.assertEquals((String)"Saved 4 groups but retrieved less or more groups...", (int)4, (int)groups.size());
        userGroupService.delete(ug4.getId().longValue());
        groups = userGroupService.getAll(null, null);
        UserGroupServiceImplTest.assertEquals((String)"Removed 1 group of 4 but retrieved less or more groups...", (int)3, (int)groups.size());
    }

    @Test
    public void testAssignGroupToUser() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        long gid = userGroupService.insert(ug1);
        User u = new User();
        u.setName("u1");
        u.setPassword("password");
        u.setRole(Role.USER);
        long uid = userService.insert(u);
        userGroupService.assignUserGroup(uid, gid);
        User uu = userService.get(uid);
        Set groups = uu.getGroups();
        UserGroupServiceImplTest.assertEquals((String)"GroupSize must be 1!", (int)1, (int)groups.size());
    }

    @Test
    public void testChangeGroupPermissionsOnResources() throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        long gid = userGroupService.insert(ug1);
        User u = new User();
        u.setName("u1");
        u.setPassword("password");
        u.setRole(Role.USER);
        HashSet<UserGroup> group = new HashSet<UserGroup>();
        group.add(ug1);
        u.setGroups(group);
        long uid = userService.insert(u);
        Resource r = new Resource();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Attribute a1 = new Attribute();
        a1.setTextValue("a1");
        a1.setType(DataType.STRING);
        a1.setName("a1");
        attributeList.add(a1);
        r.setAttribute(attributeList);
        Category cat = new Category();
        cat.setName("cat1");
        r.setCategory(cat);
        r.setCreation(new Date());
        r.setName("r1");
        categoryService.insert(cat);
        long id = resourceService.insert(r);
        r = resourceService.get(id);
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        List resourcelist = resourceDAO.findResources(idList);
        List listSecurity = ((Resource)resourcelist.get(0)).getSecurity();
        UserGroupServiceImplTest.assertEquals((int)0, (int)listSecurity.size());
        ArrayList<Long> listR = new ArrayList<Long>();
        listR.add(r.getId());
        List listsr = userGroupService.updateSecurityRules(ug1.getId(), listR, true, true);
        UserGroupServiceImplTest.assertEquals((int)1, (int)listsr.size());
        UserGroupServiceImplTest.assertTrue((String)"Expected TRUE", (boolean)((ShortResource)listsr.get(0)).isCanDelete());
        UserGroupServiceImplTest.assertTrue((String)"Expected TRUE", (boolean)((ShortResource)listsr.get(0)).isCanEdit());
        UserGroupServiceImplTest.assertTrue((String)"Expected TRUE", (boolean)((ShortResource)listsr.get(0)).isCanCopy());
        idList = new ArrayList();
        idList.add(id);
        resourcelist = resourceDAO.findResources(idList);
        listSecurity = ((Resource)resourcelist.get(0)).getSecurity();
        UserGroupServiceImplTest.assertEquals((int)1, (int)listSecurity.size());
        listsr = userGroupService.updateSecurityRules(ug1.getId(), listR, false, false);
        UserGroupServiceImplTest.assertEquals((int)1, (int)listsr.size());
        UserGroupServiceImplTest.assertFalse((String)"Expected FALSE", (boolean)((ShortResource)listsr.get(0)).isCanDelete());
        UserGroupServiceImplTest.assertFalse((String)"Expected FALSE", (boolean)((ShortResource)listsr.get(0)).isCanEdit());
        UserGroupServiceImplTest.assertFalse((String)"Expected FALSE", (boolean)((ShortResource)listsr.get(0)).isCanCopy());
    }

    @Test
    public void testInsertGroupWithAttributes() throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup ug = userGroupService.get(id);
        List attributes = ug.getAttributes();
        UserGroupServiceImplTest.assertEquals((int)2, (int)attributes.size());
        UserGroupServiceImplTest.assertEquals((String)"attr1", (String)((UserGroupAttribute)attributes.get(0)).getName());
        UserGroupServiceImplTest.assertEquals((String)"attr2", (String)((UserGroupAttribute)attributes.get(1)).getName());
    }

    @Test
    public void testUpdateGroup() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup toUpdate = userGroupService.get(id);
        toUpdate.setDescription("Updated Description");
        long idUpdated = userGroupService.update(toUpdate);
        UserGroup updated = userGroupService.get(idUpdated);
        UserGroupServiceImplTest.assertEquals((long)id, (long)idUpdated);
        UserGroupServiceImplTest.assertEquals((String)"Updated Description", (String)updated.getDescription());
    }

    @Test
    public void testUpdateUserGroupAttributes() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroupAttribute attributeToUpdate1 = new UserGroupAttribute();
        attributeToUpdate1.setName(attribute.getName());
        attributeToUpdate1.setValue(attribute.getValue());
        UserGroupAttribute attributeToUpdate2 = new UserGroupAttribute();
        attributeToUpdate2.setName("updated");
        attributeToUpdate2.setValue("updatedValue");
        List<UserGroupAttribute> attributes = Arrays.asList(attributeToUpdate1, attributeToUpdate2);
        userGroupService.updateAttributes(id, attributes);
        UserGroup groupUpdated = userGroupService.get(id);
        List updatedList = groupUpdated.getAttributes();
        UserGroupServiceImplTest.assertTrue((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attribute.getName())));
        UserGroupServiceImplTest.assertTrue((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attributeToUpdate2.getName())));
        UserGroupServiceImplTest.assertFalse((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attribute2.getName())));
    }

    @Test
    public void testgetByAttributes() throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("organization");
        attribute.setValue("value");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup group2 = new UserGroup();
        group2.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute21 = new UserGroupAttribute();
        attribute21.setName("Organization");
        attribute21.setValue("value");
        UserGroupAttribute attribute22 = new UserGroupAttribute();
        attribute22.setName("attr2");
        attribute22.setValue("value4,value5,value6");
        group2.setAttributes(Arrays.asList(attribute21, attribute22));
        userGroupService.insert(group2);
        UserGroupAttribute groupAttribute = new UserGroupAttribute();
        groupAttribute.setName("organization");
        groupAttribute.setValue("value");
        Collection groups = userGroupService.findByAttribute("organization", Arrays.asList("value"), true);
        UserGroupServiceImplTest.assertEquals((int)2, (int)groups.size());
        groups = userGroupService.findByAttribute("organization", Arrays.asList("value"), false);
        UserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
    }

    @Test
    public void testGetWithAttributesLoadsAllAttributes() throws Exception {
        UserGroup group = new UserGroup();
        group.setGroupName("group-get-with-attrs");
        UserGroupAttribute a1 = new UserGroupAttribute();
        a1.setName("k1");
        a1.setValue("v1");
        UserGroupAttribute a2 = new UserGroupAttribute();
        a2.setName("k2");
        a2.setValue("v2");
        group.setAttributes(Arrays.asList(a1, a2));
        long id = userGroupService.insert(group);
        UserGroup loaded = userGroupService.getWithAttributes(id);
        UserGroupServiceImplTest.assertNotNull((Object)loaded);
        UserGroupServiceImplTest.assertEquals((long)id, (long)loaded.getId());
        UserGroupServiceImplTest.assertNotNull((String)"Attributes must be initialized", (Object)loaded.getAttributes());
        UserGroupServiceImplTest.assertEquals((int)2, (int)loaded.getAttributes().size());
        UserGroupServiceImplTest.assertTrue((boolean)loaded.getAttributes().stream().anyMatch(ua -> "k1".equals(ua.getName()) && "v1".equals(ua.getValue())));
        UserGroupServiceImplTest.assertTrue((boolean)loaded.getAttributes().stream().anyMatch(ua -> "k2".equals(ua.getName()) && "v2".equals(ua.getValue())));
    }

    @Test
    public void testUpsertAttributeInsertAndUpdate() throws Exception {
        UserGroup group = new UserGroup();
        group.setGroupName("group-upsert-attrs");
        UserGroupAttribute base = new UserGroupAttribute();
        base.setName("base");
        base.setValue("b0");
        group.setAttributes(Arrays.asList(base));
        long id = userGroupService.insert(group);
        userGroupService.upsertAttribute(id, "k1", "v1");
        UserGroup afterInsert = userGroupService.getWithAttributes(id);
        UserGroupServiceImplTest.assertNotNull((Object)afterInsert.getAttributes());
        UserGroupServiceImplTest.assertEquals((String)"Should still have 2 attributes (base + k1)", (int)2, (int)afterInsert.getAttributes().size());
        UserGroupServiceImplTest.assertTrue((boolean)afterInsert.getAttributes().stream().anyMatch(a -> "base".equals(a.getName()) && "b0".equals(a.getValue())));
        UserGroupServiceImplTest.assertTrue((boolean)afterInsert.getAttributes().stream().anyMatch(a -> "k1".equals(a.getName()) && "v1".equals(a.getValue())));
        userGroupService.upsertAttribute(id, "k1", "v2");
        UserGroup afterUpdate = userGroupService.getWithAttributes(id);
        UserGroupServiceImplTest.assertEquals((String)"Attribute count must remain the same after update", (int)2, (int)afterUpdate.getAttributes().size());
        long k1Count = afterUpdate.getAttributes().stream().filter(a -> "k1".equals(a.getName())).count();
        UserGroupServiceImplTest.assertEquals((String)"Upsert must not duplicate attributes with the same name", (long)1L, (long)k1Count);
        UserGroupServiceImplTest.assertTrue((boolean)afterUpdate.getAttributes().stream().anyMatch(a -> "k1".equals(a.getName()) && "v2".equals(a.getValue())));
        UserGroupServiceImplTest.assertTrue((boolean)afterUpdate.getAttributes().stream().anyMatch(a -> "base".equals(a.getName()) && "b0".equals(a.getValue())));
        userGroupService.upsertAttribute(id, "k2", "v2");
        UserGroup afterSecondInsert = userGroupService.getWithAttributes(id);
        UserGroupServiceImplTest.assertEquals((String)"Now we should have 3 attributes", (int)3, (int)afterSecondInsert.getAttributes().size());
        UserGroupServiceImplTest.assertTrue((boolean)afterSecondInsert.getAttributes().stream().anyMatch(a -> "k2".equals(a.getName()) && "v2".equals(a.getValue())));
    }

    @Test
    public void testUpsertAttributeOnMissingGroupThrowsNotFound() {
        long missingId = Long.MAX_VALUE;
        try {
            userGroupService.upsertAttribute(missingId, "any", "value");
            UserGroupServiceImplTest.fail((String)"Expected NotFoundServiceEx to be thrown");
        }
        catch (NotFoundServiceEx e) {
            String msg = e.getMessage() == null ? "" : e.getMessage().toLowerCase();
            UserGroupServiceImplTest.assertTrue((String)"Exception message should hint 'not found'", (msg.contains("not found") || msg.contains("usergroup") ? 1 : 0) != 0);
        }
        catch (Exception other) {
            UserGroupServiceImplTest.fail((String)("Unexpected exception type: " + String.valueOf(other)));
        }
    }

    @Test
    public void testInsertReservedGroupFails() throws BadRequestServiceEx {
        Assert.assertThrows(ReservedUserGroupNameEx.class, () -> userGroupService.insert(UserGroupServiceImplTest.group(GroupReservedNames.EVERYONE.groupName())));
    }

    @Test
    public void testDeleteReservedGroupFails() throws Exception {
        this.ensureReservedExists();
        UserGroup everyone = userGroupService.get(GroupReservedNames.EVERYONE.groupName());
        UserGroupServiceImplTest.assertNotNull((String)"Reserved EVERYONE group must exist for this test", (Object)everyone);
        Assert.assertThrows(BadRequestServiceEx.class, () -> userGroupService.delete(everyone.getId().longValue()));
    }

    @Test
    public void testAssignReservedGroupFails() throws Exception {
        this.ensureReservedExists();
        UserGroup everyone = userGroupService.get(GroupReservedNames.EVERYONE.groupName());
        UserGroupServiceImplTest.assertNotNull((String)"Reserved EVERYONE group must exist for this test", (Object)everyone);
        long uid = userService.insert(UserGroupServiceImplTest.user("u"));
        Assert.assertThrows(NotFoundServiceEx.class, () -> userGroupService.assignUserGroup(uid, everyone.getId().longValue()));
    }

    @Test
    public void testGetAllAllowedForRegularUser() throws Exception {
        long g1 = userGroupService.insert(UserGroupServiceImplTest.group("A"));
        long g2 = userGroupService.insert(UserGroupServiceImplTest.group("B"));
        long g3 = userGroupService.insert(UserGroupServiceImplTest.group("C"));
        long uid = userService.insert(UserGroupServiceImplTest.user("u1"));
        userGroupService.assignUserGroup(uid, g1);
        userGroupService.assignUserGroup(uid, g3);
        User u = userService.get(uid);
        List allowed = userGroupService.getAllAllowed(u, null, null, null, true);
        UserGroupServiceImplTest.assertEquals(Set.of(Long.valueOf(g1), Long.valueOf(g3)), allowed.stream().map(UserGroup::getId).collect(Collectors.toSet()));
    }

    @Test
    public void testGetAllPaginationAndSorting() throws Exception {
        for (String n : List.of("bbb", "aaa", "ccc")) {
            userGroupService.insert(UserGroupServiceImplTest.group(n));
        }
        List page0 = userGroupService.getAll(Integer.valueOf(0), Integer.valueOf(2));
        UserGroupServiceImplTest.assertEquals(List.of("aaa", "bbb"), page0.stream().map(UserGroup::getGroupName).collect(Collectors.toList()));
        List page1 = userGroupService.getAll(Integer.valueOf(1), Integer.valueOf(2));
        UserGroupServiceImplTest.assertEquals(List.of("ccc"), page1.stream().map(UserGroup::getGroupName).collect(Collectors.toList()));
    }

    @Test
    public void testNameLikeAndReservedToggle() throws Exception {
        userGroupService.insert(UserGroupServiceImplTest.group("devs"));
        userGroupService.insert(UserGroupServiceImplTest.group("qa"));
        this.ensureReservedExists();
        UserGroupServiceImplTest.assertEquals((int)1, (int)userGroupService.getAll(null, null, "de%", true).size());
        UserGroupServiceImplTest.assertEquals((int)0, (int)userGroupService.getAll(null, null, "EVER%", false).size());
    }

    @Test
    public void testUpdateByNameWhenIdMissing() throws Exception {
        long id = userGroupService.insert(UserGroupServiceImplTest.group("updateMe"));
        UserGroup g = new UserGroup();
        g.setGroupName("updateMe");
        g.setDescription("D");
        g.setId(Long.valueOf(0L));
        long updatedId = userGroupService.update(g);
        UserGroupServiceImplTest.assertEquals((long)id, (long)updatedId);
        UserGroupServiceImplTest.assertEquals((String)"D", (String)userGroupService.get(id).getDescription());
    }

    @Test
    public void testUpdateAttributesReplacesAll() throws Exception {
        long id = userGroupService.insert(UserGroupServiceImplTest.groupWithAttrs("G", UserGroupServiceImplTest.attr("a", "1"), UserGroupServiceImplTest.attr("b", "2")));
        userGroupService.updateAttributes(id, List.of(UserGroupServiceImplTest.attr("a", "1"), UserGroupServiceImplTest.attr("c", "3")));
        List attrs = userGroupService.getWithAttributes(id).getAttributes();
        UserGroupServiceImplTest.assertNames(attrs, "a", "c");
    }

    @Test
    public void testUpsertAttributeUpdatesCaseInsensitiveAndNullValue() throws Exception {
        long id = userGroupService.insert(UserGroupServiceImplTest.groupWithAttrs("G", UserGroupServiceImplTest.attr("SoUrCeSeRvIcE", "old")));
        userGroupService.upsertAttribute(id, "sourceservice", null);
        UserGroup g = userGroupService.getWithAttributes(id);
        UserGroupServiceImplTest.assertTrue((boolean)g.getAttributes().stream().anyMatch(a -> "sourceservice".equalsIgnoreCase(a.getName())));
    }

    @Test
    public void testGetWithAttributesIsEager() throws Exception {
        long id = userGroupService.insert(UserGroupServiceImplTest.groupWithAttrs("G", UserGroupServiceImplTest.attr("k", "v")));
        UserGroup g = userGroupService.getWithAttributes(id);
        ArrayList copy = new ArrayList(g.getAttributes());
        UserGroupServiceImplTest.assertEquals((int)1, (int)copy.size());
    }

    @Test
    public void testUpdateSecurityRulesEveryoneInvalidCombo() throws Exception {
        this.ensureReservedExists();
        UserGroup everyone = userGroupService.get(GroupReservedNames.EVERYONE.groupName());
        UserGroupServiceImplTest.assertNotNull((String)"Reserved EVERYONE group must exist for this test", (Object)everyone);
        Assert.assertThrows(BadRequestServiceEx.class, () -> userGroupService.updateSecurityRules(everyone.getId(), List.of(Long.valueOf(1L)), false, true));
    }

    @Test
    public void testDeleteDetachesFromUsers() throws Exception {
        long gid = userGroupService.insert(UserGroupServiceImplTest.group("toRemove"));
        long uid = userService.insert(UserGroupServiceImplTest.user("x"));
        userGroupService.assignUserGroup(uid, gid);
        userGroupService.delete(gid);
        UserGroupServiceImplTest.assertTrue((boolean)userService.get(uid).getGroups().isEmpty());
    }

    private static UserGroup group(String name) {
        UserGroup g = new UserGroup();
        g.setGroupName(name);
        return g;
    }

    private static User user(String name) {
        User u = new User();
        u.setName(name);
        u.setPassword("p");
        u.setRole(Role.USER);
        u.setEnabled(true);
        u.setGroups(new HashSet());
        u.setAttribute(new ArrayList());
        return u;
    }

    private static UserGroupAttribute attr(String k, String v) {
        UserGroupAttribute a = new UserGroupAttribute();
        a.setName(k);
        a.setValue(v);
        return a;
    }

    private static UserGroup groupWithAttrs(String name, UserGroupAttribute ... atts) {
        UserGroup g = UserGroupServiceImplTest.group(name);
        g.setAttributes(Arrays.asList(atts));
        return g;
    }

    private static void assertNames(List<UserGroupAttribute> attrs, String ... names) {
        UserGroupServiceImplTest.assertEquals(Set.of(names), attrs.stream().map(UserGroupAttribute::getName).collect(Collectors.toSet()));
    }

    private void ensureReservedExists() throws BadRequestServiceEx {
        String reserved = GroupReservedNames.EVERYONE.groupName();
        if (userGroupService.get(reserved) == null) {
            userGroupService.insertSpecialUsersGroups();
        }
    }
}

