/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcePermissionServiceImplTest {
    private ResourcePermissionServiceImpl service;

    @Before
    public void setUp() {
        this.service = new ResourcePermissionServiceImpl();
    }

    @Test
    public void testCanReadByUsernameMatch() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setName("alice");
        user.setRole(Role.USER);
        SecurityRule rule = new SecurityRule();
        User ruleUser = new User();
        ruleUser.setId(Long.valueOf(999L));
        rule.setUser(ruleUser);
        rule.setUsername("alice");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via username match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }

    @Test
    public void testCanReadByGroupnameMatch() {
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(10L));
        group.setGroupName("editors");
        User user = new User();
        user.setId(Long.valueOf(200L));
        user.setName("bob");
        user.setRole(Role.USER);
        user.setGroups(Collections.singleton(group));
        SecurityRule rule = new SecurityRule();
        UserGroup ruleGroup = new UserGroup();
        ruleGroup.setId(Long.valueOf(888L));
        rule.setGroup(ruleGroup);
        rule.setGroupname("editors");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via groupname match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }

    @Test
    public void testUserCanAccessByIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("1.2.3.4");
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.0/24");
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserCannotAccessByIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("127.0.0.1");
        user.setGroups(Set.of());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.4/32");
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertFalse((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertFalse((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserInGroupCanAccessByIPAddress() {
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(888L));
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("1.2.3.4");
        user.setGroups(Set.of(group));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.0/24");
        SecurityRule rule = new SecurityRule();
        rule.setGroup(group);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserInGroupCannotAccessByIPAddress() {
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(888L));
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("1.2.3.4");
        user.setGroups(Set.of(group));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("121.52.23.220/15");
        SecurityRule rule = new SecurityRule();
        rule.setGroup(group);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertFalse((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertFalse((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserCanAccessIfIPRangeAppliesToAnotherRule() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("127.0.0.1");
        user.setGroups(Set.of());
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(888L));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.4/32");
        SecurityRule ruleWithIPRange = new SecurityRule();
        ruleWithIPRange.setGroup(group);
        ruleWithIPRange.setCanWrite(true);
        ruleWithIPRange.setIpRanges(Set.of(ipRange));
        SecurityRule ruleWithoutIPRange = new SecurityRule();
        ruleWithoutIPRange.setUser(user);
        ruleWithoutIPRange.setCanRead(true);
        ruleWithoutIPRange.setCanWrite(true);
        Resource resource = new Resource();
        resource.setSecurity(List.of(ruleWithIPRange, ruleWithoutIPRange));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithDefaultNetworkIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("15.222.30.111");
        IPRange ipRange = new IPRange();
        ipRange.setCidr("0.0.0.0/0");
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithCidrEqualsIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("192.168.1.0");
        IPRange ipRange = new IPRange();
        ipRange.setCidr("192.168.1.0/32");
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithMultipleCidrs() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress("122.15.55.34");
        IPRange ipRangeExclusive = new IPRange();
        ipRangeExclusive.setCidr("192.168.1.0/12");
        IPRange ipRangeInclusive = new IPRange();
        ipRangeInclusive.setCidr("122.15.0.0/16");
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRangeExclusive, ipRangeInclusive));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }
}

