/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;

public class UserGroupServiceImplTest
extends ServiceTestBase {
    @Test
    public void testGroupCRUDOperations() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        userGroupService.insert(ug1);
        UserGroup ug2 = new UserGroup();
        ug2.setGroupName("ug2");
        userGroupService.insert(ug2);
        UserGroup ug3 = new UserGroup();
        ug3.setGroupName("ug3");
        userGroupService.insert(ug3);
        UserGroup ug4 = new UserGroup();
        ug4.setGroupName("ug4");
        userGroupService.insert(ug4);
        List groups = userGroupService.getAll(null, null);
        UserGroupServiceImplTest.assertEquals((String)"Saved 4 groups but retrieved less or more groups...", (int)4, (int)groups.size());
        userGroupService.delete(ug4.getId().longValue());
        groups = userGroupService.getAll(null, null);
        UserGroupServiceImplTest.assertEquals((String)"Removed 1 group of 4 but retrieved less or more groups...", (int)3, (int)groups.size());
    }

    @Test
    public void testAssignGroupToUser() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        long gid = userGroupService.insert(ug1);
        User u = new User();
        u.setName("u1");
        u.setPassword("password");
        u.setRole(Role.USER);
        long uid = userService.insert(u);
        userGroupService.assignUserGroup(uid, gid);
        User uu = userService.get(uid);
        Set groups = uu.getGroups();
        UserGroupServiceImplTest.assertEquals((String)"GroupSize must be 1!", (int)1, (int)groups.size());
    }

    @Test
    public void testChangeGroupPermissionsOnResources() throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx {
        UserGroup ug1 = new UserGroup();
        ug1.setGroupName("ug1");
        long gid = userGroupService.insert(ug1);
        User u = new User();
        u.setName("u1");
        u.setPassword("password");
        u.setRole(Role.USER);
        HashSet<UserGroup> group = new HashSet<UserGroup>();
        group.add(ug1);
        u.setGroups(group);
        long uid = userService.insert(u);
        Resource r = new Resource();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Attribute a1 = new Attribute();
        a1.setTextValue("a1");
        a1.setType(DataType.STRING);
        a1.setName("a1");
        attributeList.add(a1);
        r.setAttribute(attributeList);
        Category cat = new Category();
        cat.setName("cat1");
        r.setCategory(cat);
        r.setCreation(new Date());
        r.setName("r1");
        categoryService.insert(cat);
        long id = resourceService.insert(r);
        r = resourceService.get(id);
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        List resourcelist = resourceDAO.findResources(idList);
        List listSecurity = ((Resource)resourcelist.get(0)).getSecurity();
        UserGroupServiceImplTest.assertEquals((int)0, (int)listSecurity.size());
        ArrayList<Long> listR = new ArrayList<Long>();
        listR.add(r.getId());
        List listsr = userGroupService.updateSecurityRules(ug1.getId(), listR, true, true);
        UserGroupServiceImplTest.assertEquals((int)1, (int)listsr.size());
        UserGroupServiceImplTest.assertTrue((String)"Expected TRUE", (boolean)((ShortResource)listsr.get(0)).isCanDelete());
        UserGroupServiceImplTest.assertTrue((String)"Expected TRUE", (boolean)((ShortResource)listsr.get(0)).isCanEdit());
        idList = new ArrayList();
        idList.add(id);
        resourcelist = resourceDAO.findResources(idList);
        listSecurity = ((Resource)resourcelist.get(0)).getSecurity();
        UserGroupServiceImplTest.assertEquals((int)1, (int)listSecurity.size());
        listsr = userGroupService.updateSecurityRules(ug1.getId(), listR, false, false);
        UserGroupServiceImplTest.assertEquals((int)1, (int)listsr.size());
        UserGroupServiceImplTest.assertTrue((String)"Expected FALSE", (!((ShortResource)listsr.get(0)).isCanDelete() ? 1 : 0) != 0);
        UserGroupServiceImplTest.assertTrue((String)"Expected FALSE", (!((ShortResource)listsr.get(0)).isCanEdit() ? 1 : 0) != 0);
    }

    @Test
    public void testInsertGroupWithAttributes() throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup ug = userGroupService.get(id);
        List attributes = ug.getAttributes();
        UserGroupServiceImplTest.assertEquals((int)2, (int)attributes.size());
        UserGroupServiceImplTest.assertEquals((String)"attr1", (String)((UserGroupAttribute)attributes.get(0)).getName());
        UserGroupServiceImplTest.assertEquals((String)"attr2", (String)((UserGroupAttribute)attributes.get(1)).getName());
    }

    @Test
    public void testUpdateGroup() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup toUpdate = userGroupService.get(id);
        toUpdate.setDescription("Updated Description");
        long idUpdated = userGroupService.update(toUpdate);
        UserGroup updated = userGroupService.get(idUpdated);
        UserGroupServiceImplTest.assertEquals((long)id, (long)idUpdated);
        UserGroupServiceImplTest.assertEquals((String)"Updated Description", (String)updated.getDescription());
    }

    @Test
    public void testUpdateUserGroupAttributes() throws BadRequestServiceEx, NotFoundServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("attr1");
        attribute.setValue("value,value2,value3");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroupAttribute attributeToUpdate1 = new UserGroupAttribute();
        attributeToUpdate1.setName(attribute.getName());
        attributeToUpdate1.setValue(attribute.getValue());
        UserGroupAttribute attributeToUpdate2 = new UserGroupAttribute();
        attributeToUpdate2.setName("updated");
        attributeToUpdate2.setValue("updatedValue");
        List<UserGroupAttribute> attributes = Arrays.asList(attributeToUpdate1, attributeToUpdate2);
        userGroupService.updateAttributes(id, attributes);
        UserGroup groupUpdated = userGroupService.get(id);
        List updatedList = groupUpdated.getAttributes();
        UserGroupServiceImplTest.assertTrue((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attribute.getName())));
        UserGroupServiceImplTest.assertTrue((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attributeToUpdate2.getName())));
        UserGroupServiceImplTest.assertFalse((boolean)updatedList.stream().anyMatch(g -> g.getName().equals(attribute2.getName())));
    }

    @Test
    public void testgetByAttributes() throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName("GroupWithAttrs");
        UserGroupAttribute attribute = new UserGroupAttribute();
        attribute.setName("organization");
        attribute.setValue("value");
        UserGroupAttribute attribute2 = new UserGroupAttribute();
        attribute2.setName("attr2");
        attribute2.setValue("value4,value5,value6");
        group.setAttributes(Arrays.asList(attribute, attribute2));
        long id = userGroupService.insert(group);
        UserGroup group2 = new UserGroup();
        group2.setGroupName("GroupWithAttrs2");
        UserGroupAttribute attribute21 = new UserGroupAttribute();
        attribute21.setName("Organization");
        attribute21.setValue("value");
        UserGroupAttribute attribute22 = new UserGroupAttribute();
        attribute22.setName("attr2");
        attribute22.setValue("value4,value5,value6");
        group2.setAttributes(Arrays.asList(attribute21, attribute22));
        userGroupService.insert(group2);
        UserGroupAttribute groupAttribute = new UserGroupAttribute();
        groupAttribute.setName("organization");
        groupAttribute.setValue("value");
        Collection groups = userGroupService.findByAttribute("organization", Arrays.asList("value"), true);
        UserGroupServiceImplTest.assertEquals((int)2, (int)groups.size());
        groups = userGroupService.findByAttribute("organization", Arrays.asList("value"), false);
        UserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
    }
}

