/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SearchConverterTest
extends ServiceTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testFilterConverter() throws Exception {
        Category category = new Category();
        category.setName("MAP");
        categoryService.insert(category);
        for (int i = 0; i < 10; ++i) {
            Resource resource = new Resource();
            resource.setName("resource" + i);
            resource.setDescription("resource description" + i);
            resource.setCategory(category);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Attribute attr1 = new Attribute();
            attr1.setName("attr1");
            attr1.setTextValue("value" + i);
            attr1.setType(DataType.STRING);
            attributes.add(attr1);
            Attribute attr2 = new Attribute();
            attr2.setName("attr2");
            attr2.setNumberValue(Double.valueOf(i));
            attr2.setType(DataType.NUMBER);
            attributes.add(attr2);
            Attribute attr3 = new Attribute();
            attr3.setName("attr3");
            attr3.setDateValue(new Date());
            attr3.setType(DataType.DATE);
            attributes.add(attr3);
            resource.setAttribute(attributes);
            long resourceId = resourceService.insert(resource);
            List sAttributes = resourceService.getAttributes(resourceId);
            SearchConverterTest.assertNotNull((Object)sAttributes);
            SearchConverterTest.assertEquals((int)3, (int)sAttributes.size());
            SearchConverterTest.assertNotNull((Object)resourceService.get(resourceId));
            SearchConverterTest.assertEquals((int)3, (int)resourceService.getAttributes(resourceId).size());
        }
        StringReader reader = SearchConverterTest.getFilterConverterFilterAND();
        AndFilter searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchConverterTest.assertNotNull((Object)searchFilter);
        List resources = resourceService.getShortResources(ResourceSearchParameters.builder().filter((SearchFilter)searchFilter).authUser(this.buildFakeAdminUser()).build());
        SearchConverterTest.assertEquals((int)1, (int)resources.size());
        reader = SearchConverterTest.getFilterConverterFilterANDOR();
        searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchConverterTest.assertNotNull((Object)searchFilter);
        resources = resourceService.getShortResources(ResourceSearchParameters.builder().filter((SearchFilter)searchFilter).authUser(this.buildFakeAdminUser()).build());
        SearchConverterTest.assertEquals((int)2, (int)resources.size());
    }

    private static StringReader getFilterConverterFilterAND() {
        String xmlFilter = "<AND><FIELD><field>NAME</field><operator>LIKE</operator><value>%resource%</value></FIELD><AND><ATTRIBUTE><name>attr1</name><operator>EQUAL_TO</operator><type>STRING</type><value>value2</value></ATTRIBUTE><ATTRIBUTE><name>attr2</name><operator>GREATER_THAN</operator><type>NUMBER</type><value>1.0</value></ATTRIBUTE></AND></AND>";
        return new StringReader(xmlFilter);
    }

    private static StringReader getFilterConverterFilterANDOR() {
        String xmlFilter = "<AND><FIELD><field>NAME</field><operator>LIKE</operator><value>%resource%</value></FIELD><AND><ATTRIBUTE><name>attr2</name><operator>GREATER_THAN</operator><type>NUMBER</type><value>1.0</value></ATTRIBUTE><OR><ATTRIBUTE><name>attr1</name><operator>EQUAL_TO</operator><type>STRING</type><value>value2</value></ATTRIBUTE><ATTRIBUTE><name>attr1</name><operator>EQUAL_TO</operator><type>STRING</type><value>value3</value></ATTRIBUTE></OR></AND></AND>";
        return new StringReader(xmlFilter);
    }

    @Test
    public void testSearch() throws Exception {
        Category category = new Category();
        category.setName("MAP");
        categoryService.insert(category);
        for (int i = 0; i < 10; ++i) {
            Resource resource = new Resource();
            resource.setName("resource" + i);
            resource.setDescription("resource description" + i);
            resource.setCategory(category);
            resource.setMetadata("resource" + i);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Attribute attr1 = new Attribute();
            attr1.setName("attr1");
            attr1.setTextValue("value" + i);
            attr1.setType(DataType.STRING);
            attributes.add(attr1);
            Attribute attr2 = new Attribute();
            attr2.setName("attr2");
            attr2.setNumberValue(Double.valueOf(i));
            attr2.setType(DataType.NUMBER);
            attributes.add(attr2);
            Attribute attr3 = new Attribute();
            attr3.setName("attr3");
            attr3.setDateValue(new Date());
            attr3.setType(DataType.DATE);
            attributes.add(attr3);
            resource.setAttribute(attributes);
            long resourceId = resourceService.insert(resource);
            List sAttributes = resourceService.getAttributes(resourceId);
            SearchConverterTest.assertNotNull((Object)sAttributes);
            SearchConverterTest.assertEquals((int)3, (int)sAttributes.size());
            SearchConverterTest.assertNotNull((Object)resourceService.get(resourceId));
            SearchConverterTest.assertEquals((int)3, (int)resourceService.getAttributes(resourceId).size());
            long id = this.createData("data" + i, resourceService.get(resourceId));
            SearchConverterTest.assertNotNull((Object)storedDataService.get(id));
        }
        String xmlFilter = "<AND><FIELD><field>METADATA</field><operator>LIKE</operator><value>%resource%</value></FIELD><ATTRIBUTE><name>attr1</name><operator>LIKE</operator><type>STRING</type><value>%value%</value></ATTRIBUTE></AND>";
        StringReader reader = new StringReader(xmlFilter);
        AndFilter searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchConverterTest.assertNotNull((Object)searchFilter);
        List resources = resourceService.getResources(ResourceSearchParameters.builder().filter((SearchFilter)searchFilter).page(Integer.valueOf(0)).entries(Integer.valueOf(5)).includeAttributes(true).includeData(false).authUser(this.buildFakeAdminUser()).build());
        SearchConverterTest.assertEquals((int)5, (int)resources.size());
        Resource res = (Resource)resources.get(0);
        SearchConverterTest.assertNotNull((Object)res.getAttribute());
        SearchConverterTest.assertEquals((int)3, (int)res.getAttribute().size());
        SearchConverterTest.assertNull((Object)res.getData());
        xmlFilter = "<AND><FIELD><field>METADATA</field><operator>LIKE</operator><value>%resource%</value></FIELD><ATTRIBUTE><name>attr1</name><operator>LIKE</operator><type>STRING</type><value>%value%</value></ATTRIBUTE></AND>";
        reader = new StringReader(xmlFilter);
        searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchConverterTest.assertNotNull((Object)searchFilter);
        resources = resourceService.getResources(ResourceSearchParameters.builder().filter((SearchFilter)searchFilter).page(Integer.valueOf(0)).entries(Integer.valueOf(5)).includeAttributes(false).includeData(true).authUser(this.buildFakeAdminUser()).build());
        SearchConverterTest.assertEquals((int)5, (int)resources.size());
        res = (Resource)resources.get(0);
        SearchConverterTest.assertNotNull((Object)res.getData());
        SearchConverterTest.assertNull((Object)res.getAttribute());
        xmlFilter = "<AND><FIELD><field>METADATA</field><operator>LIKE</operator><value>%resource%</value></FIELD><ATTRIBUTE><name>attr1</name><operator>LIKE</operator><type>STRING</type><value>%value%</value></ATTRIBUTE></AND>";
        reader = new StringReader(xmlFilter);
        searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchConverterTest.assertNotNull((Object)searchFilter);
        resources = resourceService.getResources(ResourceSearchParameters.builder().filter((SearchFilter)searchFilter).page(Integer.valueOf(0)).entries(Integer.valueOf(5)).includeAttributes(true).includeData(true).authUser(this.buildFakeAdminUser()).build());
        SearchConverterTest.assertEquals((int)5, (int)resources.size());
        res = (Resource)resources.get(0);
        SearchConverterTest.assertNotNull((Object)res.getData());
        SearchConverterTest.assertNotNull((Object)res.getAttribute());
        SearchConverterTest.assertEquals((int)3, (int)res.getAttribute().size());
    }
}

