/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionServiceImpl;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcePermissionServiceImplTest {
    private ResourcePermissionServiceImpl service;

    @Before
    public void setUp() {
        this.service = new ResourcePermissionServiceImpl();
    }

    @Test
    public void testCanReadByUsernameMatch() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setName("alice");
        user.setRole(Role.USER);
        SecurityRule rule = new SecurityRule();
        User ruleUser = new User();
        ruleUser.setId(Long.valueOf(999L));
        rule.setUser(ruleUser);
        rule.setUsername("alice");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via username match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }

    @Test
    public void testCanReadByGroupnameMatch() {
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(10L));
        group.setGroupName("editors");
        User user = new User();
        user.setId(Long.valueOf(200L));
        user.setName("bob");
        user.setRole(Role.USER);
        user.setGroups(Collections.singleton(group));
        SecurityRule rule = new SecurityRule();
        UserGroup ruleGroup = new UserGroup();
        ruleGroup.setId(Long.valueOf(888L));
        rule.setGroup(ruleGroup);
        rule.setGroupname("editors");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via groupname match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }
}

