/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedTagNameServiceException;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;

public class TagServiceImplTest
extends ServiceTestBase {
    public void testInsert() throws Exception {
        Tag tagA = new Tag("tag-A", "#4561aa", "dusky");
        Tag tagB = new Tag("tag-B", "black", null);
        tagService.insert(tagA);
        tagService.insert(tagB);
        List foundTags = tagDAO.findAll();
        TagServiceImplTest.assertEquals((int)2, (int)foundTags.size());
        List foundTagsIds = foundTags.stream().map(Tag::getId).collect(Collectors.toList());
        TagServiceImplTest.assertTrue((boolean)foundTagsIds.stream().noneMatch(Objects::isNull));
    }

    public void testInsertDuplicate() throws Exception {
        Tag tag = new Tag("tag-A", "#4561aa", "dusky");
        Tag duplicateTag = new Tag(tag.getName(), "black", null);
        tagService.insert(tag);
        DuplicatedTagNameServiceException ex = (DuplicatedTagNameServiceException)Assert.assertThrows(DuplicatedTagNameServiceException.class, () -> tagService.insert(duplicateTag));
        TagServiceImplTest.assertTrue((boolean)ex.getMessage().contains("create"));
    }

    public void testInsertNull() throws Exception {
        Assert.assertThrows(BadRequestServiceEx.class, () -> tagService.insert(null));
    }

    public void testGetAll() throws Exception {
        Tag tag_a = new Tag("tag-A", "#4561aa", "dusky");
        Tag tag_b = new Tag("tag-B", "black", null);
        tagDAO.persist((Object[])new Tag[]{tag_a, tag_b});
        List foundTags = tagService.getAll(Integer.valueOf(0), Integer.valueOf(100), null);
        TagServiceImplTest.assertEquals(List.of(tag_a, tag_b), (Object)foundTags);
    }

    public void testGetAllPaginated() throws Exception {
        Tag tag_a = new Tag("tag-A", "#4561aa", "dusky");
        Tag tag_b = new Tag("tag-B", "black", null);
        Tag tag_c = new Tag("tag-C", "navy", "kind of blue");
        tagDAO.persist((Object[])new Tag[]{tag_a, tag_b, tag_c});
        List firstPageTags = tagService.getAll(Integer.valueOf(0), Integer.valueOf(2), null);
        TagServiceImplTest.assertEquals(List.of(tag_a, tag_b), (Object)firstPageTags);
        List secondPageTags = tagService.getAll(Integer.valueOf(1), Integer.valueOf(2), null);
        TagServiceImplTest.assertEquals(List.of(tag_c), (Object)secondPageTags);
    }

    public void testGetAllFiltered() throws Exception {
        Tag tag_a = new Tag("tag-A", "#4561aa", "dusky");
        Tag tag_b = new Tag("tag-B", "black", null);
        Tag tag_c = new Tag("C", "navy", "kind of blue");
        tagDAO.persist((Object[])new Tag[]{tag_a, tag_b, tag_c});
        List foundTags = tagService.getAll(Integer.valueOf(0), Integer.valueOf(100), "tag%");
        TagServiceImplTest.assertEquals(List.of(tag_a, tag_b), (Object)foundTags);
    }

    public void testGet() throws Exception {
        Tag tag_a = new Tag("tag-A", "#4561aa", "dusky");
        Tag tag_b = new Tag("tag-B", "black", null);
        tagDAO.persist((Object[])new Tag[]{tag_a, tag_b});
        Tag foundTag = tagService.get(tag_a.getId().longValue());
        TagServiceImplTest.assertEquals((Object)tag_a, (Object)foundTag);
    }

    public void testUpdate() throws Exception {
        Tag expected_tag = new Tag("updated name", "black", null);
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        tagDAO.persist((Object[])new Tag[]{tag});
        tagService.update(tag.getId().longValue(), expected_tag);
        Tag updatedTag = (Tag)tagDAO.find(tag.getId());
        TagServiceImplTest.assertEquals((Object)expected_tag, (Object)updatedTag);
    }

    public void testUpdateWithDuplicate() throws Exception {
        Tag tagA = new Tag("tag-A", "#4561aa", "dusky");
        Tag tagB = new Tag("tag-B", "black", null);
        tagDAO.persist((Object[])new Tag[]{tagA, tagB});
        tagB.setName(tagA.getName());
        DuplicatedTagNameServiceException ex = (DuplicatedTagNameServiceException)Assert.assertThrows(DuplicatedTagNameServiceException.class, () -> tagService.update(tagB.getId().longValue(), tagB));
        TagServiceImplTest.assertTrue((boolean)ex.getMessage().contains("update"));
    }

    public void testUpdateWithResource() throws Exception {
        Tag update_tag = new Tag("updated name", "black", null);
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        long resourceId = this.createResource("resource", "description", "category");
        Resource resource = resourceService.get(resourceId);
        tag.setResources(Collections.singleton(resource));
        tagDAO.persist((Object[])new Tag[]{tag});
        tagService.update(tag.getId().longValue(), update_tag);
        Tag updatedTag = (Tag)tagDAO.find(tag.getId());
        Resource updatedTagResource = resourceService.get(resourceId);
        Set updatedTagResourceTags = updatedTagResource.getTags();
        TagServiceImplTest.assertEquals((int)1, (int)updatedTagResourceTags.size());
        Tag resourceTag = (Tag)updatedTagResourceTags.stream().findFirst().orElseThrow();
        TagServiceImplTest.assertEquals((Object)updatedTag, (Object)resourceTag);
    }

    public void testUpdateNotFoundTag() throws Exception {
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.update(0L, new Tag()));
    }

    public void testDelete() throws Exception {
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        tagDAO.persist((Object[])new Tag[]{tag});
        tagService.delete(tag.getId().longValue());
        Tag foundTag = (Tag)tagDAO.find(tag.getId());
        TagServiceImplTest.assertNull((Object)foundTag);
    }

    public void testDeleteNotFoundTag() throws Exception {
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.delete(0L));
    }

    public void testAddToResource() throws Exception {
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        long resourceId = this.createResource("resource", "description", "category");
        tagDAO.persist((Object[])new Tag[]{tag});
        tagService.addToResource(tag.getId().longValue(), resourceId);
        Resource resource = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        Set resourceTags = resource.getTags();
        TagServiceImplTest.assertEquals((int)1, (int)resourceTags.size());
        Tag resourceTag = (Tag)resourceTags.stream().findFirst().orElseThrow();
        TagServiceImplTest.assertEquals((Object)tag, (Object)resourceTag);
    }

    public void testAddToResourceNotFoundTag() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.addToResource(0L, resourceId));
    }

    public void testAddToResourceNotFoundResource() throws Exception {
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        tagDAO.persist((Object[])new Tag[]{tag});
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.addToResource(tag.getId().longValue(), 0L));
    }

    public void testRemoveFromResource() throws Exception {
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        long resourceId = this.createResource("resource", "description", "category");
        tagDAO.persist((Object[])new Tag[]{tag});
        Resource resource = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        resource.setTags(Collections.singleton(tag));
        resourceService.update(resource);
        tagService.removeFromResource(tag.getId().longValue(), resourceId);
        resource = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        Set resourceTags = resource.getTags();
        TagServiceImplTest.assertTrue((boolean)resourceTags.isEmpty());
    }

    public void testRemoveFromResourceNotFoundTag() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.removeFromResource(0L, resourceId));
    }

    public void testRemoveFromResourceNotFoundResource() throws Exception {
        Tag tag = new Tag("tag", "#4561aa", "dusky");
        tagDAO.persist((Object[])new Tag[]{tag});
        Assert.assertThrows(NotFoundServiceEx.class, () -> tagService.removeFromResource(tag.getId().longValue(), 0L));
    }
}

