/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.util;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.AssociatedEntityFilter;
import it.geosolutions.geostore.services.dto.search.AttributeFilter;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.FilterVisitor;
import it.geosolutions.geostore.services.dto.search.NotFilter;
import it.geosolutions.geostore.services.dto.search.OrFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchConverter
implements FilterVisitor {
    private static final Map<SearchOperator, Integer> ops_rest_trg;
    private static final Logger LOGGER;
    private static final DateTimeFormatter DATE_FORMATTER;
    private Filter trgFilter;

    public static Search convert(SearchFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        Search trgSearch = new Search(Resource.class);
        if (filter != null) {
            SearchConverter sc = new SearchConverter();
            filter.accept((FilterVisitor)sc);
            trgSearch.addFilter(sc.trgFilter);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("TRG Search  --> " + trgSearch);
        }
        return trgSearch;
    }

    private SearchConverter() {
    }

    public void visit(AndFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        this.trgFilter = Filter.and((Filter[])new Filter[0]);
        for (SearchFilter searchFilter : filter.getFilters()) {
            SearchConverter sc = new SearchConverter();
            searchFilter.accept((FilterVisitor)sc);
            this.trgFilter.add(sc.trgFilter);
        }
    }

    public void visit(AttributeFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        String fieldValueName;
        Object value;
        Integer trg_op;
        if (filter.getType() != null && filter.getName() != null && filter.getOperator() != null && filter.getValue() != null) {
            trg_op = ops_rest_trg.get(filter.getOperator());
            if (trg_op == null) {
                throw new IllegalStateException("Unknown op " + filter.getOperator());
            }
            value = null;
            switch (filter.getType()) {
                case DATE: {
                    fieldValueName = "dateValue";
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    try {
                        value = sdf.parse(filter.getValue());
                        break;
                    }
                    catch (ParseException e) {
                        throw new InternalErrorServiceEx("Error parsing attribute date value");
                    }
                }
                case NUMBER: {
                    fieldValueName = "numberValue";
                    try {
                        value = Double.valueOf(filter.getValue());
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new InternalErrorServiceEx("Error parsing attribute number value");
                    }
                }
                case STRING: {
                    fieldValueName = "textValue";
                    value = filter.getValue();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + filter.getType());
                }
            }
        } else {
            throw new BadRequestServiceEx("Bad payload. One or more field are missing");
        }
        this.trgFilter = Filter.some((String)"attribute", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"name", (Object)filter.getName()), new Filter(fieldValueName, value, trg_op.intValue())}));
    }

    public void visit(FieldFilter filter) throws InternalErrorServiceEx {
        String property = filter.getField().getFieldName();
        String value = filter.getValue();
        Class type = filter.getField().getType();
        Filter f = new Filter();
        Integer op = ops_rest_trg.get(filter.getOperator());
        if (op == null) {
            throw new IllegalStateException("Unknown op " + filter.getOperator());
        }
        f.setProperty(property);
        f.setOperator(op.intValue());
        if (type == Date.class) {
            try {
                value = value.replace("T", " ");
                f.setValue((Object)Date.from(LocalDateTime.parse(value, DATE_FORMATTER).atZone(ZoneOffset.systemDefault()).toInstant()));
            }
            catch (DateTimeParseException e) {
                throw new InternalErrorServiceEx("Error parsing attribute date value");
            }
        } else if (type == Long.class) {
            try {
                f.setValue((Object)Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new InternalErrorServiceEx("Error parsing attribute long value");
            }
        } else {
            f.setValue((Object)value);
        }
        this.trgFilter = f;
    }

    public void visit(CategoryFilter filter) {
        CategoryFilter.checkOperator((SearchOperator)filter.getOperator());
        Integer op = ops_rest_trg.get(filter.getOperator());
        if (op == null) {
            throw new IllegalStateException("Unknown op " + filter.getOperator());
        }
        Filter f = new Filter();
        f.setOperator(op.intValue());
        f.setProperty("category.name");
        f.setValue((Object)filter.getName());
        this.trgFilter = f;
    }

    public void visit(AssociatedEntityFilter filter) {
        SearchOperator searchOperator = filter.getOperator();
        List values = filter.values();
        Integer operator = ops_rest_trg.get(searchOperator);
        if (operator == null) {
            throw new IllegalStateException("Unknown op " + searchOperator);
        }
        Filter f = new Filter();
        f.setOperator(operator.intValue());
        f.setProperty(filter.property());
        if (SearchOperator.IN == searchOperator) {
            f.setValue((Object)values);
        } else {
            f.setValue(values.get(0));
        }
        this.trgFilter = f;
    }

    public void visit(NotFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        SearchFilter notFilter = filter.getFilter();
        SearchConverter sc = new SearchConverter();
        notFilter.accept((FilterVisitor)sc);
        this.trgFilter = Filter.not((Filter)sc.trgFilter);
    }

    public void visit(OrFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        this.trgFilter = Filter.or((Filter[])new Filter[0]);
        for (SearchFilter searchFilter : filter.getFilters()) {
            SearchConverter sc = new SearchConverter();
            searchFilter.accept((FilterVisitor)sc);
            this.trgFilter.add(sc.trgFilter);
        }
    }

    static {
        LOGGER = LogManager.getLogger(SearchConverter.class);
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
        EnumMap<SearchOperator, Integer> ops = new EnumMap<SearchOperator, Integer>(SearchOperator.class);
        ops.put(SearchOperator.EQUAL_TO, 0);
        ops.put(SearchOperator.GREATER_THAN_OR_EQUAL_TO, 5);
        ops.put(SearchOperator.GREATER_THAN, 3);
        ops.put(SearchOperator.IS_NOT_NULL, 11);
        ops.put(SearchOperator.IS_NULL, 10);
        ops.put(SearchOperator.LESS_THAN, 2);
        ops.put(SearchOperator.LESS_THAN_OR_EQUAL_TO, 4);
        ops.put(SearchOperator.LIKE, 6);
        ops.put(SearchOperator.ILIKE, 7);
        ops.put(SearchOperator.IN, 8);
        ops_rest_trg = Collections.unmodifiableMap(ops);
    }
}

