/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.dao.StoredDataDAO;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.services.StoredDataService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoredDataServiceImpl
implements StoredDataService {
    private static final Logger LOGGER = LogManager.getLogger(StoredDataServiceImpl.class);
    private StoredDataDAO storedDataDAO;
    private ResourceDAO resourceDAO;
    private SecurityDAO securityDAO;

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public void setStoredDataDAO(StoredDataDAO storedDataDAO) {
        this.storedDataDAO = storedDataDAO;
    }

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public long update(long id, String data) throws NotFoundServiceEx {
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(id));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found: " + id);
        }
        StoredData sData = (StoredData)this.storedDataDAO.find(Long.valueOf(id));
        if (sData == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Data not found: " + id);
            }
            sData = new StoredData();
            sData.setId(id);
            sData.setData(data);
            sData.setResource(resource);
            this.storedDataDAO.persist((Object[])new StoredData[]{sData});
        } else {
            sData.setData(data);
            this.storedDataDAO.merge((Object)sData);
        }
        resource.setLastUpdate(new Date());
        this.resourceDAO.merge((Object)resource);
        return id;
    }

    public StoredData get(long id) throws NotFoundServiceEx {
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(id));
        if (resource == null) {
            throw new NotFoundServiceEx("Corresponding Resource not found: " + id);
        }
        StoredData data = (StoredData)this.storedDataDAO.find(Long.valueOf(id));
        return data;
    }

    public boolean delete(long id) {
        return this.storedDataDAO.removeById(Long.valueOf(id));
    }

    public List<StoredData> getAll() {
        List found = this.storedDataDAO.findAll();
        return found;
    }

    public List<StoredData> getAllFull() {
        List found = this.storedDataDAO.findAll();
        for (StoredData data : found) {
            Resource resource = data.getResource();
            if (resource == null) continue;
            List security = this.securityDAO.findResourceSecurityRules(resource.getId().longValue());
            resource.setSecurity(security);
            List attribute = this.resourceDAO.findAttributes(resource.getId().longValue());
            resource.setAttribute(attribute);
        }
        return found;
    }

    public List<SecurityRule> getUserSecurityRule(String name, long storedDataId) {
        return this.securityDAO.findUserSecurityRule(name, storedDataId);
    }

    public List<SecurityRule> getGroupSecurityRule(List<String> groupNames, long storedDataId) {
        return this.securityDAO.findGroupSecurityRule(groupNames, storedDataId);
    }
}

