/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionService;
import java.util.List;
import java.util.function.BiFunction;

public class ResourcePermissionServiceImpl
implements ResourcePermissionService {
    private final BiFunction<SecurityRule, User, Boolean> resourceUserOwnership = (rule, user) -> user.getId().equals(rule.getUser().getId());
    private final BiFunction<SecurityRule, UserGroup, Boolean> resourceGroupOwnership = (rule, group) -> group.getId().equals(rule.getGroup().getId());
    private final BiFunction<SecurityRule, User, Boolean> resourceUserOwnershipWithReadPermission = (rule, user) -> rule.getUser() != null && this.resourceUserOwnership.apply((SecurityRule)rule, (User)user) != false && rule.isCanRead();
    private final BiFunction<SecurityRule, UserGroup, Boolean> resourceGroupOwnershipWithReadPermission = (rule, group) -> rule.getGroup() != null && this.resourceGroupOwnership.apply((SecurityRule)rule, (UserGroup)group) != false && rule.isCanRead();
    private final BiFunction<SecurityRule, User, Boolean> resourceUserOwnershipWithWritePermission = (rule, user) -> rule.getUser() != null && this.resourceUserOwnership.apply((SecurityRule)rule, (User)user) != false && rule.isCanWrite();
    private final BiFunction<SecurityRule, UserGroup, Boolean> resourceGroupOwnershipWithWritePermission = (rule, group) -> rule.getGroup() != null && this.resourceGroupOwnership.apply((SecurityRule)rule, (UserGroup)group) != false && rule.isCanWrite();

    public boolean canResourceBeReadByUser(Resource resource, User user) {
        return user.getRole().equals((Object)Role.ADMIN) || this.isUserOwnerWithReadPermission(user, resource) || this.haveUserGroupsOwnershipWithReadPermission(user, resource);
    }

    private boolean isUserOwnerWithReadPermission(User user, Resource resource) {
        this.checkResourceSecurityRules(resource);
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserOwnershipWithReadPermission);
    }

    private boolean haveUserGroupsOwnershipWithReadPermission(User user, Resource resource) {
        return this.checkResourceSecurityRulesAgainstUserGroup(user, resource, this.resourceGroupOwnershipWithReadPermission);
    }

    public boolean canResourceBeWrittenByUser(Resource resource, User user) {
        return !user.getRole().equals((Object)Role.GUEST) && (user.getRole().equals((Object)Role.ADMIN) || this.isUserOwnerWithWritePermission(user, resource) || this.haveUserGroupsOwnershipWithWritePermission(user, resource));
    }

    private boolean isUserOwnerWithWritePermission(User user, Resource resource) {
        this.checkResourceSecurityRules(resource);
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserOwnershipWithWritePermission);
    }

    private void checkResourceSecurityRules(Resource resource) {
        if (resource.getSecurity() == null) {
            throw new IllegalArgumentException("set resource security rules prior checking for permissions");
        }
    }

    private boolean haveUserGroupsOwnershipWithWritePermission(User user, Resource resource) {
        return this.checkResourceSecurityRulesAgainstUserGroup(user, resource, this.resourceGroupOwnershipWithWritePermission);
    }

    private boolean checkResourceSecurityRulesAgainstUserGroup(User user, Resource resource, BiFunction<SecurityRule, UserGroup, Boolean> check) {
        return user.getGroups().stream().anyMatch(group -> this.checkSecurityRulesAgainstUserGroup(resource.getSecurity(), (UserGroup)group, check));
    }

    private boolean checkSecurityRulesAgainstUser(List<SecurityRule> rules, User user, BiFunction<SecurityRule, User, Boolean> check) {
        return rules.stream().anyMatch(rule -> (Boolean)check.apply((SecurityRule)rule, user));
    }

    private boolean checkSecurityRulesAgainstUserGroup(List<SecurityRule> rules, UserGroup group, BiFunction<SecurityRule, UserGroup, Boolean> check) {
        return rules.stream().anyMatch(rule -> (Boolean)check.apply((SecurityRule)rule, group));
    }
}

