/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.InMemoryUserSessionServiceImpl;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.dto.UserSession;
import it.geosolutions.geostore.services.dto.UserSessionImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class InMemoryUserSessionServiceImplTest
extends ServiceTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testInitialization() {
        InMemoryUserSessionServiceImpl service = new InMemoryUserSessionServiceImpl();
        service.setCleanUpSeconds(500);
        InMemoryUserSessionServiceImplTest.assertTrue((boolean)true);
    }

    @Test
    public void testSessionStorage() throws Exception {
        InMemoryUserSessionServiceImpl service = new InMemoryUserSessionServiceImpl();
        User u = new User();
        u.setId(Long.valueOf(1L));
        u.setName("TEST");
        UserSessionImpl session = new UserSessionImpl(u, (Calendar)new GregorianCalendar(3000, 1, 1));
        session = service.registerNewSession((UserSession)session);
        User sessUser = service.getUserData(session.getId());
        InMemoryUserSessionServiceImplTest.assertEquals((Object)sessUser, (Object)u);
        InMemoryUserSessionServiceImplTest.assertTrue((boolean)service.isOwner(session.getId(), (Object)u));
        UserSessionImpl session2 = new UserSessionImpl(u, (Calendar)new GregorianCalendar(3000, 1, 1));
        service.registerNewSession("ID_SESSION", (UserSession)session2);
        InMemoryUserSessionServiceImplTest.assertTrue((boolean)service.isOwner("ID_SESSION", (Object)u));
        service.refreshSession(session.getId(), service.getRefreshToken(session.getId()));
        service.removeSession("ID_SESSION");
        InMemoryUserSessionServiceImplTest.assertFalse((boolean)service.isOwner("ID_SESSION", (Object)u));
        service.removeAllSessions();
        InMemoryUserSessionServiceImplTest.assertFalse((boolean)service.isOwner(session.getId(), (Object)u));
    }

    @Test
    public void testSessionMissing() throws Exception {
        InMemoryUserSessionServiceImpl service = new InMemoryUserSessionServiceImpl();
        User u = new User();
        u.setId(Long.valueOf(1L));
        u.setName("TEST");
        UserSessionImpl session = new UserSessionImpl(u, (Calendar)new GregorianCalendar(3000, 1, 1));
        session = service.registerNewSession((UserSession)session);
        User sessUser = service.getUserData(session.getId());
        InMemoryUserSessionServiceImplTest.assertEquals((Object)sessUser, (Object)u);
        InMemoryUserSessionServiceImplTest.assertTrue((boolean)service.isOwner(session.getId(), (Object)u));
        InMemoryUserSessionServiceImplTest.assertNull((Object)service.getRefreshToken("NOT_A SESSION"));
        InMemoryUserSessionServiceImplTest.assertNull((Object)service.getUserData("NOT_A SESSION"));
    }
}

