/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.googlecode.genericdao.search.Sort;
import it.geosolutions.geostore.core.dao.AttributeDAO;
import it.geosolutions.geostore.core.dao.CategoryDAO;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.dao.StoredDataDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.ResourcePermissionService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.util.SearchConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;

public class ResourceServiceImpl
implements ResourceService {
    private static final Logger LOGGER = LogManager.getLogger(ResourceServiceImpl.class);
    private UserDAO userDAO;
    private UserGroupDAO userGroupDAO;
    private ResourceDAO resourceDAO;
    private AttributeDAO attributeDAO;
    private StoredDataDAO storedDataDAO;
    private CategoryDAO categoryDAO;
    private SecurityDAO securityDAO;
    private ResourcePermissionService resourcePermissionService;

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public void setAttributeDAO(AttributeDAO attributeDAO) {
        this.attributeDAO = attributeDAO;
    }

    public void setStoredDataDAO(StoredDataDAO storedDataDAO) {
        this.storedDataDAO = storedDataDAO;
    }

    public void setCategoryDAO(CategoryDAO categoryDAO) {
        this.categoryDAO = categoryDAO;
    }

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public void setResourcePermissionService(ResourcePermissionService resourcePermissionService) {
        this.resourcePermissionService = resourcePermissionService;
    }

    public long insert(Resource resource) throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Resource ... ");
        }
        this.validateResourceName(resource, false);
        Category category = resource.getCategory();
        if (category == null) {
            throw new BadRequestServiceEx("Category type must be specified");
        }
        Category loadedCategory = null;
        if (category.getId() != null) {
            loadedCategory = (Category)this.categoryDAO.find(category.getId());
            if (loadedCategory == null) {
                throw new NotFoundServiceEx("Resource Category not found [id:" + category.getId() + "]");
            }
        } else if (category.getName() != null) {
            Search searchCriteria = new Search(Category.class);
            searchCriteria.addFilterEqual("name", (Object)category.getName());
            List categories = this.categoryDAO.search((ISearch)searchCriteria);
            if (categories.isEmpty()) {
                throw new NotFoundServiceEx("Resource Category not found [name:" + category.getName() + "]");
            }
            loadedCategory = (Category)categories.get(0);
        }
        Resource r = new Resource();
        r.setCreation(new Date());
        r.setDescription(resource.getDescription());
        r.setMetadata(resource.getMetadata());
        r.setName(resource.getName());
        r.setCategory(loadedCategory);
        r.setAdvertised(resource.isAdvertised());
        List rules = resource.getSecurity();
        if (rules != null) {
            for (Object securityRule : rules) {
                if (securityRule.getUser() == null && securityRule.getUsername() == null || !securityRule.isCanWrite()) continue;
                String owner = securityRule.getUser() != null ? securityRule.getUser().getName() : securityRule.getUsername();
                r.setCreator(owner);
                if (resource.getEditor() != null) {
                    r.setEditor(owner);
                    continue;
                }
                r.setEditor(resource.getEditor());
            }
        } else {
            r.setCreator(resource.getCreator());
            r.setEditor(resource.getEditor());
        }
        try {
            this.resourceDAO.persist((Object[])new Resource[]{r});
        }
        catch (DataIntegrityViolationException exc) {
            throw new BadRequestServiceEx(exc.getLocalizedMessage());
        }
        try {
            StoredData data;
            List attributes = resource.getAttribute();
            if (attributes != null) {
                for (Attribute a : attributes) {
                    a.setResource(r);
                    this.attributeDAO.persist((Object[])new Attribute[]{a});
                }
            }
            if ((data = resource.getData()) != null) {
                data.setId(r.getId().longValue());
                data.setResource(r);
                this.storedDataDAO.persist((Object[])new StoredData[]{data});
            }
            if (rules != null) {
                for (SecurityRule rule : rules) {
                    rule.setResource(r);
                    this.securityDAO.persist((Object[])new SecurityRule[]{rule});
                }
            }
            return r.getId();
        }
        catch (Exception e) {
            this.delete(r.getId());
            throw e;
        }
    }

    public long update(Resource resource) throws NotFoundServiceEx, DuplicatedResourceNameServiceEx {
        Resource orig = (Resource)this.resourceDAO.find(resource.getId());
        if (orig == null) {
            throw new NotFoundServiceEx("Resource not found " + resource.getId());
        }
        this.validateResourceName(resource, true);
        resource.setCreation(orig.getCreation());
        resource.setLastUpdate(new Date());
        this.resourceDAO.merge((Object)resource);
        return orig.getId();
    }

    public void updateAttributes(long id, List<Attribute> attributes) throws NotFoundServiceEx {
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(id));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found " + id);
        }
        List oldList = resource.getAttribute();
        if (oldList != null) {
            for (Attribute a : oldList) {
                this.attributeDAO.removeById(Long.valueOf(a.getId()));
            }
        }
        for (Attribute a : attributes) {
            a.setResource(resource);
            this.attributeDAO.persist((Object[])new Attribute[]{a});
        }
    }

    private void validateResourceName(Resource resource, boolean isUpdate) throws DuplicatedResourceNameServiceEx {
        Resource existentResource = this.resourceDAO.findByName(resource.getName());
        if (!(existentResource == null || isUpdate && existentResource.getId().equals(resource.getId()))) {
            String validResourceName = this.suggestValidResourceName(resource.getName());
            throw new DuplicatedResourceNameServiceEx(validResourceName);
        }
    }

    private String suggestValidResourceName(String baseResourceName) {
        String COUNTER_SEPARATOR = " - ";
        String BASE_PATTERN = baseResourceName + " - ";
        String RESOURCE_NAME_LIKE_PATTERN = BASE_PATTERN + "%";
        Pattern RESOURCE_NAME_REGEX_PATTERN = Pattern.compile(BASE_PATTERN + "(\\d+)");
        int maxCounter = 0;
        int initialCounter = 2;
        List resourceNames = this.resourceDAO.findResourceNamesMatchingPattern(RESOURCE_NAME_LIKE_PATTERN);
        for (String resourceName : resourceNames) {
            Matcher matcher = RESOURCE_NAME_REGEX_PATTERN.matcher(resourceName);
            if (!matcher.matches()) continue;
            String suffix = matcher.group(1);
            int suffixAsInteger = 0;
            try {
                suffixAsInteger = Integer.valueOf(suffix);
                if (suffixAsInteger <= maxCounter) continue;
                maxCounter = suffixAsInteger;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Integer validCounter = Math.max(maxCounter + 1, initialCounter);
        String validName = BASE_PATTERN + validCounter;
        return validName;
    }

    public Resource get(long id) {
        return (Resource)this.resourceDAO.find(Long.valueOf(id));
    }

    public Resource getResource(long id, boolean includeAttributes, boolean includePermissions, boolean includeTags) {
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(id));
        if (resource != null) {
            resource = this.configResource(resource, includeAttributes, false, includePermissions, includeTags);
        }
        return resource;
    }

    public boolean delete(long id) {
        return this.resourceDAO.removeById(Long.valueOf(id));
    }

    public void deleteResources(SearchFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        Search searchCriteria = SearchConverter.convert(filter);
        this.resourceDAO.removeResources((ISearch)searchCriteria);
    }

    public List<ShortResource> getList(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        List<Resource> found = this.searchResources(resourceSearchParameters);
        return this.convertToShortResourceList(found, resourceSearchParameters.getAuthUser());
    }

    public List<ShortResource> getAll(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        List<Resource> found = this.searchResources(resourceSearchParameters);
        return this.convertToShortResourceList(found, resourceSearchParameters.getAuthUser());
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(Resource.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.resourceDAO.count((ISearch)searchCriteria);
    }

    public long getCountByFilter(SearchFilter filter) throws InternalErrorServiceEx, BadRequestServiceEx {
        Search searchCriteria = SearchConverter.convert(filter);
        return this.resourceDAO.count((ISearch)searchCriteria);
    }

    public List<ShortAttribute> getAttributes(long id) {
        Search searchCriteria = new Search(Attribute.class);
        searchCriteria.addFilterEqual("resource.id", (Object)id);
        List attributes = this.attributeDAO.search((ISearch)searchCriteria);
        return this.convertToShortAttributeList(attributes);
    }

    private List<ShortAttribute> convertToShortAttributeList(List<Attribute> list) {
        return list.stream().map(ShortAttribute::new).collect(Collectors.toList());
    }

    public ShortAttribute getAttribute(long id, String name) {
        Search searchCriteria = new Search(Attribute.class);
        searchCriteria.addFilterEqual("resource.id", (Object)id);
        searchCriteria.addFilterEqual("name", (Object)name);
        List attributes = this.attributeDAO.search((ISearch)searchCriteria);
        List<ShortAttribute> dtoList = this.convertToShortAttributeList(attributes);
        if (!dtoList.isEmpty()) {
            return dtoList.get(0);
        }
        return null;
    }

    public long updateAttribute(long id, String name, String value) throws InternalErrorServiceEx {
        Search searchCriteria = new Search(Attribute.class);
        searchCriteria.addFilterEqual("resource.id", (Object)id);
        searchCriteria.addFilterEqual("name", (Object)name);
        List attributes = this.attributeDAO.search((ISearch)searchCriteria);
        Attribute attribute = (Attribute)attributes.get(0);
        switch (attribute.getType()) {
            case DATE: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                try {
                    attribute.setDateValue(sdf.parse(value));
                    break;
                }
                catch (ParseException e) {
                    throw new InternalErrorServiceEx("Error parsing attribute date value");
                }
            }
            case NUMBER: {
                attribute.setNumberValue(Double.valueOf(value));
                break;
            }
            case STRING: {
                attribute.setTextValue(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + String.valueOf(attribute.getType()));
            }
        }
        attribute = (Attribute)this.attributeDAO.merge((Object)attribute);
        return attribute.getId();
    }

    public long insertAttribute(long id, String name, String value, DataType type) throws InternalErrorServiceEx {
        Search searchCriteria = new Search(Attribute.class);
        searchCriteria.addFilterEqual("resource.id", (Object)id);
        searchCriteria.addFilterEqual("name", (Object)name);
        List attributes = this.attributeDAO.search((ISearch)searchCriteria);
        if (!attributes.isEmpty()) {
            Attribute attribute = (Attribute)attributes.get(0);
            switch (attribute.getType()) {
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    try {
                        attribute.setDateValue(sdf.parse(value));
                        break;
                    }
                    catch (ParseException e) {
                        throw new InternalErrorServiceEx("Error parsing attribute date value");
                    }
                }
                case NUMBER: {
                    attribute.setNumberValue(Double.valueOf(value));
                    break;
                }
                case STRING: {
                    attribute.setTextValue(value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + String.valueOf(attribute.getType()));
                }
            }
            attribute = (Attribute)this.attributeDAO.merge((Object)attribute);
            return attribute.getId();
        }
        Attribute attribute = new Attribute();
        attribute.setType(type);
        attribute.setName(name);
        attribute.setResource((Resource)this.resourceDAO.find(Long.valueOf(id)));
        switch (type) {
            case DATE: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                try {
                    attribute.setDateValue(sdf.parse(value));
                    break;
                }
                catch (ParseException e) {
                    throw new InternalErrorServiceEx("Error parsing attribute date value");
                }
            }
            case NUMBER: {
                attribute.setNumberValue(Double.valueOf(value));
                break;
            }
            case STRING: {
                attribute.setTextValue(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + String.valueOf(attribute.getType()));
            }
        }
        return ((Attribute)this.attributeDAO.merge((Object)attribute)).getId();
    }

    public List<Resource> getResources(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        return this.configResourceList(this.searchResources(resourceSearchParameters), resourceSearchParameters.isIncludeAttributes(), resourceSearchParameters.isIncludeData(), resourceSearchParameters.isIncludeTags());
    }

    private List<Resource> configResourceList(List<Resource> resources, boolean includeAttributes, boolean includeData, boolean includeTags) {
        return resources.stream().map(r -> this.configResource((Resource)r, includeAttributes, includeData, false, includeTags)).collect(Collectors.toList());
    }

    private Resource configResource(Resource resource, boolean includeAttributes, boolean includeData, boolean includePermissions, boolean includeTags) {
        Resource configuredResource = new Resource();
        configuredResource.setCategory(resource.getCategory());
        configuredResource.setCreation(resource.getCreation());
        configuredResource.setDescription(resource.getDescription());
        configuredResource.setAdvertised(resource.isAdvertised());
        configuredResource.setId(resource.getId());
        configuredResource.setLastUpdate(resource.getLastUpdate());
        configuredResource.setName(resource.getName());
        configuredResource.setCreator(resource.getCreator());
        configuredResource.setEditor(resource.getEditor());
        if (includeData) {
            configuredResource.setData(resource.getData());
        }
        if (includeAttributes) {
            configuredResource.setAttribute(resource.getAttribute());
        }
        if (includePermissions) {
            configuredResource.setSecurity(this.getSecurityRules(resource.getId()));
        }
        if (includeTags) {
            configuredResource.setTags(resource.getTags());
        }
        return configuredResource;
    }

    public List<ShortResource> getShortResources(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        List<Resource> resources = this.searchResources(resourceSearchParameters);
        return this.convertToShortResourceList(resources, resourceSearchParameters.getAuthUser());
    }

    private List<Resource> searchResources(ResourceSearchParameters parameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        if (parameters.getPage() != null && parameters.getEntries() == null || parameters.getPage() == null && parameters.getEntries() != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together");
        }
        Search searchCriteria = SearchConverter.convert(parameters.getFilter());
        if (parameters.getPage() != null) {
            searchCriteria.setMaxResults(parameters.getEntries().intValue());
            searchCriteria.setPage(parameters.getPage().intValue());
        }
        if (parameters.getSortBy() != null && !parameters.getSortBy().isBlank()) {
            searchCriteria.addSort(parameters.getSortBy(), "DESC".equalsIgnoreCase(parameters.getSortOrder()));
        }
        if (parameters.getNameLike() != null) {
            searchCriteria.addFilterILike("name", parameters.getNameLike());
        }
        if (parameters.isFavoritesOnly()) {
            Long userId = parameters.getAuthUser().getId();
            searchCriteria.addFilterSome("favoritedBy", Filter.equal((String)"id", (Object)userId));
        }
        searchCriteria.addFetch("security");
        searchCriteria.setDistinct(true);
        this.securityDAO.addAdvertisedSecurityConstraints(searchCriteria, parameters.getAuthUser());
        return this.search(searchCriteria);
    }

    private List<ShortResource> convertToShortResourceList(List<Resource> resources, User user) {
        return resources.stream().map(r -> this.createShortResource(user, (Resource)r)).collect(Collectors.toList());
    }

    private ShortResource createShortResource(User user, Resource resource) {
        ShortResource shortResource = new ShortResource(resource);
        if (user != null && this.resourcePermissionService.canResourceBeWrittenByUser(resource, user)) {
            shortResource.setCanEdit(true);
            shortResource.setCanDelete(true);
            shortResource.setCanCopy(true);
        }
        return shortResource;
    }

    public List<Resource> getResourcesFull(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
        Search searchCriteria = SearchConverter.convert(resourceSearchParameters.getFilter());
        searchCriteria.setDistinct(true);
        searchCriteria.addFetch("security");
        searchCriteria.addFetch("data");
        searchCriteria.addFetch("favoritedBy");
        this.securityDAO.addReadSecurityConstraints(searchCriteria, resourceSearchParameters.getAuthUser());
        return this.search(searchCriteria);
    }

    private List<Resource> search(Search searchCriteria) throws BadRequestServiceEx {
        try {
            if (searchCriteria != null && searchCriteria.getSorts().isEmpty()) {
                searchCriteria.addSort(new Sort("name"));
            }
            return this.resourceDAO.search((ISearch)searchCriteria);
        }
        catch (IllegalArgumentException iaex) {
            throw new BadRequestServiceEx("Resource search failed", (Throwable)iaex);
        }
    }

    public List<SecurityRule> getUserSecurityRule(String userName, long resourceId) {
        return this.securityDAO.findUserSecurityRule(userName, resourceId);
    }

    public List<SecurityRule> getGroupSecurityRule(List<String> groupNames, long resourceId) {
        return this.securityDAO.findGroupSecurityRule(groupNames, resourceId);
    }

    public List<SecurityRule> getSecurityRules(long id) {
        return this.securityDAO.findResourceSecurityRules(id);
    }

    public void updateSecurityRules(long id, List<SecurityRule> rules) throws BadRequestServiceEx, InternalErrorServiceEx, NotFoundServiceEx {
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(id));
        if (resource != null) {
            Search searchCriteria = new Search();
            searchCriteria.addFilterEqual("resource.id", (Object)id);
            List resourceRules = this.securityDAO.search((ISearch)searchCriteria);
            for (SecurityRule rule : resourceRules) {
                this.securityDAO.remove((Object)rule);
            }
            for (SecurityRule rule : rules) {
                UserGroup ug;
                rule.setResource(resource);
                if (rule.getGroup() != null && (ug = (UserGroup)this.userGroupDAO.find(rule.getGroup().getId())) != null) {
                    rule.setGroup(ug);
                }
                this.securityDAO.persist((Object[])new SecurityRule[]{rule});
            }
        } else {
            throw new NotFoundServiceEx("Resource not found " + id);
        }
    }

    public long count(SearchFilter filter, User user) throws BadRequestServiceEx, InternalErrorServiceEx {
        return this.count(filter, user, false);
    }

    public long count(SearchFilter filter, User user, boolean favoritesOnly) throws BadRequestServiceEx, InternalErrorServiceEx {
        Search searchCriteria = SearchConverter.convert(filter);
        searchCriteria.setDistinct(true);
        if (favoritesOnly) {
            searchCriteria.addFilterSome("favoritedBy", Filter.equal((String)"id", (Object)user.getId()));
        }
        this.securityDAO.addAdvertisedSecurityConstraints(searchCriteria, user);
        return this.resourceDAO.count((ISearch)searchCriteria);
    }

    public long count(String nameLike, User user) {
        Search searchCriteria = new Search(Resource.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        this.securityDAO.addAdvertisedSecurityConstraints(searchCriteria, user);
        return this.resourceDAO.count((ISearch)searchCriteria);
    }

    public void fetchSecurityRules(Resource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        resource.setSecurity(this.securityDAO.findResourceSecurityRules(resource.getId().longValue()));
    }

    public void fetchFavoritedBy(Resource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        resource.setFavoritedBy(new HashSet(this.userDAO.findFavoritedBy(resource.getId())));
    }
}

