/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.UserAttributeDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.model.enums.UserReservedNames;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LogManager.getLogger(UserServiceImpl.class);
    private UserDAO userDAO;
    private UserAttributeDAO userAttributeDAO;
    private UserGroupDAO userGroupDAO;

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public void setUserAttributeDAO(UserAttributeDAO userAttributeDAO) {
        this.userAttributeDAO = userAttributeDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public long insert(User user) throws BadRequestServiceEx, NotFoundServiceEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting User ... ");
        }
        if (user == null) {
            throw new BadRequestServiceEx("User type must be specified !");
        }
        if (!UserReservedNames.isAllowedName((String)user.getName())) {
            throw new BadRequestServiceEx("User name '" + user.getName() + "' is not allowed...");
        }
        User u = new User();
        u.setName(user.getName());
        u.setNewPassword(user.getNewPassword());
        u.setEnabled(user.isEnabled());
        u.setRole(user.getRole());
        Set groups = user.getGroups();
        ArrayList<String> groupNames = new ArrayList<String>();
        List existingGroups = new ArrayList<UserGroup>();
        if (groups != null && groups.size() > 0) {
            for (UserGroup group : groups) {
                String groupName = group.getGroupName();
                groupNames.add(groupName);
                if (!StringUtils.isEmpty((String)groupName)) continue;
                throw new BadRequestServiceEx("The user group name must be specified! ");
            }
            Search searchCriteria = new Search(UserGroup.class);
            searchCriteria.addFilterIn("groupName", groupNames);
            existingGroups = this.userGroupDAO.search((ISearch)searchCriteria);
            if (existingGroups != null && groups.size() != existingGroups.size()) {
                throw new NotFoundServiceEx("At least one User group not found; review the groups associated to the user you want to insert" + user.getId());
            }
        }
        Search search = new Search();
        search.addFilterEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        List ugEveryone = this.userGroupDAO.search((ISearch)search);
        if (ugEveryone == null || ugEveryone.size() != 1) {
            LOGGER.error("No UserGroup EVERYONE found, or more than 1 results has been found... skip the EVERYONE group associations for user '" + user.getName() + "'");
        } else {
            existingGroups.add((UserGroup)ugEveryone.get(0));
        }
        u.setGroups(new HashSet(existingGroups));
        this.userDAO.persist((Object[])new User[]{u});
        List attributes = user.getAttribute();
        if (attributes != null) {
            for (UserAttribute a : attributes) {
                a.setUser(u);
                this.userAttributeDAO.persist((Object[])new UserAttribute[]{a});
            }
        }
        return u.getId();
    }

    public long update(User user) throws NotFoundServiceEx, BadRequestServiceEx {
        User orig = this.get(user.getId());
        if (orig == null) {
            orig = this.get(user.getName());
            user.setId(orig.getId());
        }
        if (orig == null) {
            throw new NotFoundServiceEx("User not found " + user.getId());
        }
        Set groups = GroupReservedNames.checkReservedGroups((Collection)user.getGroups());
        ArrayList<String> groupNames = new ArrayList<String>();
        Set existingGroups = new HashSet<UserGroup>();
        if (groups != null && groups.size() > 0) {
            for (UserGroup group : groups) {
                String groupName = group.getGroupName();
                groupNames.add(groupName);
                if (!StringUtils.isEmpty((String)groupName)) continue;
                throw new BadRequestServiceEx("The user group name must be specified! ");
            }
            Search searchCriteria = new Search(UserGroup.class);
            searchCriteria.addFilterIn("groupName", groupNames);
            existingGroups = GroupReservedNames.checkReservedGroups((Collection)this.userGroupDAO.search((ISearch)searchCriteria));
            if (existingGroups == null || existingGroups != null && groups.size() != existingGroups.size()) {
                throw new NotFoundServiceEx("At least one User group not found; review the groups associated to the user you want to insert" + user.getId());
            }
        }
        Search search = new Search();
        search.addFilterEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        List ugEveryone = this.userGroupDAO.search((ISearch)search);
        if (ugEveryone == null || ugEveryone.size() != 1) {
            LOGGER.error("No UserGroup EVERYONE found, or more than 1 results has been found... skip the EVERYONE group associations for user '" + user.getName() + "'");
        } else {
            existingGroups.add((UserGroup)ugEveryone.get(0));
        }
        user.getGroups().clear();
        user.getGroups().addAll(existingGroups);
        this.userDAO.merge((Object)user);
        return orig.getId();
    }

    public void updateAttributes(long id, List<UserAttribute> attributes) throws NotFoundServiceEx {
        User user = (User)this.userDAO.find(Long.valueOf(id));
        if (user == null) {
            throw new NotFoundServiceEx("User not found " + id);
        }
        List oldList = user.getAttribute();
        if (oldList != null) {
            for (UserAttribute a : oldList) {
                this.userAttributeDAO.removeById(a.getId());
            }
        }
        for (UserAttribute a : attributes) {
            a.setUser(user);
            this.userAttributeDAO.persist((Object[])new UserAttribute[]{a});
        }
    }

    public User get(long id) {
        User user = (User)this.userDAO.find(Long.valueOf(id));
        return user;
    }

    public User get(String name) throws NotFoundServiceEx {
        Search searchCriteria = new Search(User.class);
        searchCriteria.addFilterEqual("name", (Object)name);
        searchCriteria.addFetch("attribute");
        List users = this.userDAO.search((ISearch)searchCriteria);
        if (!users.isEmpty()) {
            return (User)users.get(0);
        }
        throw new NotFoundServiceEx("User not found with name: " + name);
    }

    public boolean delete(long id) {
        return this.userDAO.removeById(Long.valueOf(id));
    }

    public List<User> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(User.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        List found = this.userDAO.search((ISearch)searchCriteria);
        return found;
    }

    public List<User> getAll(Integer page, Integer entries, String nameLike, boolean includeAttributes) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(User.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        List<User> found = this.userDAO.search((ISearch)searchCriteria);
        found = this.configUserList(found, includeAttributes);
        return found;
    }

    private List<User> configUserList(List<User> list, boolean includeAttributes) {
        ArrayList<User> uList = new ArrayList<User>(list.size());
        for (User user : list) {
            User u = new User();
            u.setGroups(user.getGroups());
            u.setId(user.getId());
            u.setName(user.getName());
            u.setEnabled(user.isEnabled());
            u.setPassword(user.getPassword());
            u.setRole(user.getRole());
            if (includeAttributes) {
                u.setAttribute(user.getAttribute());
            }
            uList.add(u);
        }
        return uList;
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(User.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.userDAO.count((ISearch)searchCriteria);
    }

    public boolean insertSpecialUsers() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Reserved Users... ");
        }
        User u = new User();
        u.setName(UserReservedNames.GUEST.userName());
        u.setRole(Role.GUEST);
        Search search = new Search();
        search.addFilterEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        List userGroup = this.userGroupDAO.search((ISearch)search);
        if (userGroup.size() != 1) {
            LOGGER.warn("More than EVERYONE group is found...");
        }
        u.setGroups(new HashSet(userGroup));
        this.userDAO.persist((Object[])new User[]{u});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Special User '" + u.getName() + "' persisted!");
        }
        return true;
    }

    public Collection<User> getByAttribute(UserAttribute attribute) {
        Search searchCriteria = new Search(UserAttribute.class);
        searchCriteria.addFilterEqual("name", (Object)attribute.getName());
        searchCriteria.addFilterEqual("value", (Object)attribute.getValue());
        searchCriteria.addFetch("user");
        List attributes = this.userAttributeDAO.search((ISearch)searchCriteria);
        HashSet<User> users = new HashSet<User>();
        for (UserAttribute userAttr : attributes) {
            if (userAttr.getUser() == null) continue;
            users.add(userAttr.getUser());
        }
        return users;
    }

    public Collection<User> getByGroup(UserGroup group) {
        Search searchByGroup = new Search(User.class);
        if (group.getGroupName() != null) {
            searchByGroup.addFilterSome("groups", Filter.equal((String)"groupName", (Object)group.getGroupName()));
        } else {
            searchByGroup.addFilterSome("groups", Filter.equal((String)"id", (Object)group.getId()));
        }
        return this.userDAO.search((ISearch)searchByGroup);
    }
}

