/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.StoredDataService;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServiceTestBase
extends TestCase {
    protected static StoredDataService storedDataService;
    protected static ResourceService resourceService;
    protected static CategoryService categoryService;
    protected static UserService userService;
    protected static UserGroupService userGroupService;
    protected static ResourceDAO resourceDAO;
    protected static ClassPathXmlApplicationContext ctx;
    protected final Logger LOGGER = LogManager.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTestBase() {
        Class<ServiceTestBase> clazz = ServiceTestBase.class;
        synchronized (ServiceTestBase.class) {
            if (ctx == null) {
                String[] paths = new String[]{"classpath*:applicationContext.xml"};
                ctx = new ClassPathXmlApplicationContext(paths);
                storedDataService = (StoredDataService)ctx.getBean("storedDataService");
                resourceService = (ResourceService)ctx.getBean("resourceService");
                categoryService = (CategoryService)ctx.getBean("categoryService");
                userService = (UserService)ctx.getBean("userService");
                userGroupService = (UserGroupService)ctx.getBean("userGroupService");
                resourceDAO = (ResourceDAO)ctx.getBean("resourceDAO");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void setUp() throws Exception {
        this.LOGGER.info("################ Running " + ((Object)((Object)this)).getClass().getSimpleName() + "::" + this.getName());
        super.setUp();
        this.removeAll();
    }

    public void testCheckServices() {
        ServiceTestBase.assertNotNull((Object)storedDataService);
        ServiceTestBase.assertNotNull((Object)resourceService);
        ServiceTestBase.assertNotNull((Object)categoryService);
        ServiceTestBase.assertNotNull((Object)userService);
        ServiceTestBase.assertNotNull((Object)userGroupService);
    }

    protected void removeAll() throws NotFoundServiceEx, BadRequestServiceEx {
        this.LOGGER.info("***** removeAll()");
        this.removeAllResource();
        this.removeAllStoredData();
        this.removeAllCategory();
        this.removeAllUser();
        this.removeAllUserGroup();
    }

    private void removeAllUserGroup() throws BadRequestServiceEx, NotFoundServiceEx {
        List list = userGroupService.getAll(null, null);
        for (UserGroup item : list) {
            this.LOGGER.info("Removing User: " + item.getGroupName());
            if (!GroupReservedNames.isAllowedName((String)item.getGroupName())) continue;
            boolean ret = userGroupService.delete(item.getId().longValue());
            ServiceTestBase.assertTrue((String)"Group not removed", (boolean)ret);
        }
        boolean res = userGroupService.removeSpecialUsersGroups();
        ServiceTestBase.assertEquals((String)"Group have not been properly deleted", (long)0L, (long)userService.getCount(null));
    }

    private void removeAllUser() throws BadRequestServiceEx {
        List list = userService.getAll(null, null);
        for (User item : list) {
            this.LOGGER.info("Removing User: " + item.getName());
            boolean ret = userService.delete(item.getId().longValue());
            ServiceTestBase.assertTrue((String)"User not removed", (boolean)ret);
        }
        ServiceTestBase.assertEquals((String)"User have not been properly deleted", (long)0L, (long)userService.getCount(null));
    }

    private void removeAllCategory() throws BadRequestServiceEx {
        List list = categoryService.getAll(null, null);
        for (Category item : list) {
            this.LOGGER.info("Removing " + item);
            boolean ret = categoryService.delete(item.getId().longValue());
            ServiceTestBase.assertTrue((String)"Category not removed", (boolean)ret);
        }
        ServiceTestBase.assertEquals((String)"Category have not been properly deleted", (long)0L, (long)categoryService.getCount(null));
    }

    protected void removeAllStoredData() throws NotFoundServiceEx {
        List list = storedDataService.getAll();
        for (StoredData item : list) {
            this.LOGGER.info("Removing " + item);
            boolean ret = storedDataService.delete(item.getId().longValue());
            ServiceTestBase.assertTrue((String)"Data not removed", (boolean)ret);
        }
    }

    private void removeAllResource() throws BadRequestServiceEx {
        List list = resourceService.getAll(null, null, this.buildFakeAdminUser());
        for (ShortResource item : list) {
            this.LOGGER.info("Removing " + item);
            boolean ret = resourceService.delete(item.getId());
            ServiceTestBase.assertTrue((String)"Resource not removed", (boolean)ret);
        }
        ServiceTestBase.assertEquals((String)"Resource have not been properly deleted", (long)0L, (long)resourceService.getCount(null));
    }

    protected long createData(String data, Resource resource) throws Exception {
        return storedDataService.update(resource.getId().longValue(), data);
    }

    protected long createResource(String name, String description, String catName) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        return resourceService.insert(resource);
    }

    protected long createResource(String name, String description, String catName, String data) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        StoredData storedData = new StoredData();
        storedData.setData(data);
        resource.setData(storedData);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        return resourceService.insert(resource);
    }

    protected long createResource(String name, String description, String catName, List<SecurityRule> rules) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setSecurity(rules);
        return resourceService.insert(resource);
    }

    protected long createResource(String name, String description, String catName, boolean advertised, List<SecurityRule> rules) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setAdvertised(Boolean.valueOf(advertised));
        resource.setSecurity(rules);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        return resourceService.insert(resource);
    }

    protected long createResource(String name, String description, Category category) throws Exception {
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        return resourceService.insert(resource);
    }

    protected long createCategory(String name) throws Exception {
        Category category = new Category();
        category.setName(name);
        return categoryService.insert(category);
    }

    protected long createUser(String name, Role role, String password) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(password);
        return userService.insert(user);
    }

    protected long createUserGroup(String name, long[] usersId) throws Exception {
        UserGroup group = new UserGroup();
        group.setGroupName(name);
        group.setDescription("");
        long groupId = userGroupService.insert(group);
        for (long userId : usersId) {
            userGroupService.assignUserGroup(userId, groupId);
        }
        return groupId;
    }

    protected void createSpecialUserGroups() {
        userGroupService.insertSpecialUsersGroups();
    }

    protected long createUser(String name, Role role, String password, List<UserAttribute> attributes) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(password);
        user.setAttribute(attributes);
        return userService.insert(user);
    }

    protected long createUser(String name, Role role, String password, long groupId) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(password);
        long id = userService.insert(user);
        userGroupService.assignUserGroup(id, groupId);
        return id;
    }

    protected long createGroup(String name) throws Exception {
        UserGroup group = new UserGroup();
        group.setGroupName(name);
        return userGroupService.insert(group);
    }

    protected User buildFakeAdminUser() {
        User user = new User();
        user.setRole(Role.ADMIN);
        user.setName("ThisIsNotARealUser");
        return user;
    }

    static {
        ctx = null;
    }

    protected class SecurityRuleBuilder {
        private SecurityRule rule = new SecurityRule();

        public SecurityRuleBuilder user(User user) {
            this.rule.setUser(user);
            return this;
        }

        public SecurityRuleBuilder canRead(boolean canRead) {
            this.rule.setCanRead(canRead);
            return this;
        }

        public SecurityRuleBuilder group(UserGroup group) {
            this.rule.setGroup(group);
            return this;
        }

        public SecurityRule build() {
            return this.rule;
        }
    }
}

