/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceServiceImplTest
extends ServiceTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testInsertDeleteResource() throws Exception {
        long resourceId = this.createResource("name1", "description1", "MAP");
        ResourceServiceImplTest.assertEquals((long)1L, (long)resourceService.getCount(null));
        ResourceServiceImplTest.assertTrue((String)"Could not delete resource", (boolean)resourceService.delete(resourceId));
        ResourceServiceImplTest.assertEquals((long)0L, (long)resourceService.getCount(null));
    }

    @Test
    public void testUpdateData() throws Exception {
        String NAME1 = "name1";
        String NAME2 = "name2";
        long resourceId = this.createResource("name1", "description1", "MAP");
        ResourceServiceImplTest.assertEquals((long)1L, (long)resourceService.getCount(null));
        Resource loaded = resourceService.get(resourceId);
        ResourceServiceImplTest.assertNotNull((Object)loaded);
        ResourceServiceImplTest.assertNull((Object)loaded.getLastUpdate());
        ResourceServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        loaded.setName("name2");
        resourceService.update(loaded);
        loaded = resourceService.get(resourceId);
        ResourceServiceImplTest.assertNotNull((Object)loaded);
        ResourceServiceImplTest.assertNotNull((Object)loaded.getLastUpdate());
        ResourceServiceImplTest.assertEquals((String)"name2", (String)loaded.getName());
        ResourceServiceImplTest.assertEquals((long)1L, (long)resourceService.getCount(null));
        resourceService.delete(resourceId);
        ResourceServiceImplTest.assertEquals((long)0L, (long)resourceService.getCount(null));
    }

    @Test
    public void testGetAllData() throws Exception {
        int i;
        ResourceServiceImplTest.assertEquals((int)0, (int)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        for (i = 0; i < 10; ++i) {
            this.createResource("name" + i, "description" + i, "MAP1" + i);
        }
        for (i = 0; i < 10; ++i) {
            this.createResource("test name" + i, "description" + i, "MAP2" + i);
        }
        ResourceServiceImplTest.assertEquals((int)20, (int)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        ResourceServiceImplTest.assertEquals((long)10L, (long)resourceService.getCount("name%"));
        ResourceServiceImplTest.assertEquals((int)10, (int)resourceService.getList("name%", null, null, this.buildFakeAdminUser()).size());
        ResourceServiceImplTest.assertEquals((long)20L, (long)resourceService.getCount("%name%"));
        ResourceServiceImplTest.assertEquals((int)20, (int)resourceService.getList("%name%", null, null, this.buildFakeAdminUser()).size());
        ResourceServiceImplTest.assertEquals((long)2L, (long)resourceService.getCount("%name1%"));
        ResourceServiceImplTest.assertEquals((int)2, (int)resourceService.getList("%name1%", null, null, this.buildFakeAdminUser()).size());
    }

    @Test
    public void testSorting() throws Exception {
        int i;
        ResourceServiceImplTest.assertEquals((int)0, (int)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        for (i = 0; i < 20; ++i) {
            this.createResource("FIRST SET - " + i, "description" + i, "MAP1" + i);
        }
        for (i = 19; i >= 0; --i) {
            this.createResource("SECOND SET - " + i, "description" + i, "MAP2" + i);
        }
        List getAllResult = resourceService.getAll(null, null, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)40, (int)getAllResult.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(getAllResult));
        CategoryFilter MAPCategoryFilter = new CategoryFilter("MAP%", SearchOperator.LIKE);
        List getResourcesMAPResult = resourceService.getResources((SearchFilter)MAPCategoryFilter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)40, (int)getResourcesMAPResult.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(getResourcesMAPResult));
        CategoryFilter MAP1CategoryFilter = new CategoryFilter("MAP1%", SearchOperator.LIKE);
        List getResourcesMAP1Result = resourceService.getResources((SearchFilter)MAP1CategoryFilter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)20, (int)getResourcesMAP1Result.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(getResourcesMAP1Result));
        CategoryFilter MAP2CategoryFilter = new CategoryFilter("MAP2%", SearchOperator.LIKE);
        List getResourcesMAP2Result = resourceService.getResources((SearchFilter)MAP2CategoryFilter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)20, (int)getResourcesMAP2Result.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(getResourcesMAP2Result));
        FieldFilter nameContain1Filter = new FieldFilter(BaseField.NAME, "%1%", SearchOperator.LIKE);
        List nameContain1Result = resourceService.getResources((SearchFilter)nameContain1Filter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)22, (int)nameContain1Result.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(nameContain1Result));
        FieldFilter nameContain2Filter = new FieldFilter(BaseField.NAME, "%2%", SearchOperator.LIKE);
        List nameContain2Result = resourceService.getResources((SearchFilter)nameContain2Filter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)4, (int)nameContain2Result.size());
        ResourceServiceImplTest.assertTrue((boolean)ResourceServiceImplTest.isSorted(nameContain2Result));
    }

    private static boolean isSorted(List<ShortResource> resourcesList) {
        if (resourcesList.size() == 1) {
            return true;
        }
        Iterator<ShortResource> iter = resourcesList.iterator();
        ShortResource previous = iter.next();
        while (iter.hasNext()) {
            ShortResource current = iter.next();
            if (previous.getName().compareTo(current.getName()) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    @Test
    public void testCategoryFilter() throws Exception {
        ResourceServiceImplTest.assertEquals((int)0, (int)categoryService.getAll(null, null).size());
        long id0 = this.createCategory("category0");
        long id1 = this.createCategory("category1");
        ResourceServiceImplTest.assertEquals((int)2, (int)categoryService.getAll(null, null).size());
        Category c0 = new Category();
        c0.setId(Long.valueOf(id0));
        Category c1i = new Category();
        c1i.setId(Long.valueOf(id1));
        Category c1n = new Category();
        c1n.setName("category1");
        ResourceServiceImplTest.assertEquals((int)0, (int)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long r0 = this.createResource("res0", "des0", c0);
        long r1 = this.createResource("res1", "des1", c1i);
        long r2 = this.createResource("res2", "des2", c1n);
        ResourceServiceImplTest.assertEquals((int)3, (int)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        CategoryFilter filter = new CategoryFilter("category0", SearchOperator.EQUAL_TO);
        List list = resourceService.getResources((SearchFilter)filter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)1, (int)list.size());
        ResourceServiceImplTest.assertEquals((long)r0, (long)((ShortResource)list.get(0)).getId());
        filter = new CategoryFilter("%1", SearchOperator.LIKE);
        list = resourceService.getResources((SearchFilter)filter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)2, (int)list.size());
        filter = new CategoryFilter("cat%", SearchOperator.LIKE);
        list = resourceService.getResources((SearchFilter)filter, this.buildFakeAdminUser());
        ResourceServiceImplTest.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testGetSecurityRules() throws Exception {
        long userId = this.createUser("user1", Role.USER, "password");
        User user = new User();
        user.setId(Long.valueOf(userId));
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rules.add(rule);
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        long resourceId = this.createResource("name1", "description1", "MAP", rules);
        List writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)2, (int)writtenRules.size());
        SecurityRule userRule = (SecurityRule)writtenRules.get(0);
        ResourceServiceImplTest.assertNotNull((Object)userRule.getUser());
        ResourceServiceImplTest.assertNull((Object)userRule.getGroup());
        ResourceServiceImplTest.assertEquals((Object)userId, (Object)userRule.getUser().getId());
        ResourceServiceImplTest.assertEquals((Object)resourceId, (Object)userRule.getResource().getId());
        SecurityRule groupRule = (SecurityRule)writtenRules.get(1);
        ResourceServiceImplTest.assertNotNull((Object)groupRule.getGroup());
        ResourceServiceImplTest.assertNull((Object)groupRule.getUser());
        ResourceServiceImplTest.assertEquals((Object)groupId, (Object)groupRule.getGroup().getId());
        ResourceServiceImplTest.assertEquals((Object)resourceId, (Object)groupRule.getResource().getId());
    }

    @Test
    public void testUpdateSecurityRules() throws Exception {
        long resourceId = this.createResource("name1", "description1", "MAP");
        List writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)0, (int)writtenRules.size());
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        long userId = this.createUser("user1", Role.USER, "password");
        User user = new User();
        user.setId(Long.valueOf(userId));
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        long otherGroupId = this.createGroup("group2");
        UserGroup othergroup = new UserGroup();
        othergroup.setId(Long.valueOf(otherGroupId));
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rules.add(rule);
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        resourceService.updateSecurityRules(resourceId, rules);
        writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)2, (int)writtenRules.size());
        rules.clear();
        rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rules.add(rule);
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(othergroup);
        rules.add(rule);
        resourceService.updateSecurityRules(resourceId, rules);
        writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)3, (int)writtenRules.size());
    }

    @Test
    public void testInsertTooBigResource() throws Exception {
        String ORIG_RES_NAME = "testRes";
        String DESCRIPTION = "description";
        String CATEGORY_NAME = "MAP";
        String bigData = ResourceServiceImplTest.createDataSize(100000000);
        boolean error = false;
        ResourceServiceImplTest.assertEquals((long)0L, (long)resourceService.getCount(null));
        try {
            this.createResource("testRes", "description", "MAP", bigData);
        }
        catch (Exception e) {
            error = true;
        }
        ResourceServiceImplTest.assertEquals((long)0L, (long)resourceService.getCount(null));
        ResourceServiceImplTest.assertTrue((boolean)error);
    }

    private static String createDataSize(int msgSize) {
        StringBuilder sb = new StringBuilder(msgSize);
        for (int i = 0; i < msgSize; ++i) {
            sb.append('a');
        }
        return sb.toString();
    }

    @Test
    public void testInsertUpdateDuplicatedResource() throws Exception {
        int i;
        String ORIG_RES_NAME = "testRes";
        String DESCRIPTION = "description";
        String CATEGORY_NAME = "MAP";
        int NUM_COPIES = 3;
        long[] COPY_IDS = new long[3];
        long origResourceId = this.createResource("testRes", "description", "MAP");
        Category category = categoryService.get("MAP");
        ResourceServiceImplTest.assertEquals((long)1L, (long)resourceService.getCount(null));
        ResourceServiceImplTest.assertNotNull((Object)category);
        for (i = 0; i < 3; ++i) {
            long copyId = -1L;
            try {
                this.createResource("testRes", "description", category);
                ResourceServiceImplTest.fail((String)"DuplicatedResourceNameServiceEx was not thrown as expected");
            }
            catch (DuplicatedResourceNameServiceEx ex) {
                String validCopyName = ex.getMessage();
                ResourceServiceImplTest.assertNotNull((String)"Thrown DuplicatedResourceNameServiceEx exception's message was null", (Object)validCopyName);
                ResourceServiceImplTest.assertFalse((String)"Thrown DuplicatedResourceNameServiceEx exception's message was empty", (boolean)validCopyName.isEmpty());
                copyId = this.createResource(validCopyName, "description", category);
            }
            ResourceServiceImplTest.assertTrue((copyId > 0L ? 1 : 0) != 0);
            ResourceServiceImplTest.assertEquals((long)(i + 2), (long)resourceService.getCount(null));
            Resource copy = resourceService.get(copyId);
            ResourceServiceImplTest.assertNotNull((Object)copy);
            copy.setName("testRes");
            try {
                resourceService.update(copy);
                ResourceServiceImplTest.fail((String)"DuplicatedResourceNameServiceEx was not thrown as expected");
            }
            catch (DuplicatedResourceNameServiceEx ex) {
                String validCopyName = ex.getMessage();
                ResourceServiceImplTest.assertNotNull((String)"Thrown DuplicatedResourceNameServiceEx exception's message was null", (Object)validCopyName);
                ResourceServiceImplTest.assertFalse((String)"Thrown DuplicatedResourceNameServiceEx exception's message was empty", (boolean)validCopyName.isEmpty());
                copy.setName(validCopyName);
                try {
                    resourceService.update(copy);
                    copy.setDescription("description modified");
                    resourceService.update(copy);
                }
                catch (Exception e) {
                    ResourceServiceImplTest.fail((String)("Exception was thrown during update: " + e.getMessage()));
                }
            }
            COPY_IDS[i] = copyId;
        }
        ResourceServiceImplTest.assertTrue((String)"Could not delete resource", (boolean)resourceService.delete(origResourceId));
        for (i = 0; i < 3; ++i) {
            ResourceServiceImplTest.assertTrue((String)"Could not delete resource", (boolean)resourceService.delete(COPY_IDS[i]));
        }
        ResourceServiceImplTest.assertEquals((long)0L, (long)resourceService.getCount(null));
    }

    @Test
    public void testInsertUpdateCreatorAndEditor() throws Exception {
        String ORIG_RES_NAME = "testRes";
        String DESCRIPTION = "description";
        String CATEGORY_NAME = "MAP";
        long origResourceId = this.createResource("testRes", "description", "MAP");
        Category category = categoryService.get("MAP");
        ResourceServiceImplTest.assertEquals((long)1L, (long)resourceService.getCount(null));
        ResourceServiceImplTest.assertNotNull((Object)category);
        Resource resource = resourceService.get(origResourceId);
        ResourceServiceImplTest.assertEquals((String)"USER1", (String)resource.getCreator());
        ResourceServiceImplTest.assertEquals((String)"USER2", (String)resource.getEditor());
        resource.setCreator("USER1Updated");
        resource.setEditor("USER1Updated");
        resourceService.update(resource);
        resource = resourceService.get(origResourceId);
        ResourceServiceImplTest.assertEquals((String)"USER1Updated", (String)resource.getCreator());
        ResourceServiceImplTest.assertEquals((String)"USER1Updated", (String)resource.getEditor());
    }

    @Test
    public void testUnadvertisedResources() throws Exception {
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        long otherGroupId = this.createGroup("group2");
        UserGroup otherGroup = new UserGroup();
        otherGroup.setId(Long.valueOf(otherGroupId));
        long user1Id = this.createUser("user1", Role.USER, "password", groupId);
        User user1 = new User();
        user1.setId(Long.valueOf(user1Id));
        user1.setName("user1");
        user1.setRole(Role.USER);
        user1.setGroups(new HashSet<UserGroup>(Collections.singletonList(group)));
        long user2Id = this.createUser("user2", Role.USER, "password", otherGroupId);
        User user2 = new User();
        user2.setId(Long.valueOf(user2Id));
        user2.setName("user2");
        user2.setRole(Role.USER);
        user2.setGroups(new HashSet<UserGroup>(Collections.singletonList(otherGroup)));
        ArrayList<SecurityRule> rules1 = new ArrayList<SecurityRule>(Arrays.asList(new ServiceTestBase.SecurityRuleBuilder().user(user1).canRead(true).build(), new ServiceTestBase.SecurityRuleBuilder().group(group).canRead(true).build(), new ServiceTestBase.SecurityRuleBuilder().group(otherGroup).canRead(true).build()));
        long resourceId = this.createResource("name1", "description1", "MAP1", false, rules1);
        List writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)3, (int)writtenRules.size());
        FieldFilter nameContains1Filter = new FieldFilter(BaseField.NAME, "%name1%", SearchOperator.LIKE);
        resourceService.getResources((SearchFilter)nameContains1Filter, null, null, user2);
        ResourceServiceImplTest.assertEquals((int)1, (int)resourceService.getResources((SearchFilter)nameContains1Filter, null, null, this.buildFakeAdminUser()).size());
        ResourceServiceImplTest.assertEquals((int)1, (int)resourceService.getResources((SearchFilter)nameContains1Filter, null, null, user1).size());
        ResourceServiceImplTest.assertEquals((int)0, (int)resourceService.getResources((SearchFilter)nameContains1Filter, null, null, user2).size());
        ArrayList<SecurityRule> rules2 = new ArrayList<SecurityRule>(Arrays.asList(new ServiceTestBase.SecurityRuleBuilder().user(user1).canRead(true).build(), new ServiceTestBase.SecurityRuleBuilder().group(group).canRead(true).build(), new ServiceTestBase.SecurityRuleBuilder().group(otherGroup).canRead(true).build()));
        resourceId = this.createResource("name2", "description2", "MAP2", true, rules2);
        writtenRules = resourceService.getSecurityRules(resourceId);
        ResourceServiceImplTest.assertEquals((int)3, (int)writtenRules.size());
        FieldFilter nameContains2Filter = new FieldFilter(BaseField.NAME, "%name2%", SearchOperator.LIKE);
        ResourceServiceImplTest.assertEquals((int)1, (int)resourceService.getResources((SearchFilter)nameContains2Filter, null, null, this.buildFakeAdminUser()).size());
        ResourceServiceImplTest.assertEquals((int)1, (int)resourceService.getResources((SearchFilter)nameContains2Filter, null, null, user1).size());
        ResourceServiceImplTest.assertEquals((int)1, (int)resourceService.getResources((SearchFilter)nameContains2Filter, null, null, user2).size());
    }
}

