/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.UserGroupAttributeDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.exception.ReservedUserGroupNameEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserGroupServiceImpl
implements UserGroupService {
    private static final Logger LOGGER = LogManager.getLogger(UserGroupServiceImpl.class);
    private UserGroupDAO userGroupDAO;
    private UserDAO userDAO;
    private ResourceDAO resourceDAO;
    private SecurityDAO securityDAO;
    private UserGroupAttributeDAO userGroupAttributeDAO;

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public void setUserGroupAttributeDAO(UserGroupAttributeDAO userGroupAttributeDAO) {
        this.userGroupAttributeDAO = userGroupAttributeDAO;
    }

    public long insert(UserGroup userGroup) throws BadRequestServiceEx {
        List attributes;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting UserGroup... ");
        }
        if (userGroup == null || StringUtils.isEmpty((String)userGroup.getGroupName())) {
            throw new BadRequestServiceEx("The provided UserGroup instance is null or group Name is not specified!");
        }
        if (!GroupReservedNames.isAllowedName((String)userGroup.getGroupName())) {
            throw new ReservedUserGroupNameEx("The usergroup name you try to save: '" + userGroup.getGroupName() + "' is a reserved name!");
        }
        userGroup.setGroupName(userGroup.getGroupName());
        this.userGroupDAO.persist((Object[])new UserGroup[]{userGroup});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UserGroup '" + userGroup.getGroupName() + "' persisted!");
        }
        if ((attributes = userGroup.getAttributes()) != null && !attributes.isEmpty()) {
            for (UserGroupAttribute attr : attributes) {
                attr.setUserGroup(userGroup);
                this.userGroupAttributeDAO.persist((Object[])new UserGroupAttribute[]{attr});
            }
        }
        return userGroup.getId();
    }

    public boolean delete(long id) throws NotFoundServiceEx, BadRequestServiceEx {
        UserGroup group = (UserGroup)this.userGroupDAO.find(Long.valueOf(id));
        if (group == null) {
            LOGGER.error("Can't find usergroup with id '" + id + "'");
            throw new NotFoundServiceEx("Can't find usergroup with id '" + id + "'");
        }
        if (!GroupReservedNames.isAllowedName((String)group.getGroupName())) {
            throw new BadRequestServiceEx("Delete a special usergroup ('" + group.getGroupName() + "' in this case) isn't possible");
        }
        for (User u : this.getUsersByGroup(id)) {
            u.removeGroup(id);
            this.userDAO.merge((Object)u);
        }
        this.userGroupDAO.remove((Object)group);
        return true;
    }

    private Collection<User> getUsersByGroup(long groupId) {
        Search searchByGroup = new Search(User.class);
        searchByGroup.addFilterSome("groups", Filter.equal((String)"id", (Object)groupId));
        return this.userDAO.search((ISearch)searchByGroup);
    }

    public void assignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
        UserGroup groupToAssign = (UserGroup)this.userGroupDAO.find(Long.valueOf(groupId));
        User targetUser = (User)this.userDAO.find(Long.valueOf(userId));
        if (groupToAssign == null || targetUser == null) {
            throw new NotFoundServiceEx("The userGroup or the user you provide doesn't exist");
        }
        if (!GroupReservedNames.isAllowedName((String)groupToAssign.getGroupName())) {
            throw new NotFoundServiceEx("You can't re-assign the group EVERYONE or any other reserved groups...");
        }
        if (targetUser.getGroups() == null) {
            HashSet<UserGroup> groups = new HashSet<UserGroup>();
            groups.add(groupToAssign);
            targetUser.setGroups(groups);
        } else {
            targetUser.getGroups().add(groupToAssign);
        }
        this.userDAO.merge((Object)targetUser);
    }

    public void deassignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
        UserGroup groupToAssign = (UserGroup)this.userGroupDAO.find(Long.valueOf(groupId));
        if (!GroupReservedNames.isAllowedName((String)groupToAssign.getGroupName())) {
            throw new NotFoundServiceEx("You can't remove the group EVERYONE or any other reserved groups from the users group list...");
        }
        User targetUser = (User)this.userDAO.find(Long.valueOf(userId));
        if (groupToAssign == null || targetUser == null) {
            throw new NotFoundServiceEx("The userGroup or the user you provide doesn't exist");
        }
        if (targetUser.removeGroup(groupId)) {
            this.userDAO.merge((Object)targetUser);
        }
    }

    public List<UserGroup> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(UserGroup.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("groupName");
        List found = this.userGroupDAO.search((ISearch)searchCriteria);
        return this.remapWithoutAttributes(found);
    }

    public List<UserGroup> getAllAllowed(User user, Integer page, Integer entries, String nameLike, boolean all) throws BadRequestServiceEx {
        if (user == null) {
            throw new BadRequestServiceEx("User must be defined.");
        }
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(UserGroup.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("groupName");
        if (user.getRole() == Role.USER) {
            Set userGrp = user.getGroups();
            ArrayList<Long> grpIds = new ArrayList<Long>(userGrp.size());
            for (UserGroup grp : userGrp) {
                grpIds.add(grp.getId());
            }
            searchCriteria.addFilterIn("id", grpIds);
        }
        if (nameLike != null) {
            searchCriteria.addFilterILike("groupName", nameLike);
        }
        if (!all) {
            searchCriteria.addFilterNotEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        }
        List found = this.userGroupDAO.search((ISearch)searchCriteria);
        return this.remapWithoutAttributes(found);
    }

    public List<ShortResource> updateSecurityRules(Long groupId, List<Long> resourcesIds, boolean canRead, boolean canWrite) throws NotFoundServiceEx, BadRequestServiceEx {
        ArrayList<ShortResource> updated = new ArrayList<ShortResource>();
        UserGroup group = (UserGroup)this.userGroupDAO.find(groupId);
        if (group == null) {
            throw new NotFoundServiceEx("The usergroup id you provide doesn't exist!");
        }
        if (group.getGroupName().equals(GroupReservedNames.EVERYONE.groupName()) && (!canRead || canWrite)) {
            LOGGER.error("You are trying to assign to a resource the following permissions for the group EVERYONE: [canRead='" + canRead + "',canWrite'" + canWrite + "'] but...");
            LOGGER.error("...the group EVERYONE can be set only in this way: [canRead='true',canWrite='false'] .");
            throw new BadRequestServiceEx("GroupEveryone cannot be set with this grants [canRead='" + canRead + "',canWrite'" + canWrite + "']");
        }
        List resourceToSet = this.resourceDAO.findResources(resourcesIds);
        for (Resource resource : resourceToSet) {
            SecurityRule sr = this.getRuleForGroup(resource.getSecurity(), group);
            if (sr == null) {
                SecurityRule newSR = new SecurityRule();
                newSR.setCanRead(canRead);
                newSR.setCanWrite(canWrite);
                newSR.setGroup(group);
                newSR.setResource(resource);
                this.securityDAO.persist((Object[])new SecurityRule[]{newSR});
                resource.getSecurity().add(newSR);
                ShortResource out = new ShortResource(resource);
                out.setCanDelete(canWrite);
                out.setCanEdit(canWrite);
                updated.add(out);
                continue;
            }
            sr.setCanRead(canRead);
            sr.setCanWrite(canWrite);
            this.securityDAO.merge((Object)sr);
            ShortResource out = new ShortResource(resource);
            out.setCanDelete(canWrite);
            out.setCanEdit(canWrite);
            updated.add(out);
        }
        return updated;
    }

    private SecurityRule getRuleForGroup(List<SecurityRule> securityList, UserGroup group) {
        for (SecurityRule sr : securityList) {
            if (sr.getGroup() == null || sr.getGroup().getGroupName() == null || !sr.getGroup().getGroupName().equals(group.getGroupName())) continue;
            return sr;
        }
        return null;
    }

    public boolean insertSpecialUsersGroups() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Reserved UsersGroup... ");
        }
        UserGroup ug = new UserGroup();
        ug.setGroupName(GroupReservedNames.EVERYONE.groupName());
        this.userGroupDAO.persist((Object[])new UserGroup[]{ug});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Special UserGroup '" + ug.getGroupName() + "' persisted!");
        }
        return true;
    }

    public boolean removeSpecialUsersGroups() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removing Reserved UsersGroup... ");
        }
        Search search = new Search();
        search.addFilterEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        List ugEveryone = this.userGroupDAO.search((ISearch)search);
        if (ugEveryone.size() == 1) {
            UserGroup ug = (UserGroup)ugEveryone.get(0);
            boolean res = this.userGroupDAO.removeById(ug.getId());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Special UserGroup '" + ug.getGroupName() + "' removed!");
            }
            return res;
        }
        return false;
    }

    public UserGroup get(long id) throws BadRequestServiceEx {
        return (UserGroup)this.userGroupDAO.find(Long.valueOf(id));
    }

    public UserGroup get(String name) {
        return this.userGroupDAO.findByName(name);
    }

    public long getCount(User user, String nameLike, boolean all) throws BadRequestServiceEx {
        if (user == null) {
            throw new BadRequestServiceEx("User must be defined.");
        }
        Search searchCriteria = new Search(UserGroup.class);
        searchCriteria.addSortAsc("groupName");
        if (user.getRole() == Role.USER) {
            Set userGrp = user.getGroups();
            ArrayList<Long> grpIds = new ArrayList<Long>();
            for (UserGroup grp : userGrp) {
                grpIds.add(grp.getId());
            }
            searchCriteria.addFilterIn("id", grpIds);
        }
        if (nameLike != null) {
            searchCriteria.addFilterILike("groupName", nameLike);
        }
        if (!all) {
            searchCriteria.addFilterNotEqual("groupName", (Object)GroupReservedNames.EVERYONE.groupName());
        }
        return this.userGroupDAO.count((ISearch)searchCriteria);
    }

    public long getCount(User user, String nameLike) throws BadRequestServiceEx {
        return this.getCount(user, nameLike, false);
    }

    public void updateAttributes(long id, List<UserGroupAttribute> attributes) throws NotFoundServiceEx {
        UserGroup group = (UserGroup)this.userGroupDAO.find(Long.valueOf(id));
        if (group == null) {
            throw new NotFoundServiceEx("User not found " + id);
        }
        List oldList = group.getAttributes();
        if (oldList != null) {
            for (UserGroupAttribute a : oldList) {
                this.userGroupAttributeDAO.removeById(a.getId());
            }
        }
        for (UserGroupAttribute a : attributes) {
            a.setUserGroup(group);
            this.userGroupAttributeDAO.persist((Object[])new UserGroupAttribute[]{a});
        }
    }

    public long update(UserGroup group) throws NotFoundServiceEx, BadRequestServiceEx {
        UserGroup old = this.get(group.getId());
        if (old == null) {
            old = this.get(group.getGroupName());
        }
        group.setId(old.getId());
        this.userGroupDAO.merge((Object)group);
        return old.getId();
    }

    public Collection<UserGroup> findByAttribute(String name, List<String> values, boolean ignoreCase) {
        Search searchCriteria = new Search(UserGroupAttribute.class);
        if (!ignoreCase) {
            searchCriteria.addFilterEqual("name", (Object)name);
        } else {
            searchCriteria.addFilterILike("name", name);
        }
        if (values.size() > 1) {
            searchCriteria.addFilterIn("value", values);
        } else {
            searchCriteria.addFilterEqual("value", (Object)values.get(0));
        }
        searchCriteria.addFetch("userGroup");
        List attributes = this.userGroupAttributeDAO.search((ISearch)searchCriteria);
        return attributes.stream().map(a -> a.getUserGroup()).filter(u -> u != null).collect(Collectors.toSet());
    }

    private List<UserGroup> remapWithoutAttributes(Collection<UserGroup> groups) {
        ArrayList<UserGroup> newList = new ArrayList<UserGroup>(groups.size());
        for (UserGroup old : groups) {
            UserGroup newGroup = new UserGroup();
            newGroup.setId(old.getId());
            newGroup.setGroupName(old.getGroupName());
            newGroup.setDescription(old.getDescription());
            newGroup.setEnabled(old.isEnabled());
            newList.add(newGroup);
        }
        return newList;
    }
}

