/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.services.ServiceTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class StoredDataServiceImplTest
extends ServiceTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testInsertDeleteData() throws Exception {
        long resourceId = this.createResource("resource1", "description1", "MAP");
        long id = this.createData("data1", resourceService.get(resourceId));
        StoredDataServiceImplTest.assertTrue((String)"Could not delete data", (boolean)storedDataService.delete(id));
    }

    @Test
    public void testUpdateData() throws Exception {
        String DATA1 = "data1";
        String DATA2 = "data2";
        long id = this.createResource("resource1", "description1", "MAP");
        Resource loadedRes = resourceService.get(id);
        StoredDataServiceImplTest.assertNotNull((String)"Resource not found", (Object)loadedRes);
        StoredDataServiceImplTest.assertNull((String)("Last Update == " + loadedRes.getLastUpdate()), (Object)loadedRes.getLastUpdate());
        this.createData("data1", resourceService.get(id));
        loadedRes = resourceService.get(id);
        StoredDataServiceImplTest.assertNotNull((String)"Resource not found", (Object)loadedRes);
        StoredDataServiceImplTest.assertNotNull((Object)loadedRes.getLastUpdate());
        StoredData loadedData = storedDataService.get(id);
        StoredDataServiceImplTest.assertNotNull((Object)loadedData);
        StoredDataServiceImplTest.assertEquals((String)"data1", (String)loadedData.getData());
        loadedData.setData("data2");
        storedDataService.update(loadedData.getId().longValue(), loadedData.getData());
        StoredData loaded = storedDataService.get(id);
        StoredDataServiceImplTest.assertNotNull((String)"Data not found", (Object)loaded);
        StoredDataServiceImplTest.assertEquals((String)"data2", (String)loaded.getData());
        StoredDataServiceImplTest.assertTrue((String)"Could not delete data", (boolean)storedDataService.delete(id));
    }

    @Test
    public void testGetAllData() throws Exception {
        long resourceId;
        int i;
        StoredDataServiceImplTest.assertEquals((int)0, (int)storedDataService.getAll().size());
        for (i = 0; i < 10; ++i) {
            resourceId = this.createResource("resource" + i, "description" + i, "MAP" + i);
            this.createData("first_data" + i, resourceService.get(resourceId));
        }
        for (i = 11; i < 21; ++i) {
            resourceId = this.createResource("resource" + i, "description" + i, "MAP" + i);
            this.createData("second_data" + i, resourceService.get(resourceId));
        }
        StoredDataServiceImplTest.assertEquals((int)20, (int)storedDataService.getAll().size());
    }
}

