/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto.search;

import it.geosolutions.geostore.services.dto.search.FilterVisitor;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="CategoryFilter")
public class CategoryFilter
extends SearchFilter
implements Serializable {
    private String name;
    private SearchOperator operator;

    public CategoryFilter() {
    }

    public CategoryFilter(String name, SearchOperator operator) {
        this.name = name;
        this.setOperator(operator);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public final void setOperator(SearchOperator operator) {
        CategoryFilter.checkOperator(operator);
        this.operator = operator;
    }

    public static void checkOperator(SearchOperator operator) {
        if (operator != SearchOperator.EQUAL_TO && operator != SearchOperator.LIKE) {
            throw new IllegalArgumentException("Only EQUAL or LIKE operator are acceptable");
        }
    }

    @Override
    public void accept(FilterVisitor visitor) throws BadRequestServiceEx, InternalErrorServiceEx {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        builder.append(this.operator != null ? this.operator : "!op!");
        builder.append(' ');
        builder.append(this.name != null ? this.name : "!name!");
        builder.append(']');
        return builder.toString();
    }
}

