/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto.search;

import it.geosolutions.geostore.services.dto.search.AttributeFilter;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.FilterVisitor;
import it.geosolutions.geostore.services.dto.search.GroupFilter;
import it.geosolutions.geostore.services.dto.search.OrFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.TagFilter;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="AND")
public class AndFilter
extends SearchFilter {
    private static final long serialVersionUID = -4055325472578322312L;
    private List<SearchFilter> filters = new ArrayList<SearchFilter>();

    public AndFilter() {
    }

    public AndFilter(SearchFilter f1, SearchFilter f2, SearchFilter ... other) {
        this.filters.add(f1);
        this.filters.add(f2);
        this.filters.addAll(Arrays.asList(other));
    }

    @XmlElements(value={@XmlElement(name="ATTRIBUTE", type=AttributeFilter.class), @XmlElement(name="OR", type=OrFilter.class), @XmlElement(name="AND", type=AndFilter.class), @XmlElement(name="FIELD", type=FieldFilter.class), @XmlElement(name="CATEGORY", type=CategoryFilter.class), @XmlElement(name="GROUP", type=GroupFilter.class), @XmlElement(name="TAG", type=TagFilter.class)})
    public List<SearchFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SearchFilter> filters) {
        this.filters = filters;
    }

    public void add(SearchFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void accept(FilterVisitor visitor) throws BadRequestServiceEx, InternalErrorServiceEx {
        visitor.visit(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.filters + "]";
    }
}

