/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto.search;

import it.geosolutions.geostore.services.dto.search.FilterVisitor;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;

public abstract class AssociatedEntityFilter
extends SearchFilter
implements Serializable {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\"([^\"]*)\"|([^,]+)");
    private static final List<SearchOperator> VALID_OPERATORS = List.of(SearchOperator.EQUAL_TO, SearchOperator.LIKE, SearchOperator.ILIKE, SearchOperator.IN);
    private SearchOperator operator;
    private List<String> values;

    public AssociatedEntityFilter() {
    }

    public AssociatedEntityFilter(String names, SearchOperator operator) {
        this.setOperator(operator);
        this.setNames(names);
    }

    @XmlElement
    public void setNames(String names) {
        if (names == null) {
            throw new IllegalArgumentException("filter names should not be null");
        }
        this.values = this.operator == SearchOperator.IN ? NAMES_PATTERN.matcher(names).results().map(r -> r.group(1) != null ? r.group(1) : r.group(2)).collect(Collectors.toList()) : Collections.singletonList(names);
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperator operator) {
        this.operator = operator;
        this.checkOperator();
    }

    public List<String> values() {
        return this.values;
    }

    public abstract String property();

    @Override
    public void accept(FilterVisitor visitor) throws BadRequestServiceEx, InternalErrorServiceEx {
        this.checkOperator();
        visitor.visit(this);
    }

    private void checkOperator() {
        if (!VALID_OPERATORS.contains((Object)this.operator)) {
            throw new IllegalArgumentException("Only EQUAL_TO, LIKE, ILIKE, or IN operators are acceptable");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (Serializable)(this.operator != null ? this.operator : "!op!") + " " + (this.values != null ? this.values : "[!names!]") + "]";
    }
}

