/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.List;

public interface ResourceService
extends SecurityService {
    public long insert(Resource var1) throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx;

    public long update(Resource var1) throws NotFoundServiceEx, DuplicatedResourceNameServiceEx;

    public boolean delete(long var1);

    public void deleteResources(SearchFilter var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    public Resource get(long var1);

    public Resource getResource(long var1, boolean var3, boolean var4);

    public List<ShortResource> getList(ResourceSearchParameters var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    public List<ShortResource> getAll(ResourceSearchParameters var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    @Deprecated
    public long getCount(String var1);

    @Deprecated
    public long getCountByFilter(SearchFilter var1) throws InternalErrorServiceEx, BadRequestServiceEx;

    public void updateAttributes(long var1, List<Attribute> var3) throws NotFoundServiceEx;

    public List<ShortAttribute> getAttributes(long var1);

    public ShortAttribute getAttribute(long var1, String var3);

    public long updateAttribute(long var1, String var3, String var4) throws InternalErrorServiceEx;

    public List<Resource> getResources(ResourceSearchParameters var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    public List<ShortResource> getShortResources(ResourceSearchParameters var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    public List<Resource> getResourcesFull(ResourceSearchParameters var1) throws BadRequestServiceEx, InternalErrorServiceEx;

    public List<SecurityRule> getSecurityRules(long var1);

    public void updateSecurityRules(long var1, List<SecurityRule> var3) throws BadRequestServiceEx, InternalErrorServiceEx, NotFoundServiceEx;

    @Deprecated
    public long getCountByFilterAndUser(SearchFilter var1, User var2) throws BadRequestServiceEx, InternalErrorServiceEx;

    @Deprecated
    public long getCountByFilterAndUser(String var1, User var2) throws BadRequestServiceEx;

    public long insertAttribute(long var1, String var3, String var4, DataType var5) throws InternalErrorServiceEx;
}

