/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto.search;

import it.geosolutions.geostore.services.dto.search.FilterVisitor;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Group")
public class GroupFilter
extends SearchFilter
implements Serializable {
    private List<String> names = new ArrayList<String>();
    private SearchOperator operator;

    public GroupFilter() {
    }

    public GroupFilter(List<String> names, SearchOperator operator) {
        this.names = names;
        this.setOperator(operator);
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public final void setOperator(SearchOperator operator) {
        GroupFilter.checkOperator(operator);
        this.operator = operator;
    }

    public static void checkOperator(SearchOperator operator) {
        if (operator != SearchOperator.EQUAL_TO && operator != SearchOperator.LIKE && operator != SearchOperator.ILIKE && operator != SearchOperator.IN) {
            throw new IllegalArgumentException("Only EQUAL_TO, LIKE, ILIKE, or IN operators are acceptable");
        }
    }

    @Override
    public void accept(FilterVisitor visitor) throws BadRequestServiceEx, InternalErrorServiceEx {
        visitor.visit(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (Serializable)(this.operator != null ? this.operator : "!op!") + " " + (this.names != null ? this.names : "[!names!]") + "]";
    }
}

