/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.password;

import it.geosolutions.geostore.core.security.password.GeoStoreDigestPasswordEncoder;
import it.geosolutions.geostore.core.security.password.GeoStorePBEPasswordEncoder;
import it.geosolutions.geostore.core.security.password.KeyStoreProviderImpl;
import it.geosolutions.geostore.core.security.password.RandomPasswordProvider;
import it.geosolutions.geostore.core.security.password.URLMasterPasswordProvider;
import java.io.File;
import java.net.URL;
import javax.crypto.SecretKey;
import junit.framework.TestCase;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EncodingTest
extends TestCase {
    private static final String TEST_KEYSTORE_FILE_NAME = "geostore.jceks";
    private ClassPathXmlApplicationContext context;
    private char[] passwd;

    protected void setUp() throws Exception {
        super.setUp();
        String[] paths = new String[]{"classpath*:encoders-context-test.xml"};
        this.context = new ClassPathXmlApplicationContext(paths);
        URL url = ((Object)((Object)this)).getClass().getResource("/geostore.jceks");
        File f = new File(url.toURI());
        URL passFile = ((Object)((Object)this)).getClass().getResource("/passwd-test");
        URLMasterPasswordProvider pp = new URLMasterPasswordProvider();
        pp.setEncrypting(false);
        pp.setURL(passFile);
        this.passwd = pp.doGetMasterPassword();
        if (f.exists()) {
            KeyStoreProviderImpl ksp = (KeyStoreProviderImpl)this.context.getBean("keyStoreProvider");
            ksp.setKeyStoreFilePath(f.getAbsolutePath());
            ksp.setMasterPassword(this.passwd);
        }
    }

    @Test
    public void testPbe() throws Exception {
        GeoStorePBEPasswordEncoder pbePasswordEncoder = (GeoStorePBEPasswordEncoder)this.context.getBean("pbePasswordEncoder");
        KeyStoreProviderImpl p = (KeyStoreProviderImpl)this.context.getBean("keyStoreProvider");
        EncodingTest.assertTrue((boolean)p.isKeyStorePassword(this.passwd));
        this.performPbeTest(pbePasswordEncoder);
        URLMasterPasswordProvider pp = new URLMasterPasswordProvider();
        pp.setEncrypting(true);
        URL pwenc = ((Object)((Object)this)).getClass().getResource("/passwd-test-enc");
        pp.setURL(pwenc);
        this.performPbeTest(pbePasswordEncoder);
    }

    private void performPbeTest(GeoStorePBEPasswordEncoder pbePasswordEncoder) {
        String testPassword = "testpassword";
        EncodingTest.assertEquals((String)testPassword, (String)pbePasswordEncoder.decode("crypt1:XPTERjaoupiG27xO5w/PdmrlcVDWOPVo"));
        String encoded = pbePasswordEncoder.encodePassword("testpassword", null);
        EncodingTest.assertTrue((boolean)pbePasswordEncoder.isResponsibleForEncoding(encoded));
        EncodingTest.assertEquals((String)testPassword, (String)pbePasswordEncoder.decode(encoded));
        pbePasswordEncoder.isPasswordValid(encoded, testPassword, null);
    }

    @Test
    public void testDigest() throws Exception {
        GeoStoreDigestPasswordEncoder pe = (GeoStoreDigestPasswordEncoder)this.context.getBean("digestPasswordEncoder");
        String rawPass = "testPassword";
        String encPass = pe.encodePassword(rawPass, null);
        EncodingTest.assertTrue((boolean)pe.isResponsibleForEncoding(encPass));
        EncodingTest.assertTrue((boolean)pe.isPasswordValid(encPass, rawPass, null));
    }

    @Test
    public void testCreateKeyStore() throws Exception {
        File f = new File(TEST_KEYSTORE_FILE_NAME);
        if (f.exists()) {
            System.out.println("delete previous keystore");
            f.delete();
        }
        char[] passwd = new char[]{'t', 'e', 's', 't', 'p', 'w'};
        char[] passwd2 = new char[]{'g', 'e', 'o', 's', 't', 'o', 'r', 'e'};
        String keyName = "ug:geostore:key";
        String keyName2 = "keyName2";
        KeyStoreProviderImpl ksp = new KeyStoreProviderImpl();
        ksp.setKeyName(keyName);
        ksp.setKeyStoreFilePath("testStore");
        ksp.setMasterPassword(passwd);
        ksp.setSecretKey(keyName, "testkey".toCharArray());
        ksp.setSecretKey(keyName2, "testkey2".toCharArray());
        SecretKey k = ksp.getSecretKey(keyName);
        EncodingTest.assertTrue((boolean)ksp.containsAlias(keyName));
        EncodingTest.assertTrue((boolean)ksp.containsAlias(keyName));
        ksp.removeKey(keyName2);
        EncodingTest.assertFalse((boolean)ksp.containsAlias(keyName2));
        ksp = new KeyStoreProviderImpl();
        ksp.setKeyName(keyName);
        ksp.setMasterPassword(passwd2);
        ksp.setKeyStoreFilePath(TEST_KEYSTORE_FILE_NAME);
        ksp.setSecretKey(keyName, new RandomPasswordProvider().getRandomPasswordWithDefaultLength());
        System.out.print(ksp.keyStoreFile.getAbsolutePath());
    }

    protected void tearDown() throws Exception {
        File f = new File(TEST_KEYSTORE_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
        super.tearDown();
    }
}

