/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security;

import it.geosolutions.geostore.core.security.SimpleGrantedAuthoritiesMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class SimpleGrantedAuthoritiesMapperTest {
    SimpleGrantedAuthoritiesMapper mapper;
    private Map<String, String> roleMappings;
    List<GrantedAuthority> authorities;

    @Before
    public void setUp() {
        this.roleMappings = new HashMap<String, String>();
        this.mapper = new SimpleGrantedAuthoritiesMapper(this.roleMappings);
        this.authorities = new ArrayList<GrantedAuthority>();
    }

    @Test
    public void testMapping() {
        this.roleMappings.put("A", "B");
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority("A"));
        Collection mapped = this.mapper.mapAuthorities(this.authorities);
        Assert.assertEquals((long)1L, (long)mapped.size());
        Assert.assertEquals((Object)"B", (Object)((GrantedAuthority)mapped.iterator().next()).getAuthority());
    }

    @Test
    public void testDropUnmappedAuthiorities() {
        this.mapper.setDropUnmapped(true);
        this.roleMappings.put("A", "B");
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority("A"));
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority("C"));
        Collection mapped = this.mapper.mapAuthorities(this.authorities);
        Assert.assertEquals((long)1L, (long)mapped.size());
        Assert.assertEquals((Object)"B", (Object)((GrantedAuthority)mapped.iterator().next()).getAuthority());
    }
}

