/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.password;

import it.geosolutions.geostore.core.security.password.MasterPasswordProvider;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;

public final class URLMasterPasswordProvider
implements MasterPasswordProvider {
    private URL URL;
    private String configDirPath = ".";
    private boolean encrypting = true;
    static final char[] BASE = new char[]{'U', 'n', '6', 'd', 'I', 'l', 'X', 'T', 'Q', 'c', 'L', ')', '$', '#', 'q', 'J', 'U', 'l', 'X', 'Q', 'U', '!', 'n', 'n', 'p', '%', 'U', 'r', '5', 'U', 'u', '3', '5', 'H', '`', 'x', 'P', 'F', 'r', 'X'};
    static final int[] PERM = new int[]{32, 19, 30, 11, 34, 26, 3, 21, 9, 37, 38, 13, 23, 2, 18, 4, 20, 1, 29, 17, 0, 31, 14, 36, 12, 24, 15, 35, 16, 39, 25, 5, 10, 8, 7, 6, 33, 27, 28, 22};

    public void setEncrypting(boolean encrypting) {
        this.encrypting = encrypting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] encode(char[] passwd) {
        if (!this.isEncrypting()) {
            return SecurityUtils.toBytes(passwd);
        }
        StandardPBEByteEncryptor encryptor = new StandardPBEByteEncryptor();
        char[] key = this.key();
        try {
            encryptor.setPasswordCharArray(key);
            byte[] byArray = Base64.encodeBase64((byte[])encryptor.encrypt(SecurityUtils.toBytes(passwd)));
            return byArray;
        }
        finally {
            SecurityUtils.scramble(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] decode(byte[] passwd) {
        if (!this.isEncrypting()) {
            return passwd;
        }
        StandardPBEByteEncryptor encryptor = new StandardPBEByteEncryptor();
        char[] key = this.key();
        try {
            encryptor.setPasswordCharArray(key);
            byte[] byArray = encryptor.decrypt(Base64.decodeBase64((byte[])passwd));
            return byArray;
        }
        finally {
            SecurityUtils.scramble(key);
        }
    }

    char[] key() {
        return SecurityUtils.permute(BASE, 32, PERM);
    }

    @Override
    public char[] doGetMasterPassword() throws Exception {
        char[] cArray;
        InputStream in = URLMasterPasswordProvider.input(this.getURL(), this.getConfigDir());
        try {
            cArray = SecurityUtils.toChars(this.decode(IOUtils.toByteArray((InputStream)in)));
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return cArray;
    }

    @Override
    public void doSetMasterPassword(char[] passwd) throws Exception {
        try (OutputStream out = URLMasterPasswordProvider.output(this.getURL(), this.getConfigDir());){
            out.write(this.encode(passwd));
        }
    }

    File getConfigDir() throws IOException {
        return new File(this.configDirPath);
    }

    static OutputStream output(URL url, File configDir) throws IOException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            if (!f.isAbsolute()) {
                f = new File(configDir, f.getPath());
            }
            return new FileOutputStream(f);
        }
        URLConnection cx = url.openConnection();
        cx.setDoOutput(true);
        return cx.getOutputStream();
    }

    static InputStream input(URL url, File configDir) throws IOException {
        if (url == null) {
            url = URLMasterPasswordProvider.class.getClassLoader().getResource("passwd");
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            if (!f.isAbsolute()) {
                f = new File(configDir, f.getPath());
            }
            return new FileInputStream(f);
        }
        return url.openStream();
    }

    public String getConfigDirPath() {
        return this.configDirPath;
    }

    public void setConfigDirPath(String path) {
        this.configDirPath = path;
    }

    public URL getURL() {
        return this.URL;
    }

    public void setURL(URL url) {
        this.URL = url;
    }

    private boolean isEncrypting() {
        return this.encrypting;
    }
}

