/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.password;

import it.geosolutions.geostore.core.security.password.KeyStoreProvider;
import it.geosolutions.geostore.core.security.password.MasterPasswordProvider;
import it.geosolutions.geostore.core.security.password.RandomPasswordProvider;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;

public class KeyStoreProviderImpl
implements BeanNameAware,
KeyStoreProvider {
    private static final Logger LOGGER = LogManager.getLogger(KeyStoreProviderImpl.class);
    public static final String DEFAULT_BEAN_NAME = "DefaultKeyStoreProvider";
    public static final String DEFAULT_FILE_NAME = "geostore.jceks";
    public static final String PREPARED_FILE_NAME = "geostore.jceks.new";
    public static final String CONFIGPASSWORDKEY = "ug:geostore:key";
    public static final String USERGROUP_PREFIX = "ug:";
    public static final String USERGROUP_POSTFIX = ":key";
    private String keyStoreFilePath = null;
    protected String name;
    protected File keyStoreFile;
    protected KeyStore ks;
    private char[] masterPassword;
    private String keyName;
    private MasterPasswordProvider masterPasswordProvider;
    public static final String KEYSTORETYPE = "JCEKS";

    public MasterPasswordProvider getMasterPasswordProvider() {
        return this.masterPasswordProvider;
    }

    public void setMasterPasswordProvider(MasterPasswordProvider masterPasswordProvider) {
        this.masterPasswordProvider = masterPasswordProvider;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setMasterPassword(char[] masterPassword) {
        this.masterPassword = masterPassword;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    @Override
    public File getFile() {
        if (this.keyStoreFile == null) {
            if (this.getKeyStoreFilePath() != null) {
                this.keyStoreFile = new File(this.getKeyStoreFilePath());
                if (this.keyStoreFile != null && !this.keyStoreFile.exists()) {
                    if (this.keyStoreFile.isDirectory()) {
                        this.keyStoreFile = new File(this.getKeyStoreFilePath() + DEFAULT_FILE_NAME);
                    }
                    LOGGER.warn("the keyStore file doesn't exist. confiure a new one");
                }
            } else {
                URL defaultKeyStrore = KeyStoreProviderImpl.class.getClassLoader().getResource(DEFAULT_FILE_NAME);
                try {
                    if (defaultKeyStrore != null) {
                        this.keyStoreFile = new File(defaultKeyStrore.toURI());
                    }
                }
                catch (URISyntaxException e) {
                    LOGGER.error("UNABLE TO GET THE DEFAULT KEY STORE");
                }
            }
        }
        return this.keyStoreFile;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    @Override
    public void reloadKeyStore() throws IOException {
        this.ks = null;
        this.assertActivatedKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getKey(String alias) throws IOException {
        this.assertActivatedKeyStore();
        char[] passwd = this.getMasterPassword();
        try {
            Key key = this.ks.getKey(alias, passwd);
            this.disposePassword(passwd);
            return key;
        }
        catch (Throwable throwable) {
            try {
                this.disposePassword(passwd);
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private char[] getMasterPassword() {
        if (this.masterPassword != null) {
            return this.masterPassword;
        }
        if (this.masterPasswordProvider != null) {
            try {
                this.masterPassword = this.masterPasswordProvider.doGetMasterPassword();
            }
            catch (Exception e) {
                LOGGER.error("unable to read the master password\n:" + e.getStackTrace());
            }
        }
        return this.masterPassword;
    }

    @Override
    public Enumeration<String> aliases() {
        if (this.ks != null) {
            try {
                return this.ks.aliases();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public byte[] getConfigPasswordKey() throws IOException {
        SecretKey key = this.getSecretKey(CONFIGPASSWORDKEY);
        if (key == null) {
            return null;
        }
        return key.getEncoded();
    }

    @Override
    public boolean hasConfigPasswordKey() throws IOException {
        return this.containsAlias(CONFIGPASSWORDKEY);
    }

    @Override
    public boolean containsAlias(String alias) throws IOException {
        this.assertActivatedKeyStore();
        try {
            return this.ks.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] getUserGroupKey(String serviceName) throws IOException {
        SecretKey key = this.getSecretKey(this.aliasForGroupService(serviceName));
        if (key == null) {
            return null;
        }
        return key.getEncoded();
    }

    @Override
    public boolean hasUserGroupKey(String serviceName) throws IOException {
        return this.containsAlias(this.aliasForGroupService(serviceName));
    }

    @Override
    public SecretKey getSecretKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof SecretKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (SecretKey)key;
    }

    @Override
    public PublicKey getPublicKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof PublicKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (PublicKey)key;
    }

    @Override
    public PrivateKey getPrivateKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof PrivateKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (PrivateKey)key;
    }

    @Override
    public String aliasForGroupService(String serviceName) {
        StringBuffer buff = new StringBuffer(USERGROUP_PREFIX);
        buff.append(serviceName);
        buff.append(USERGROUP_POSTFIX);
        return buff.toString();
    }

    protected void assertActivatedKeyStore() throws IOException {
        block18: {
            if (this.ks != null) {
                return;
            }
            char[] passwd = this.getMasterPassword();
            try {
                this.ks = KeyStore.getInstance(KEYSTORETYPE);
                if (!this.getFile().exists()) {
                    this.ks.load(null, passwd);
                    this.addInitialKeys();
                    try (FileOutputStream fos = new FileOutputStream(this.getFile());){
                        this.ks.store(fos, passwd);
                        break block18;
                    }
                }
                try (FileInputStream fis = new FileInputStream(this.getFile());){
                    this.ks.load(fis, passwd);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new IOException(ex);
            }
            finally {
                this.disposePassword(passwd);
            }
        }
    }

    private void disposePassword(char[] passwd) {
    }

    @Override
    public boolean isKeyStorePassword(char[] password) throws IOException {
        if (password == null) {
            return false;
        }
        this.assertActivatedKeyStore();
        KeyStore testStore = null;
        try {
            testStore = KeyStore.getInstance(KEYSTORETYPE);
        }
        catch (KeyStoreException e1) {
            throw new RuntimeException(e1);
        }
        try (FileInputStream fis = new FileInputStream(this.getFile());){
            try {
                testStore.load(fis, password);
            }
            catch (IOException e2) {
                boolean bl = false;
                fis.close();
                return bl;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public void setSecretKey(String alias, char[] key) throws IOException {
        this.assertActivatedKeyStore();
        SecretKeySpec mySecretKey = new SecretKeySpec(SecurityUtils.toBytes(key), "PBE");
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(mySecretKey);
        char[] passwd = this.getMasterPassword();
        try {
            this.ks.setEntry(alias, skEntry, new KeyStore.PasswordProtection(passwd));
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        finally {
            this.disposePassword(passwd);
        }
    }

    @Override
    public void setUserGroupKey(String serviceName, char[] password) throws IOException {
        String alias = this.aliasForGroupService(serviceName);
        this.setSecretKey(alias, password);
    }

    @Override
    public void removeKey(String alias) throws IOException {
        this.assertActivatedKeyStore();
        try {
            this.ks.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeKeyStore() throws IOException {
        this.assertActivatedKeyStore();
        try (FileOutputStream fos = new FileOutputStream(this.getFile());){
            char[] passwd = this.getMasterPassword();
            try {
                this.ks.store(fos, passwd);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.disposePassword(passwd);
            }
        }
    }

    protected void addInitialKeys() throws IOException {
        RandomPasswordProvider randPasswdProvider = this.getRandomPassworddProvider();
        char[] configKey = randPasswdProvider.getRandomPasswordWithDefaultLength();
        this.setSecretKey(CONFIGPASSWORDKEY, configKey);
    }

    private RandomPasswordProvider getRandomPassworddProvider() {
        return new RandomPasswordProvider();
    }

    @Override
    public void prepareForMasterPasswordChange(char[] oldPassword, char[] newPassword) throws IOException {
        File dir = this.getFile().getParentFile();
        File newKSFile = new File(dir, PREPARED_FILE_NAME);
        if (newKSFile.exists()) {
            newKSFile.delete();
        }
        try {
            KeyStore oldKS = KeyStore.getInstance(KEYSTORETYPE);
            try (FileInputStream fin = new FileInputStream(this.getFile());){
                oldKS.load(fin, oldPassword);
            }
            KeyStore newKS = KeyStore.getInstance(KEYSTORETYPE);
            newKS.load(null, newPassword);
            KeyStore.PasswordProtection protectionparam = new KeyStore.PasswordProtection(newPassword);
            Enumeration<String> enumeration = oldKS.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                Key key = oldKS.getKey(alias, oldPassword);
                KeyStore.Entry entry = null;
                if (key instanceof SecretKey) {
                    entry = new KeyStore.SecretKeyEntry((SecretKey)key);
                }
                if (key instanceof PrivateKey) {
                    entry = new KeyStore.PrivateKeyEntry((PrivateKey)key, oldKS.getCertificateChain(alias));
                }
                if (key instanceof PublicKey) {
                    entry = new KeyStore.TrustedCertificateEntry(oldKS.getCertificate(alias));
                }
                if (entry == null) {
                    LOGGER.warn("Unknown key in store, alias: " + alias + " class: " + key.getClass().getName());
                    continue;
                }
                newKS.setEntry(alias, entry, protectionparam);
            }
            try (FileOutputStream fos = new FileOutputStream(newKSFile);){
                newKS.store(fos, newPassword);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void abortMasterPasswordChange() {
        File dir = this.getFile().getParentFile();
        File newKSFile = new File(dir, PREPARED_FILE_NAME);
        if (newKSFile.exists()) {
            try {
                newKSFile.delete();
            }
            catch (Exception e) {
                LOGGER.error("UNABLE TO DELETE THE MASTERPWD FILE");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commitMasterPasswordChange() throws IOException {
        File dir = this.getFile().getParentFile();
        File newKSFile = new File(dir, PREPARED_FILE_NAME);
        File oldKSFile = new File(dir, DEFAULT_FILE_NAME);
        if (!newKSFile.exists()) {
            return;
        }
        if (!oldKSFile.exists()) {
            return;
        }
        try (FileInputStream fin = new FileInputStream(newKSFile);){
            char[] passwd = this.getMasterPassword();
            try {
                KeyStore newKS = KeyStore.getInstance(KEYSTORETYPE);
                newKS.load(fin, passwd);
                Enumeration<String> enumeration = newKS.aliases();
                while (enumeration.hasMoreElements()) {
                    newKS.getKey(enumeration.nextElement(), passwd);
                }
                if (!oldKSFile.delete()) {
                    LOGGER.error("cannot delete " + this.getFile().getCanonicalPath());
                    return;
                }
                if (!newKSFile.renameTo(oldKSFile)) {
                    String msg = "cannot rename " + newKSFile.getCanonicalPath();
                    msg = msg + "to " + oldKSFile.getCanonicalPath();
                    msg = msg + "Try to rename manually and restart";
                    LOGGER.error(msg);
                    return;
                }
                this.reloadKeyStore();
                LOGGER.info("Successfully changed master password");
                return;
            }
            catch (IOException e) {
                String msg = "Error creating new keystore: " + newKSFile.getCanonicalPath();
                LOGGER.warn(msg, (Throwable)e);
                throw e;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.disposePassword(passwd);
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

