/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.password;

import it.geosolutions.geostore.core.security.password.AbstractGeoStorePasswordEncoder;
import it.geosolutions.geostore.core.security.password.KeyStoreProvider;
import it.geosolutions.geostore.core.security.password.PasswordEncodingType;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.jasypt.acegisecurity.PBEPasswordEncoder;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class GeoStorePBEPasswordEncoder
extends AbstractGeoStorePasswordEncoder {
    StandardPBEStringEncryptor stringEncrypter;
    StandardPBEByteEncryptor byteEncrypter;
    private String providerName;
    private String algorithm;
    private String keyAliasInKeyStore = "ug:geostore:key";
    private KeyStoreProvider keystoreProvider;

    public KeyStoreProvider getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public void setKeystoreProvider(KeyStoreProvider keystoreProvider) {
        this.keystoreProvider = keystoreProvider;
    }

    public void setKeyAliasInKeyStore(String keyAliasInKeyStore) {
        this.keyAliasInKeyStore = keyAliasInKeyStore;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyAliasInKeyStore() {
        return this.keyAliasInKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PasswordEncoder createStringEncoder() {
        byte[] password = this.lookupPasswordFromKeyStore();
        char[] chars = SecurityUtils.toChars(password);
        try {
            this.stringEncrypter = new StandardPBEStringEncryptor();
            this.stringEncrypter.setPasswordCharArray(chars);
            if (this.getProviderName() != null && !this.getProviderName().isEmpty()) {
                this.stringEncrypter.setProviderName(this.getProviderName());
            }
            this.stringEncrypter.setAlgorithm(this.getAlgorithm());
            PBEPasswordEncoder encoder = new PBEPasswordEncoder();
            encoder.setPbeStringEncryptor((PBEStringEncryptor)this.stringEncrypter);
            PBEPasswordEncoder pBEPasswordEncoder = encoder;
            return pBEPasswordEncoder;
        }
        finally {
            SecurityUtils.scramble(password);
            SecurityUtils.scramble(chars);
        }
    }

    @Override
    protected AbstractGeoStorePasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        byte[] password = this.lookupPasswordFromKeyStore();
        char[] chars = SecurityUtils.toChars(password);
        this.byteEncrypter = new StandardPBEByteEncryptor();
        this.byteEncrypter.setPasswordCharArray(chars);
        if (this.getProviderName() != null && !this.getProviderName().isEmpty()) {
            this.byteEncrypter.setProviderName(this.getProviderName());
        }
        this.byteEncrypter.setAlgorithm(this.getAlgorithm());
        return new AbstractGeoStorePasswordEncoder.CharArrayPasswordEncoder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                byte[] decoded = Base64.getDecoder().decode(encPass.getBytes());
                byte[] decrypted = GeoStorePBEPasswordEncoder.this.byteEncrypter.decrypt(decoded);
                char[] chars = SecurityUtils.toChars(decrypted);
                try {
                    boolean bl = Arrays.equals(chars, rawPass);
                    return bl;
                }
                finally {
                    SecurityUtils.scramble(decrypted);
                    SecurityUtils.scramble(chars);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                byte[] bytes = SecurityUtils.toBytes(rawPass);
                try {
                    String string = new String(Base64.getEncoder().encode(GeoStorePBEPasswordEncoder.this.byteEncrypter.encrypt(bytes)));
                    return string;
                }
                finally {
                    SecurityUtils.scramble(bytes);
                }
            }
        };
    }

    byte[] lookupPasswordFromKeyStore() {
        try {
            if (!this.keystoreProvider.containsAlias(this.getKeyAliasInKeyStore())) {
                throw new RuntimeException("Keystore: " + this.keystoreProvider.getFile() + " does not contain alias: " + this.getKeyAliasInKeyStore());
            }
            return this.keystoreProvider.getSecretKey(this.getKeyAliasInKeyStore()).getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find alias: " + this.getKeyAliasInKeyStore() + " in " + this.keystoreProvider.getFile().getAbsolutePath());
        }
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.ENCRYPT;
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        if (this.stringEncrypter == null) {
            this.getStringEncoder();
        }
        return this.stringEncrypter.decrypt(this.removePrefix(encPass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        if (this.byteEncrypter == null) {
            this.getCharEncoder();
        }
        byte[] decoded = Base64.getDecoder().decode(this.removePrefix(encPass).getBytes());
        byte[] bytes = this.byteEncrypter.decrypt(decoded);
        try {
            char[] cArray = SecurityUtils.toChars(bytes);
            return cArray;
        }
        finally {
            SecurityUtils.scramble(bytes);
        }
    }
}

