/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreAuthenticationConverter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;

public class GeoStoreAccessTokenConverter
extends DefaultAccessTokenConverter {
    public static String ACCESS_TOKEN_CHECK_KEY = "oauth2.AccessTokenCheckResponse";
    protected static Logger LOGGER = LogManager.getLogger(GeoStoreAccessTokenConverter.class);
    protected UserAuthenticationConverter userTokenConverter;

    public GeoStoreAccessTokenConverter() {
        this("email");
    }

    public GeoStoreAccessTokenConverter(String usernameKey) {
        GeoStoreAuthenticationConverter defaultUserAuthConverter = new GeoStoreAuthenticationConverter(usernameKey);
        this.setUserTokenConverter((UserAuthenticationConverter)defaultUserAuthConverter);
    }

    public final void setUserTokenConverter(UserAuthenticationConverter userTokenConverter) {
        this.userTokenConverter = userTokenConverter;
        super.setUserTokenConverter(userTokenConverter);
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        LOGGER.info("OAuth2Authentication extractAuthentication from {}", map);
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set<String> scope = this.parseScopes(map);
        Authentication user = this.userTokenConverter.extractAuthentication(map);
        LOGGER.info("User: {}", (Object)user);
        String clientId = (String)map.get("client_id");
        parameters.put("client_id", clientId);
        HashMap<String, Serializable> extensionParameters = new HashMap<String, Serializable>();
        try {
            extensionParameters.put(ACCESS_TOKEN_CHECK_KEY, (Serializable)((Object)map));
        }
        catch (Exception e) {
            LOGGER.info("Exception while trying to record the access token check info", (Throwable)e);
        }
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>(this.getAud(map));
        LOGGER.info("ResourceIds: {}", resourceIds);
        OAuth2Request request = new OAuth2Request(parameters, clientId, null, true, scope, resourceIds, null, null, extensionParameters);
        return new OAuth2Authentication(request, user);
    }

    private Collection<String> getAud(Map<String, ?> map) {
        if (!map.containsKey("aud")) {
            return Collections.emptySet();
        }
        Object aud = map.get("aud");
        if (aud instanceof Collection) {
            return (Collection)aud;
        }
        return Collections.singletonList(String.valueOf(aud));
    }

    private Set<String> parseScopes(Map<String, ?> map) {
        String scopeAsObject = map.containsKey("scope") ? map.get("scope") : "";
        LinkedHashSet<String> scope = new LinkedHashSet<String>();
        if (String.class.isAssignableFrom(scopeAsObject.getClass())) {
            String scopeAsString = scopeAsObject;
            Collections.addAll(scope, scopeAsString.split(" "));
        } else if (Collection.class.isAssignableFrom(scopeAsObject.getClass())) {
            Collection scopes = (Collection)((Object)scopeAsObject);
            scope.addAll(scopes);
        }
        return scope;
    }
}

