/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.impl.RESTSessionServiceImpl;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleOAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleSessionServiceDelegate;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OAuth2SessionServiceTest {
    private static final String ID_TOKEN = "test.id.token";
    private static final String ACCESS_TOKEN = "access_token";

    @Before
    public void setup() {
        SecurityContextHolder.clearContext();
        RequestContextHolder.resetRequestAttributes();
    }

    @After
    public void tearDown() {
        SecurityContextHolder.clearContext();
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testLogout_withParamBearer_revokesAndClearsSessionAndCache() {
        GoogleOAuth2Configuration configuration = new GoogleOAuth2Configuration();
        configuration.setEnabled(true);
        configuration.setIdTokenUri("https://www.googleapis.com/oauth2/v3/certs");
        configuration.setRevokeEndpoint("http://google.foo/revoke");
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(ACCESS_TOKEN);
        TokenDetails details = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)details.getProvider()).thenReturn((Object)"google");
        Mockito.when((Object)details.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)details.getIdToken()).thenReturn((Object)ID_TOKEN);
        authenticationToken.setDetails((Object)details);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        OAuth2RestTemplate restTemplate = (OAuth2RestTemplate)Mockito.mock(OAuth2RestTemplate.class);
        Mockito.when((Object)restTemplate.getOAuth2ClientContext()).thenReturn((Object)new DefaultOAuth2ClientContext());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        HashMap<String, GoogleOAuth2Configuration> configurations = new HashMap<String, GoogleOAuth2Configuration>();
        configurations.put("googleOAuth2Config", configuration);
        try (MockedStatic ctx = Mockito.mockStatic(GeoStoreContext.class);){
            ctx.when(() -> GeoStoreContext.beans(OAuth2Configuration.class)).thenReturn(configurations);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOAuth2Config", OAuth2Configuration.class)).thenReturn((Object)configuration);
            ctx.when(() -> GeoStoreContext.bean((String)"oAuth2Cache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOpenIdRestTemplate", OAuth2RestTemplate.class)).thenReturn((Object)restTemplate);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setParameter(ACCESS_TOKEN, ACCESS_TOKEN);
            request.setUserPrincipal((Principal)authenticationToken);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"google", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new GoogleSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertNull((String)"SecurityContext should be cleared", (Object)SecurityContextHolder.getContext().getAuthentication());
            Assert.assertNull((String)"request principal should be cleared", (Object)request.getUserPrincipal());
            Assert.assertNull((String)"token should be evicted from cache", (Object)cache.get(ACCESS_TOKEN));
        }
    }

    @Test
    public void testLogout_withAuthorizationHeader_picksTokenAndClears() {
        GoogleOAuth2Configuration configuration = new GoogleOAuth2Configuration();
        configuration.setEnabled(true);
        configuration.setRevokeEndpoint("http://google.foo/revoke");
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(ACCESS_TOKEN);
        TokenDetails details = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)details.getProvider()).thenReturn((Object)"google");
        Mockito.when((Object)details.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)details.getIdToken()).thenReturn((Object)ID_TOKEN);
        authenticationToken.setDetails((Object)details);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        OAuth2RestTemplate restTemplate = (OAuth2RestTemplate)Mockito.mock(OAuth2RestTemplate.class);
        Mockito.when((Object)restTemplate.getOAuth2ClientContext()).thenReturn((Object)new DefaultOAuth2ClientContext());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        HashMap<String, GoogleOAuth2Configuration> configurations = new HashMap<String, GoogleOAuth2Configuration>();
        configurations.put("googleOAuth2Config", configuration);
        try (MockedStatic ctx = Mockito.mockStatic(GeoStoreContext.class);){
            ctx.when(() -> GeoStoreContext.beans(OAuth2Configuration.class)).thenReturn(configurations);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOAuth2Config", OAuth2Configuration.class)).thenReturn((Object)configuration);
            ctx.when(() -> GeoStoreContext.bean((String)"oAuth2Cache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOpenIdRestTemplate", OAuth2RestTemplate.class)).thenReturn((Object)restTemplate);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("Authorization", (Object)"Bearer access_token");
            request.setUserPrincipal((Principal)authenticationToken);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"google", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new GoogleSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            Assert.assertNull((Object)request.getUserPrincipal());
            Assert.assertNull((Object)cache.get(ACCESS_TOKEN));
        }
    }

    @Test
    public void testLogout_noRevokeEndpoint_stillClearsLocally() {
        GoogleOAuth2Configuration configuration = new GoogleOAuth2Configuration();
        configuration.setEnabled(true);
        configuration.setRevokeEndpoint(null);
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(ACCESS_TOKEN);
        TokenDetails details = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)details.getProvider()).thenReturn((Object)"google");
        Mockito.when((Object)details.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)details.getIdToken()).thenReturn((Object)ID_TOKEN);
        authenticationToken.setDetails((Object)details);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        OAuth2RestTemplate restTemplate = (OAuth2RestTemplate)Mockito.mock(OAuth2RestTemplate.class);
        Mockito.when((Object)restTemplate.getOAuth2ClientContext()).thenReturn((Object)new DefaultOAuth2ClientContext());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        HashMap<String, GoogleOAuth2Configuration> configurations = new HashMap<String, GoogleOAuth2Configuration>();
        configurations.put("googleOAuth2Config", configuration);
        try (MockedStatic ctx = Mockito.mockStatic(GeoStoreContext.class);){
            ctx.when(() -> GeoStoreContext.beans(OAuth2Configuration.class)).thenReturn(configurations);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOAuth2Config", OAuth2Configuration.class)).thenReturn((Object)configuration);
            ctx.when(() -> GeoStoreContext.bean((String)"oAuth2Cache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOpenIdRestTemplate", OAuth2RestTemplate.class)).thenReturn((Object)restTemplate);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setParameter(ACCESS_TOKEN, ACCESS_TOKEN);
            request.setUserPrincipal((Principal)authenticationToken);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"google", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new GoogleSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            Assert.assertNull((Object)request.getUserPrincipal());
            Assert.assertNull((String)"cache entry should still be removed locally", (Object)cache.get(ACCESS_TOKEN));
        }
    }

    @Test
    public void testLogout_providerMismatch_keepsOtherProvidersCache() {
        GoogleOAuth2Configuration configuration = new GoogleOAuth2Configuration();
        configuration.setEnabled(true);
        configuration.setRevokeEndpoint("http://google.foo/revoke");
        PreAuthenticatedAuthenticationToken googleAuth = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        TokenDetails googleDetails = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)googleDetails.getProvider()).thenReturn((Object)"google");
        Mockito.when((Object)googleDetails.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("tokenA"));
        Mockito.when((Object)googleDetails.getIdToken()).thenReturn((Object)ID_TOKEN);
        googleAuth.setDetails((Object)googleDetails);
        PreAuthenticatedAuthenticationToken azureAuth = new PreAuthenticatedAuthenticationToken((Object)"user2", (Object)"", new ArrayList());
        TokenDetails azureDetails = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)azureDetails.getProvider()).thenReturn((Object)"azure");
        Mockito.when((Object)azureDetails.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("tokenB"));
        Mockito.when((Object)azureDetails.getIdToken()).thenReturn((Object)ID_TOKEN);
        azureAuth.setDetails((Object)azureDetails);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry("tokenA", (Authentication)googleAuth);
        cache.putCacheEntry("tokenB", (Authentication)azureAuth);
        OAuth2RestTemplate restTemplate = (OAuth2RestTemplate)Mockito.mock(OAuth2RestTemplate.class);
        Mockito.when((Object)restTemplate.getOAuth2ClientContext()).thenReturn((Object)new DefaultOAuth2ClientContext());
        SecurityContextHolder.getContext().setAuthentication((Authentication)googleAuth);
        HashMap<String, GoogleOAuth2Configuration> configurations = new HashMap<String, GoogleOAuth2Configuration>();
        configurations.put("googleOAuth2Config", configuration);
        try (MockedStatic ctx = Mockito.mockStatic(GeoStoreContext.class);){
            ctx.when(() -> GeoStoreContext.beans(OAuth2Configuration.class)).thenReturn(configurations);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOAuth2Config", OAuth2Configuration.class)).thenReturn((Object)configuration);
            ctx.when(() -> GeoStoreContext.bean((String)"oAuth2Cache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            ctx.when(() -> GeoStoreContext.bean((String)"googleOpenIdRestTemplate", OAuth2RestTemplate.class)).thenReturn((Object)restTemplate);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setParameter(ACCESS_TOKEN, "tokenA");
            request.setUserPrincipal((Principal)googleAuth);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"google", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new GoogleSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertNull((String)"google entry evicted", (Object)cache.get("tokenA"));
            Assert.assertNotNull((String)"azure entry untouched", (Object)cache.get("tokenB"));
        }
    }
}

