/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTUserService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTUser;
import it.geosolutions.geostore.services.rest.model.UserList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTUserServiceImpl
extends RESTServiceImpl
implements RESTUserService {
    private static final Logger LOGGER = LogManager.getLogger(RESTUserServiceImpl.class);
    private UserService userService;

    @Override
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public long insert(SecurityContext sc, User user) {
        if (user == null) {
            throw new BadRequestWebEx("User is null");
        }
        if (user.getId() != null) {
            throw new BadRequestWebEx("Id should be null");
        }
        long id = -1L;
        try {
            List usAttribute = user.getAttribute();
            if (usAttribute != null) {
                user.setAttribute(null);
            }
            id = this.userService.insert(user);
            if (usAttribute != null) {
                this.userService.updateAttributes(id, usAttribute);
            }
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
        return id;
    }

    public long update(SecurityContext sc, long id, User user) {
        try {
            String npw;
            User authUser = this.extractAuthUser(sc);
            User old = this.userService.get(id);
            if (old == null) {
                throw new NotFoundWebEx("User not found");
            }
            boolean userUpdated = false;
            if (authUser.getRole().equals((Object)Role.ADMIN)) {
                Set groups;
                npw = user.getNewPassword();
                if (npw != null && !npw.isEmpty()) {
                    old.setNewPassword(user.getNewPassword());
                    userUpdated = true;
                } else {
                    old.setNewPassword(null);
                }
                Role nr = user.getRole();
                if (nr != null) {
                    old.setRole(nr);
                    userUpdated = true;
                }
                if (old.isEnabled() != user.isEnabled()) {
                    old.setEnabled(user.isEnabled());
                    userUpdated = true;
                }
                if ((groups = user.getGroups()) != null) {
                    old.setGroups(groups);
                    userUpdated = true;
                }
            } else if (old.getName().equals(authUser.getName())) {
                npw = user.getNewPassword();
                if (npw != null && !npw.isEmpty()) {
                    old.setNewPassword(user.getNewPassword());
                    userUpdated = true;
                } else {
                    old.setNewPassword(null);
                }
            }
            List attributeDto = user.getAttribute();
            if (attributeDto != null) {
                Iterator iteratorDto = attributeDto.iterator();
                ArrayList<UserAttribute> attributes = new ArrayList<UserAttribute>();
                while (iteratorDto.hasNext()) {
                    UserAttribute aDto = (UserAttribute)iteratorDto.next();
                    UserAttribute a = new UserAttribute();
                    a.setValue(aDto.getValue());
                    a.setName(aDto.getName());
                    attributes.add(a);
                }
                if (attributes.size() > 0) {
                    this.userService.updateAttributes(id, attributes);
                }
            }
            if (userUpdated) {
                old.setAttribute(null);
                id = this.userService.update(old);
                return id;
            }
            return -1L;
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        boolean ret = this.userService.delete(id);
        if (!ret) {
            throw new NotFoundWebEx("User not found");
        }
    }

    public User get(SecurityContext sc, long id, boolean includeAttributes) throws NotFoundWebEx {
        if (id == -1L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retriving dummy data !");
            }
            User user = new User();
            user.setName("dummy name");
            return user;
        }
        User authUser = this.userService.get(id);
        if (authUser == null) {
            throw new NotFoundWebEx("User not found");
        }
        User ret = new User();
        ret.setId(authUser.getId());
        ret.setName(authUser.getName());
        ret.setRole(authUser.getRole());
        ret.setEnabled(authUser.isEnabled());
        ret.setGroups(this.removeReservedGroups(authUser.getGroups()));
        if (includeAttributes) {
            ret.setAttribute(authUser.getAttribute());
        }
        return ret;
    }

    public User get(SecurityContext sc, String name, boolean includeAttributes) throws NotFoundWebEx {
        User ret;
        if (name == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User Name is null !");
            }
            throw new BadRequestWebEx("User name is null");
        }
        try {
            ret = this.userService.get(name);
            if (includeAttributes) {
                ret.setAttribute(ret.getAttribute());
            } else {
                ret.setAttribute(null);
            }
            ret.setGroups(this.removeReservedGroups(ret.getGroups()));
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx("User not found");
        }
        return ret;
    }

    public UserList getAll(SecurityContext sc, Integer page, Integer entries) throws BadRequestWebEx {
        try {
            List userList = this.userService.getAll(page, entries);
            Iterator iterator = userList.iterator();
            ArrayList<RESTUser> restUSERList = new ArrayList<RESTUser>();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                RESTUser restUser = new RESTUser(user.getId(), user.getName(), user.getRole(), user.getGroups(), false);
                restUSERList.add(restUser);
            }
            return new UserList(restUSERList);
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
    }

    public long getCount(SecurityContext sc, String nameLike) {
        return this.userService.getCount(RESTUserServiceImpl.convertNameLikeToSqlSyntax(nameLike));
    }

    public User getAuthUserDetails(SecurityContext sc, boolean includeAttributes) {
        User authUser = this.extractAuthUser(sc);
        User ret = null;
        try {
            if (!authUser.isTrusted()) {
                authUser = this.userService.get(authUser.getName());
            }
            if (authUser != null) {
                if (authUser.getRole().equals((Object)Role.GUEST)) {
                    throw new NotFoundWebEx("User not found");
                }
                ret = new User();
                ret.setId(authUser.getId());
                ret.setName(authUser.getName());
                ret.setRole(authUser.getRole());
                ret.setGroups(authUser.getGroups());
                if (includeAttributes) {
                    ret.setAttribute(authUser.getAttribute());
                }
            }
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx("User not found");
        }
        return ret;
    }

    public UserList getUserList(SecurityContext sc, String nameLike, Integer page, Integer entries, boolean includeAttributes) throws BadRequestWebEx {
        try {
            List userList = this.userService.getAll(page, entries, RESTUserServiceImpl.convertNameLikeToSqlSyntax(nameLike), includeAttributes);
            Iterator iterator = userList.iterator();
            ArrayList<RESTUser> restUserList = new ArrayList<RESTUser>();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                RESTUser restUser = new RESTUser(user.getId(), user.getName(), user.getRole(), user.getGroups(), false);
                restUserList.add(restUser);
            }
            return new UserList(restUserList);
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
    }

    private Set<UserGroup> removeReservedGroups(Set<UserGroup> groups) {
        ArrayList<UserGroup> reserved = new ArrayList<UserGroup>();
        for (UserGroup ug : groups) {
            if (GroupReservedNames.isAllowedName((String)ug.getGroupName())) continue;
            reserved.add(ug);
        }
        for (UserGroup ug : reserved) {
            groups.remove(ug);
        }
        return groups;
    }
}

